/* SPDX-FileCopyrightText: 2024 Google LLC */
/* SPDX-License-Identifier: Apache-2.0 */



// DESCRIPTION:
// This test stops 24 minutes into a run.
// - Test that when we shut activity down at 24 minutes into a run that it is saved
// ----------------------------------------------------------------
// Sample captured at: 2016-03-01 20:05:00 local, 2016-03-02 04:05:00 GMT
AlgDlsMinuteData *activity_sample_run_shut_down_1(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  // NOTE: The TEST_ACTIVITY_TYPE is one of the KAlgActivityType enum values
  //> TEST_NAME run_shut_down_1
  //> TEST_VERSION 3
  //> TEST_ACTIVITY_TYPE 3
  //> TEST_ACTIVITY_TYPE_MIN 3
  //> TEST_ACTIVITY_TYPE_MAX 3
  //> TEST_LEN 30
  //> TEST_LEN_MIN 22
  //> TEST_LEN_MAX 26
  //> TEST_START_AT 557
  //> TEST_START_AT_MIN 554
  //> TEST_START_AT_MAX 560
  //> TEST_WEIGHT 1.0
  //> TEST_FORCE_SHUT_DOWN_AT 581

  // list of: {steps, orientation, vmc, light, plugged_in}
  static AlgDlsMinuteData samples[] = {
    { 0, 0x52, 2198, 206, 0},
    { 0, 0x52, 654, 186, 0},
    { 0, 0x42, 2706, 179, 0},
    { 0, 0x54, 764, 180, 0},
    { 0, 0x65, 812, 188, 0},
    { 0, 0x24, 1410, 178, 0},
    { 0, 0x55, 1076, 215, 0},
    { 0, 0x72, 1801, 197, 0},
    { 0, 0x42, 984, 186, 0},
    { 10, 0x50, 1864, 189, 0},
    { 3, 0x52, 3313, 194, 0},
    { 0, 0x43, 899, 192, 0},
    { 0, 0x53, 915, 195, 0},
    { 0, 0x54, 5650, 193, 0},
    { 0, 0x76, 3517, 185, 0},
    // 15: Local time: 2016-03-01 08:20:00 PM
    { 0, 0x75, 3267, 211, 0},
    { 0, 0x52, 2454, 180, 0},
    { 0, 0x52, 2824, 192, 0},
    { 10, 0x30, 924, 180, 0},
    { 0, 0x21, 705, 189, 0},
    { 0, 0x51, 1388, 205, 0},
    { 0, 0x54, 2791, 207, 0},
    { 0, 0x63, 1117, 207, 0},
    { 0, 0x64, 2704, 192, 0},
    { 0, 0x64, 4205, 193, 0},
    { 16, 0x52, 8231, 204, 0},
    { 16, 0x53, 5652, 205, 0},
    { 0, 0x52, 5975, 182, 0},
    { 20, 0x43, 7632, 194, 0},
    { 0, 0x52, 3698, 214, 0},
    // 30: Local time: 2016-03-01 08:35:00 PM
    { 0, 0x41, 5469, 179, 0},
    { 0, 0x53, 1573, 182, 0},
    { 22, 0x42, 7516, 175, 0},
    { 0, 0x41, 676, 159, 0},
    { 48, 0x34, 3292, 150, 0},
    { 101, 0x24, 4735, 171, 0},
    { 0, 0x75, 6674, 145, 0},
    { 0, 0x67, 1833, 145, 0},
    { 0, 0x68, 1126, 148, 0},
    { 0, 0x68, 208, 144, 0},
    { 0, 0x68, 1096, 144, 0},
    { 0, 0x66, 2257, 161, 0},
    { 0, 0x54, 6027, 150, 0},
    { 0, 0x44, 1360, 155, 0},
    { 0, 0x53, 543, 148, 0},
    // 45: Local time: 2016-03-01 08:50:00 PM
    { 40, 0x32, 4746, 151, 0},
    { 0, 0x63, 4964, 151, 0},
    { 0, 0x54, 2974, 148, 0},
    { 0, 0x55, 728, 147, 0},
    { 0, 0x45, 0, 149, 0},
    { 0, 0x45, 0, 147, 0},
    { 0, 0x35, 65, 147, 0},
    { 0, 0x35, 0, 146, 0},
    { 0, 0x35, 0, 146, 0},
    { 0, 0x35, 385, 143, 0},
    { 0, 0x55, 2799, 150, 0},
    { 0, 0x65, 4696, 150, 0},
    { 0, 0x65, 5052, 149, 0},
    { 0, 0x65, 4180, 150, 0},
    { 0, 0x44, 4378, 145, 0},
    // 60: Local time: 2016-03-01 09:05:00 PM
    { 0, 0x54, 1057, 144, 0},
    { 0, 0x64, 150, 144, 0},
    { 0, 0x74, 9, 145, 0},
    { 0, 0x53, 3827, 161, 0},
    { 0, 0x62, 6043, 153, 0},
    { 0, 0x71, 2382, 152, 0},
    { 0, 0x70, 1115, 151, 0},
    { 0, 0x62, 3581, 148, 0},
    { 0, 0x44, 3028, 146, 0},
    { 0, 0x52, 7967, 206, 0},
    { 0, 0x54, 10649, 162, 0},
    { 0, 0x41, 8564, 197, 0},
    { 0, 0x51, 3841, 197, 0},
    { 0, 0x55, 4413, 204, 0},
    { 0, 0x64, 2088, 166, 0},
    // 75: Local time: 2016-03-01 09:20:00 PM
    { 0, 0x63, 3696, 197, 0},
    { 0, 0x63, 4609, 194, 0},
    { 46, 0x41, 4519, 169, 0},
    { 22, 0x61, 6896, 146, 0},
    { 0, 0x73, 581, 164, 0},
    { 0, 0x64, 337, 180, 0},
    { 0, 0x55, 0, 180, 0},
    { 0, 0x55, 0, 180, 0},
    { 0, 0x55, 0, 180, 0},
    { 0, 0x55, 0, 175, 0},
    { 0, 0x55, 0, 150, 0},
    { 0, 0x61, 1046, 144, 0},
    { 0, 0x61, 0, 144, 0},
    { 0, 0x61, 0, 144, 0},
    { 0, 0x60, 926, 140, 0},
    // 90: Local time: 2016-03-01 09:35:00 PM
    { 0, 0x6f, 340, 145, 0},
    { 0, 0x60, 53, 145, 0},
    { 12, 0x61, 3617, 145, 0},
    { 0, 0x54, 354, 145, 0},
    { 0, 0x43, 549, 147, 0},
    { 0, 0x43, 0, 146, 0},
    { 0, 0x43, 726, 146, 0},
    { 0, 0x64, 0, 146, 0},
    { 0, 0x64, 0, 146, 0},
    { 0, 0x64, 366, 143, 0},
    { 0, 0x74, 92, 147, 0},
    { 0, 0x55, 0, 147, 0},
    { 0, 0x55, 0, 147, 0},
    { 0, 0x55, 0, 147, 0},
    { 0, 0x55, 0, 143, 0},
    // 105: Local time: 2016-03-01 09:50:00 PM
    { 0, 0x55, 3, 147, 0},
    { 10, 0x60, 2224, 147, 0},
    { 8, 0x79, 1637, 148, 0},
    { 0, 0x68, 0, 147, 0},
    { 0, 0x67, 221, 149, 0},
    { 0, 0x66, 123, 147, 0},
    { 0, 0x68, 562, 147, 0},
    { 0, 0x68, 610, 147, 0},
    { 0, 0x67, 595, 147, 0},
    { 0, 0x69, 260, 145, 0},
    { 0, 0x69, 0, 147, 0},
    { 0, 0x69, 0, 148, 0},
    { 0, 0x69, 0, 148, 0},
    { 0, 0x69, 0, 148, 0},
    { 0, 0x69, 0, 144, 0},
    // 120: Local time: 2016-03-01 10:05:00 PM
    { 0, 0x69, 0, 148, 0},
    { 0, 0x69, 0, 148, 0},
    { 0, 0x69, 0, 148, 0},
    { 0, 0x69, 0, 148, 0},
    { 0, 0x69, 0, 149, 0},
    { 0, 0x69, 0, 148, 0},
    { 0, 0x69, 0, 148, 0},
    { 0, 0x69, 0, 148, 0},
    { 0, 0x69, 0, 148, 0},
    { 0, 0x69, 0, 145, 0},
    { 0, 0x69, 0, 148, 0},
    { 0, 0x69, 0, 148, 0},
    { 0, 0x69, 0, 148, 0},
    { 0, 0x69, 0, 147, 0},
    { 0, 0x69, 0, 144, 0},
    // 135: Local time: 2016-03-01 10:20:00 PM
    { 0, 0x69, 0, 147, 0},
    { 0, 0x69, 0, 148, 0},
    { 0, 0x69, 0, 148, 0},
    { 0, 0x69, 0, 147, 0},
    { 0, 0x69, 0, 150, 0},
    { 0, 0x69, 0, 148, 0},
    { 0, 0x69, 0, 148, 0},
    { 0, 0x69, 0, 148, 0},
    { 0, 0x69, 0, 148, 0},
    { 0, 0x69, 0, 145, 0},
    { 0, 0x69, 348, 148, 0},
    { 25, 0x33, 1989, 195, 0},
    { 0, 0x25, 4565, 147, 0},
    { 0, 0x17, 3, 147, 0},
    { 0, 0x17, 0, 144, 0},
    // 150: Local time: 2016-03-01 10:35:00 PM
    { 0, 0x17, 0, 148, 0},
    { 0, 0x17, 0, 148, 0},
    { 0, 0x17, 0, 148, 0},
    { 0, 0x17, 0, 148, 0},
    { 0, 0x17, 0, 149, 0},
    { 0, 0x17, 0, 148, 0},
    { 0, 0x17, 0, 148, 0},
    { 0, 0x17, 0, 148, 0},
    { 0, 0x17, 0, 148, 0},
    { 0, 0x17, 0, 145, 0},
    { 0, 0x17, 0, 148, 0},
    { 0, 0x17, 0, 148, 0},
    { 0, 0x17, 0, 148, 0},
    { 0, 0x17, 0, 148, 0},
    { 0, 0x17, 0, 145, 0},
    // 165: Local time: 2016-03-01 10:50:00 PM
    { 0, 0x17, 0, 148, 0},
    { 0, 0x17, 0, 148, 0},
    { 0, 0x18, 65, 149, 0},
    { 0, 0x18, 0, 148, 0},
    { 0, 0x18, 0, 150, 0},
    { 0, 0x18, 0, 149, 0},
    { 0, 0x18, 0, 148, 0},
    { 0, 0x18, 0, 148, 0},
    { 0, 0x18, 0, 149, 0},
    { 0, 0x18, 0, 145, 0},
    { 0, 0x18, 0, 148, 0},
    { 0, 0x18, 0, 149, 0},
    { 0, 0x18, 0, 148, 0},
    { 0, 0x18, 0, 148, 0},
    { 0, 0x18, 0, 146, 0},
    // 180: Local time: 2016-03-01 11:05:00 PM
    { 0, 0x18, 0, 149, 0},
    { 0, 0x18, 0, 148, 0},
    { 0, 0x18, 0, 149, 0},
    { 0, 0x18, 0, 148, 0},
    { 0, 0x18, 0, 148, 0},
    { 0, 0x18, 0, 149, 0},
    { 0, 0x18, 0, 148, 0},
    { 0, 0x18, 0, 149, 0},
    { 0, 0x18, 0, 148, 0},
    { 0, 0x18, 0, 145, 0},
    { 0, 0x18, 0, 148, 0},
    { 0, 0x18, 11, 148, 0},
    { 0, 0x18, 0, 149, 0},
    { 0, 0x18, 0, 149, 0},
    { 0, 0x18, 0, 146, 0},
    // 195: Local time: 2016-03-01 11:20:00 PM
    { 0, 0x18, 0, 149, 0},
    { 0, 0x18, 0, 149, 0},
    { 0, 0x18, 0, 149, 0},
    { 0, 0x18, 0, 149, 0},
    { 0, 0x18, 0, 149, 0},
    { 0, 0x18, 0, 149, 0},
    { 0, 0x18, 0, 149, 0},
    { 0, 0x18, 0, 149, 0},
    { 0, 0x18, 0, 149, 0},
    { 0, 0x18, 0, 146, 0},
    { 0, 0x18, 0, 149, 0},
    { 0, 0x18, 0, 149, 0},
    { 0, 0x18, 0, 149, 0},
    { 0, 0x18, 0, 149, 0},
    { 0, 0x18, 0, 145, 0},
    // 210: Local time: 2016-03-01 11:35:00 PM
    { 0, 0x18, 0, 149, 0},
    { 0, 0x18, 0, 149, 0},
    { 0, 0x18, 0, 149, 0},
    { 0, 0x18, 0, 149, 0},
    { 0, 0x18, 0, 150, 0},
    { 0, 0x18, 0, 149, 0},
    { 0, 0x18, 0, 149, 0},
    { 0, 0x18, 0, 149, 0},
    { 0, 0x18, 0, 149, 0},
    { 0, 0x18, 0, 146, 0},
    { 0, 0x18, 0, 149, 0},
    { 0, 0x18, 0, 149, 0},
    { 0, 0x18, 0, 149, 0},
    { 0, 0x18, 0, 150, 0},
    { 0, 0x18, 0, 148, 0},
    // 225: Local time: 2016-03-01 11:50:00 PM
    { 0, 0x18, 0, 149, 0},
    { 0, 0x18, 0, 149, 0},
    { 0, 0x18, 0, 149, 0},
    { 0, 0x18, 0, 150, 0},
    { 0, 0x18, 0, 147, 0},
    { 0, 0x18, 0, 150, 0},
    { 0, 0x18, 0, 149, 0},
    { 0, 0x18, 0, 150, 0},
    { 0, 0x18, 0, 150, 0},
    { 0, 0x18, 0, 151, 0},
    { 0, 0x18, 0, 150, 0},
    { 0, 0x18, 0, 149, 0},
    { 0, 0x18, 0, 150, 0},
    { 0, 0x18, 0, 150, 0},
    { 0, 0x18, 0, 147, 0},
    // 240: Local time: 2016-03-02 12:05:00 AM
    { 0, 0x18, 0, 150, 0},
    { 0, 0x18, 0, 150, 0},
    { 0, 0x18, 34, 150, 0},
    { 0, 0x18, 0, 149, 0},
    { 0, 0x18, 0, 147, 0},
    { 0, 0x18, 0, 150, 0},
    { 0, 0x18, 0, 150, 0},
    { 0, 0x18, 0, 150, 0},
    { 0, 0x18, 0, 149, 0},
    { 0, 0x18, 0, 147, 0},
    { 0, 0x18, 0, 150, 0},
    { 0, 0x18, 0, 150, 0},
    { 0, 0x18, 0, 150, 0},
    { 0, 0x18, 0, 150, 0},
    { 0, 0x18, 0, 147, 0},
    // 255: Local time: 2016-03-02 12:20:00 AM
    { 0, 0x18, 0, 150, 0},
    { 0, 0x18, 0, 150, 0},
    { 0, 0x18, 0, 150, 0},
    { 0, 0x18, 0, 149, 0},
    { 0, 0x18, 0, 147, 0},
    { 0, 0x18, 0, 150, 0},
    { 0, 0x18, 0, 150, 0},
    { 0, 0x18, 0, 150, 0},
    { 0, 0x18, 0, 150, 0},
    { 0, 0x18, 0, 147, 0},
    { 0, 0x18, 0, 150, 0},
    { 0, 0x18, 0, 150, 0},
    { 0, 0x18, 0, 149, 0},
    { 0, 0x47, 1119, 149, 0},
    { 0, 0x74, 0, 146, 0},
    // 270: Local time: 2016-03-02 12:35:00 AM
    { 0, 0x74, 0, 149, 0},
    { 0, 0x74, 0, 149, 0},
    { 0, 0x74, 0, 149, 0},
    { 0, 0x74, 0, 149, 0},
    { 0, 0x74, 0, 151, 0},
    { 0, 0x74, 0, 149, 0},
    { 0, 0x74, 0, 149, 0},
    { 0, 0x74, 0, 149, 0},
    { 0, 0x84, 1069, 149, 0},
    { 0, 0x7d, 0, 146, 0},
    { 0, 0x7d, 0, 149, 0},
    { 0, 0x7d, 0, 149, 0},
    { 0, 0x7d, 0, 149, 0},
    { 0, 0x7d, 0, 149, 0},
    { 0, 0x7d, 0, 146, 0},
    // 285: Local time: 2016-03-02 12:50:00 AM
    { 0, 0x7d, 0, 149, 0},
    { 0, 0x7d, 0, 149, 0},
    { 0, 0x7d, 0, 149, 0},
    { 0, 0x7d, 0, 149, 0},
    { 0, 0x7d, 0, 133, 0},
    { 0, 0x7d, 0, 149, 0},
    { 0, 0x7d, 0, 149, 0},
    { 0, 0x7d, 0, 149, 0},
    { 0, 0x7d, 0, 150, 0},
    { 0, 0x7d, 0, 146, 0},
    { 0, 0x7d, 0, 149, 0},
    { 0, 0x7d, 0, 149, 0},
    { 0, 0x7d, 0, 149, 0},
    { 0, 0x7d, 0, 149, 0},
    { 0, 0x7c, 889, 147, 0},
    // 300: Local time: 2016-03-02 01:05:00 AM
    { 16, 0x32, 3536, 194, 0},
    { 12, 0x23, 2093, 165, 0},
    { 22, 0x74, 5937, 148, 0},
    { 5, 0x74, 863, 148, 0},
    { 0, 0x74, 0, 149, 0},
    { 12, 0x74, 2271, 148, 0},
    { 0, 0x74, 0, 148, 0},
    { 0, 0x74, 0, 148, 0},
    { 0, 0x74, 0, 148, 0},
    { 0, 0x74, 0, 145, 0},
    { 0, 0x74, 159, 148, 0},
    { 0, 0x74, 0, 148, 0},
    { 0, 0x74, 0, 148, 0},
    { 0, 0x74, 0, 148, 0},
    { 0, 0x74, 0, 145, 0},
    // 315: Local time: 2016-03-02 01:20:00 AM
    { 0, 0x74, 0, 148, 0},
    { 0, 0x74, 668, 148, 0},
    { 0, 0x64, 550, 148, 0},
    { 0, 0x74, 0, 148, 0},
    { 0, 0x74, 0, 149, 0},
    { 0, 0x74, 0, 148, 0},
    { 0, 0x74, 0, 148, 0},
    { 0, 0x74, 0, 148, 0},
    { 0, 0x74, 0, 148, 0},
    { 0, 0x74, 0, 145, 0},
    { 0, 0x74, 0, 148, 0},
    { 0, 0x74, 0, 148, 0},
    { 0, 0x74, 0, 148, 0},
    { 0, 0x74, 0, 148, 0},
    { 0, 0x74, 0, 144, 0},
    // 330: Local time: 2016-03-02 01:35:00 AM
    { 0, 0x74, 0, 148, 0},
    { 0, 0x74, 0, 148, 0},
    { 0, 0x74, 0, 148, 0},
    { 0, 0x74, 0, 148, 0},
    { 0, 0x74, 0, 149, 0},
    { 0, 0x74, 0, 148, 0},
    { 0, 0x74, 0, 148, 0},
    { 0, 0x74, 0, 148, 0},
    { 0, 0x74, 0, 148, 0},
    { 0, 0x74, 0, 144, 0},
    { 0, 0x74, 0, 148, 0},
    { 0, 0x74, 0, 148, 0},
    { 0, 0x74, 0, 148, 0},
    { 0, 0x74, 0, 148, 0},
    { 0, 0x74, 0, 144, 0},
    // 345: Local time: 2016-03-02 01:50:00 AM
    { 0, 0x74, 0, 148, 0},
    { 0, 0x74, 0, 148, 0},
    { 0, 0x74, 0, 148, 0},
    { 0, 0x74, 0, 148, 0},
    { 0, 0x74, 0, 146, 0},
    { 0, 0x7f, 604, 148, 0},
    { 0, 0x6e, 0, 147, 0},
    { 0, 0x6e, 0, 149, 0},
    { 0, 0x6e, 0, 147, 0},
    { 0, 0x6e, 0, 143, 0},
    { 0, 0x6e, 0, 147, 0},
    { 0, 0x6e, 0, 147, 0},
    { 0, 0x6e, 0, 147, 0},
    { 0, 0x6e, 0, 147, 0},
    { 0, 0x6e, 0, 143, 0},
    // 360: Local time: 2016-03-02 02:05:00 AM
    { 0, 0x6e, 0, 147, 0},
    { 0, 0x6e, 0, 147, 0},
    { 0, 0x6e, 0, 147, 0},
    { 0, 0x6e, 0, 147, 0},
    { 0, 0x6e, 0, 148, 0},
    { 0, 0x6e, 0, 147, 0},
    { 0, 0x6e, 0, 147, 0},
    { 0, 0x6e, 0, 147, 0},
    { 0, 0x6e, 0, 147, 0},
    { 0, 0x6f, 102, 143, 0},
    { 0, 0x6f, 0, 147, 0},
    { 0, 0x6f, 0, 147, 0},
    { 0, 0x6f, 0, 147, 0},
    { 0, 0x6f, 0, 147, 0},
    { 0, 0x6f, 0, 143, 0},
    // 375: Local time: 2016-03-02 02:20:00 AM
    { 0, 0x6f, 0, 147, 0},
    { 0, 0x6f, 0, 147, 0},
    { 0, 0x6f, 0, 147, 0},
    { 0, 0x6f, 0, 147, 0},
    { 0, 0x6f, 0, 149, 0},
    { 0, 0x6f, 0, 148, 0},
    { 0, 0x6f, 0, 147, 0},
    { 0, 0x6f, 0, 147, 0},
    { 0, 0x6f, 0, 147, 0},
    { 0, 0x6f, 0, 143, 0},
    { 12, 0x32, 1342, 147, 0},
    { 0, 0x23, 0, 147, 0},
    { 0, 0x23, 0, 148, 0},
    { 0, 0x23, 0, 148, 0},
    { 0, 0x23, 0, 145, 0},
    // 390: Local time: 2016-03-02 02:35:00 AM
    { 0, 0x23, 0, 148, 0},
    { 0, 0x23, 0, 148, 0},
    { 0, 0x23, 0, 149, 0},
    { 0, 0x23, 1895, 148, 0},
    { 0, 0x9, 0, 149, 0},
    { 0, 0x9, 0, 148, 0},
    { 0, 0x9, 0, 148, 0},
    { 0, 0x9, 0, 148, 0},
    { 0, 0x9, 0, 148, 0},
    { 0, 0x9, 0, 144, 0},
    { 0, 0x9, 0, 148, 0},
    { 0, 0x9, 0, 148, 0},
    { 0, 0x9, 0, 148, 0},
    { 0, 0x9, 0, 148, 0},
    { 0, 0x9, 0, 144, 0},
    // 405: Local time: 2016-03-02 02:50:00 AM
    { 0, 0x9, 0, 148, 0},
    { 0, 0x9, 0, 148, 0},
    { 0, 0x9, 0, 148, 0},
    { 0, 0x9, 0, 148, 0},
    { 0, 0x9, 0, 150, 0},
    { 0, 0x9, 0, 149, 0},
    { 0, 0x9, 0, 148, 0},
    { 0, 0x8, 0, 148, 0},
    { 0, 0x7, 0, 148, 0},
    { 0, 0x7, 0, 145, 0},
    { 0, 0x7, 0, 149, 0},
    { 0, 0x7, 0, 149, 0},
    { 0, 0x7, 0, 148, 0},
    { 0, 0x7, 0, 149, 0},
    { 0, 0x7, 0, 145, 0},
    // 420: Local time: 2016-03-02 03:05:00 AM
    { 0, 0x7, 0, 149, 0},
    { 0, 0x7, 0, 149, 0},
    { 0, 0x7, 0, 149, 0},
    { 0, 0x7, 0, 149, 0},
    { 0, 0x7, 0, 146, 0},
    { 0, 0x7, 0, 149, 0},
    { 0, 0x7, 0, 149, 0},
    { 0, 0x7, 0, 149, 0},
    { 0, 0x7, 0, 149, 0},
    { 0, 0x7, 0, 147, 0},
    { 0, 0x7, 0, 149, 0},
    { 0, 0x7, 0, 149, 0},
    { 0, 0x7, 0, 149, 0},
    { 0, 0x7, 0, 149, 0},
    { 0, 0x7, 0, 146, 0},
    // 435: Local time: 2016-03-02 03:20:00 AM
    { 0, 0x7, 0, 149, 0},
    { 0, 0x7, 0, 149, 0},
    { 0, 0x7, 113, 170, 0},
    { 0, 0x77, 774, 149, 0},
    { 0, 0x77, 0, 144, 0},
    { 0, 0x77, 0, 148, 0},
    { 0, 0x77, 0, 149, 0},
    { 0, 0x77, 0, 149, 0},
    { 0, 0x77, 0, 149, 0},
    { 0, 0x77, 0, 144, 0},
    { 0, 0x77, 0, 148, 0},
    { 0, 0x77, 0, 148, 0},
    { 0, 0x77, 0, 149, 0},
    { 0, 0x78, 258, 148, 0},
    { 0, 0x69, 0, 144, 0},
    // 450: Local time: 2016-03-02 03:35:00 AM
    { 0, 0x6a, 0, 148, 0},
    { 0, 0x78, 302, 148, 0},
    { 0, 0x78, 73, 148, 0},
    { 0, 0x78, 0, 148, 0},
    { 0, 0x78, 1155, 149, 0},
    { 0, 0x77, 0, 148, 0},
    { 0, 0x68, 1171, 148, 0},
    { 0, 0x69, 0, 148, 0},
    { 0, 0x69, 273, 148, 0},
    { 0, 0x68, 4750, 149, 0},
    { 0, 0x33, 3244, 172, 0},
    { 0, 0x71, 5763, 146, 0},
    { 0, 0x75, 7, 147, 0},
    { 0, 0x75, 0, 147, 0},
    { 0, 0x75, 0, 143, 0},
    // 465: Local time: 2016-03-02 03:50:00 AM
    { 0, 0x75, 0, 147, 0},
    { 0, 0x64, 235, 147, 0},
    { 0, 0x64, 0, 148, 0},
    { 0, 0x54, 2791, 148, 0},
    { 0, 0x66, 5, 149, 0},
    { 0, 0x68, 175, 148, 0},
    { 0, 0x68, 0, 148, 0},
    { 0, 0x68, 65, 148, 0},
    { 0, 0x68, 0, 148, 0},
    { 0, 0x57, 1820, 144, 0},
    { 0, 0x35, 196, 148, 0},
    { 0, 0x45, 0, 148, 0},
    { 0, 0x25, 396, 148, 0},
    { 33, 0x44, 6141, 154, 0},
    { 20, 0x60, 4448, 144, 0},
    // 480: Local time: 2016-03-02 04:05:00 AM
    { 0, 0x6f, 0, 148, 0},
    { 0, 0x6f, 21, 148, 0},
    { 0, 0x6f, 697, 148, 0},
    { 0, 0x6f, 884, 148, 0},
    { 12, 0x79, 2095, 149, 0},
    { 16, 0x69, 2109, 149, 0},
    { 0, 0x68, 785, 148, 0},
    { 15, 0x69, 1870, 148, 0},
    { 0, 0x58, 362, 148, 0},
    { 9, 0x66, 1036, 144, 0},
    { 10, 0x67, 2685, 147, 0},
    { 0, 0x66, 1905, 147, 0},
    { 0, 0x66, 1088, 147, 0},
    { 0, 0x65, 3, 147, 0},
    { 0, 0x66, 0, 143, 0},
    // 495: Local time: 2016-03-02 04:20:00 AM
    { 0, 0x65, 574, 147, 0},
    { 16, 0x47, 2209, 146, 0},
    { 0, 0x55, 402, 146, 0},
    { 0, 0x55, 28, 146, 0},
    { 16, 0x53, 5328, 160, 0},
    { 13, 0x53, 5607, 146, 0},
    { 15, 0x54, 1394, 146, 0},
    { 0, 0x34, 0, 146, 0},
    { 0, 0x34, 0, 147, 0},
    { 0, 0x34, 200, 143, 0},
    { 0, 0x34, 0, 147, 0},
    { 0, 0x34, 1, 147, 0},
    { 0, 0x34, 0, 147, 0},
    { 0, 0x34, 0, 147, 0},
    { 0, 0x34, 0, 145, 0},
    // 510: Local time: 2016-03-02 04:35:00 AM
    { 0, 0x34, 0, 147, 0},
    { 0, 0x34, 0, 148, 0},
    { 0, 0x34, 0, 148, 0},
    { 0, 0x34, 0, 148, 0},
    { 0, 0x34, 3, 147, 0},
    { 0, 0x25, 693, 147, 0},
    { 0, 0x25, 0, 147, 0},
    { 0, 0x25, 0, 147, 0},
    { 0, 0x25, 406, 148, 0},
    { 0, 0x55, 13, 144, 0},
    { 0, 0x55, 0, 148, 0},
    { 0, 0x55, 0, 147, 0},
    { 0, 0x55, 0, 147, 0},
    { 0, 0x78, 1282, 148, 0},
    { 0, 0x69, 356, 144, 0},
    // 525: Local time: 2016-03-02 04:50:00 AM
    { 0, 0x69, 0, 148, 0},
    { 0, 0x69, 498, 148, 0},
    { 0, 0x69, 7, 148, 0},
    { 0, 0x69, 0, 148, 0},
    { 0, 0x69, 0, 149, 0},
    { 0, 0x69, 0, 148, 0},
    { 0, 0x69, 0, 148, 0},
    { 0, 0x69, 75, 149, 0},
    { 0, 0x69, 19, 149, 0},
    { 0, 0x69, 0, 145, 0},
    { 0, 0x69, 13, 149, 0},
    { 0, 0x69, 0, 149, 0},
    { 0, 0x68, 456, 148, 0},
    { 0, 0x66, 0, 148, 0},
    { 0, 0x66, 194, 144, 0},
    // 540: Local time: 2016-03-02 05:05:00 AM
    { 10, 0x62, 6137, 165, 0},
    { 3, 0x54, 4972, 201, 0},
    { 0, 0x42, 5848, 183, 0},
    { 42, 0x51, 7518, 205, 0},
    { 0, 0x41, 4923, 197, 0},
    { 30, 0x52, 11279, 188, 0},
    { 29, 0x41, 2897, 159, 0},
    { 4, 0x42, 7688, 157, 0},
    { 0, 0x43, 5237, 155, 0},
    { 0, 0x44, 2868, 151, 0},
    { 0, 0x53, 4003, 186, 0},
    { 0, 0x45, 6307, 184, 0},
    { 16, 0x44, 3118, 176, 0},
    { 13, 0x42, 6085, 159, 0},
    { 108, 0x41, 3481, 141, 0},
    // 555: Local time: 2016-03-02 05:20:00 AM
    { 108, 0x40, 3475, 156, 0},
    { 66, 0x51, 7547, 147, 0},
    { 130, 0x42, 27135, 172, 0},
    { 143, 0x43, 28113, 34, 0},
    { 158, 0x33, 32012, 159, 0},
    { 157, 0x33, 31660, 171, 0},
    { 131, 0x33, 25700, 11, 0},
    { 156, 0x33, 33319, 169, 0},
    { 150, 0x33, 29836, 170, 0},
    { 156, 0x33, 29547, 150, 0},
    { 143, 0x33, 27790, 101, 0},
    { 155, 0x43, 29350, 176, 0},
    { 150, 0x43, 28766, 11, 0},
    { 138, 0x43, 26447, 160, 0},
    { 154, 0x43, 29240, 140, 0},
    // 570: Local time: 2016-03-02 05:35:00 AM
    { 156, 0x43, 29439, 172, 0},
    { 143, 0x43, 26958, 146, 0},
    { 154, 0x43, 29242, 30, 0},
    { 142, 0x43, 25648, 156, 0},
    { 156, 0x43, 30610, 173, 0},
    { 156, 0x43, 29337, 156, 0},
    { 143, 0x33, 26108, 166, 0},
    { 156, 0x33, 30065, 12, 0},
    { 156, 0x33, 32739, 161, 0},
    { 143, 0x33, 30082, 165, 0},
    { 156, 0x33, 32193, 171, 0},
    { 146, 0x33, 30874, 142, 0},
    { 158, 0x33, 34162, 100, 0},
    { 144, 0x33, 30993, 165, 0},
    { 157, 0x33, 32093, 179, 0},
    // 585: Local time: 2016-03-02 05:50:00 AM
    { 146, 0x33, 28974, 99, 0},
    { 156, 0x33, 33058, 172, 0},
    { 113, 0x43, 15388, 148, 0},
    { 84, 0x41, 4571, 158, 0},
    { 98, 0x41, 5580, 154, 0},
    { 99, 0x41, 4769, 144, 0},
    { 112, 0x41, 4875, 149, 0},
    { 77, 0x41, 5925, 146, 0},
    { 42, 0x52, 6890, 164, 0},
    { 27, 0x43, 7135, 181, 0},
    { 20, 0x64, 3922, 186, 0},
    { 0, 0x7c, 0, 187, 1},
    { 0, 0x7c, 0, 187, 1},
    { 0, 0x7c, 0, 187, 1},
    { 0, 0x7c, 0, 172, 1},
    // 600: Local time: 2016-03-02 06:05:00 AM
    { 0, 0x7c, 0, 187, 1},
    { 0, 0x7c, 0, 187, 1},
    { 0, 0x7c, 0, 187, 1},
    { 0, 0x7c, 0, 172, 1},
    { 0, 0x7c, 0, 172, 1},
    { 0, 0x7c, 0, 187, 1},
    { 0, 0x7c, 0, 187, 1},
    { 0, 0x7c, 0, 172, 1},
    { 0, 0x7c, 0, 187, 1},
    { 0, 0x7c, 0, 187, 1},
    { 0, 0x7c, 0, 187, 1},
    { 0, 0x7c, 0, 187, 1},
    { 0, 0x7c, 0, 187, 1},
    { 0, 0x7c, 0, 187, 1},
    { 0, 0x7c, 0, 187, 1},
    // 615: Local time: 2016-03-02 06:20:00 AM
    { 0, 0x7c, 0, 187, 1},
    { 0, 0x7c, 0, 187, 1},
    { 0, 0x7c, 0, 187, 1},
    { 0, 0x7c, 0, 187, 1},
    { 0, 0x7c, 0, 173, 1},
    { 0, 0x7c, 0, 173, 1},
    { 0, 0x7c, 0, 179, 1},
    { 0, 0x7c, 0, 187, 1},
    { 0, 0x7c, 0, 187, 1},
    { 0, 0x7c, 0, 187, 1},
    { 0, 0x7c, 0, 188, 1},
    { 0, 0x7c, 0, 187, 1},
    { 0, 0x7c, 0, 187, 1},
    { 0, 0x7c, 0, 188, 1},
    { 0, 0x7c, 0, 187, 1},
    // 630: Local time: 2016-03-02 06:35:00 AM
    { 0, 0x7c, 0, 187, 1},
    { 0, 0x7c, 0, 188, 1},
    { 0, 0x7c, 0, 188, 1},
    { 0, 0x7c, 0, 176, 1},
    { 0, 0x7c, 0, 173, 1},
    { 0, 0x7c, 0, 188, 1},
    { 0, 0x7c, 0, 188, 1},
    { 0, 0x7c, 0, 188, 1},
    { 0, 0x7c, 0, 188, 1},
    { 0, 0x7c, 0, 188, 1},
    { 0, 0x7c, 0, 189, 1},
    { 0, 0x7c, 0, 185, 1},
    { 0, 0x7c, 0, 188, 1},
    { 0, 0x7c, 0, 188, 1},
    { 0, 0x7c, 0, 188, 1},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}





// DESCRIPTION:
// This test stops 9 minutes into a run.
// - Test that when we shut activity down at 9 minutes into a run that nothing is saved.
// ----------------------------------------------------------------
// Sample captured at: 2016-03-01 20:05:00 local, 2016-03-02 04:05:00 GMT
AlgDlsMinuteData *activity_sample_run_shut_down_2(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  // NOTE: The TEST_ACTIVITY_TYPE is one of the KAlgActivityType enum values
  //> TEST_NAME run_shut_down_2
  //> TEST_VERSION 3
  //> TEST_ACTIVITY_TYPE 0
  //> TEST_ACTIVITY_TYPE_MIN 0
  //> TEST_ACTIVITY_TYPE_MAX 0
  //> TEST_LEN 0
  //> TEST_LEN_MIN 0
  //> TEST_LEN_MAX 0
  //> TEST_START_AT 0
  //> TEST_START_AT_MIN 0
  //> TEST_START_AT_MAX 0
  //> TEST_WEIGHT 1.0
  //> TEST_FORCE_SHUT_DOWN_AT 564

  // list of: {steps, orientation, vmc, light, plugged_in}
  static AlgDlsMinuteData samples[] = {
    { 0, 0x52, 2198, 206, 0},
    { 0, 0x52, 654, 186, 0},
    { 0, 0x42, 2706, 179, 0},
    { 0, 0x54, 764, 180, 0},
    { 0, 0x65, 812, 188, 0},
    { 0, 0x24, 1410, 178, 0},
    { 0, 0x55, 1076, 215, 0},
    { 0, 0x72, 1801, 197, 0},
    { 0, 0x42, 984, 186, 0},
    { 10, 0x50, 1864, 189, 0},
    { 3, 0x52, 3313, 194, 0},
    { 0, 0x43, 899, 192, 0},
    { 0, 0x53, 915, 195, 0},
    { 0, 0x54, 5650, 193, 0},
    { 0, 0x76, 3517, 185, 0},
    // 15: Local time: 2016-03-01 08:20:00 PM
    { 0, 0x75, 3267, 211, 0},
    { 0, 0x52, 2454, 180, 0},
    { 0, 0x52, 2824, 192, 0},
    { 10, 0x30, 924, 180, 0},
    { 0, 0x21, 705, 189, 0},
    { 0, 0x51, 1388, 205, 0},
    { 0, 0x54, 2791, 207, 0},
    { 0, 0x63, 1117, 207, 0},
    { 0, 0x64, 2704, 192, 0},
    { 0, 0x64, 4205, 193, 0},
    { 16, 0x52, 8231, 204, 0},
    { 16, 0x53, 5652, 205, 0},
    { 0, 0x52, 5975, 182, 0},
    { 20, 0x43, 7632, 194, 0},
    { 0, 0x52, 3698, 214, 0},
    // 30: Local time: 2016-03-01 08:35:00 PM
    { 0, 0x41, 5469, 179, 0},
    { 0, 0x53, 1573, 182, 0},
    { 22, 0x42, 7516, 175, 0},
    { 0, 0x41, 676, 159, 0},
    { 48, 0x34, 3292, 150, 0},
    { 101, 0x24, 4735, 171, 0},
    { 0, 0x75, 6674, 145, 0},
    { 0, 0x67, 1833, 145, 0},
    { 0, 0x68, 1126, 148, 0},
    { 0, 0x68, 208, 144, 0},
    { 0, 0x68, 1096, 144, 0},
    { 0, 0x66, 2257, 161, 0},
    { 0, 0x54, 6027, 150, 0},
    { 0, 0x44, 1360, 155, 0},
    { 0, 0x53, 543, 148, 0},
    // 45: Local time: 2016-03-01 08:50:00 PM
    { 40, 0x32, 4746, 151, 0},
    { 0, 0x63, 4964, 151, 0},
    { 0, 0x54, 2974, 148, 0},
    { 0, 0x55, 728, 147, 0},
    { 0, 0x45, 0, 149, 0},
    { 0, 0x45, 0, 147, 0},
    { 0, 0x35, 65, 147, 0},
    { 0, 0x35, 0, 146, 0},
    { 0, 0x35, 0, 146, 0},
    { 0, 0x35, 385, 143, 0},
    { 0, 0x55, 2799, 150, 0},
    { 0, 0x65, 4696, 150, 0},
    { 0, 0x65, 5052, 149, 0},
    { 0, 0x65, 4180, 150, 0},
    { 0, 0x44, 4378, 145, 0},
    // 60: Local time: 2016-03-01 09:05:00 PM
    { 0, 0x54, 1057, 144, 0},
    { 0, 0x64, 150, 144, 0},
    { 0, 0x74, 9, 145, 0},
    { 0, 0x53, 3827, 161, 0},
    { 0, 0x62, 6043, 153, 0},
    { 0, 0x71, 2382, 152, 0},
    { 0, 0x70, 1115, 151, 0},
    { 0, 0x62, 3581, 148, 0},
    { 0, 0x44, 3028, 146, 0},
    { 0, 0x52, 7967, 206, 0},
    { 0, 0x54, 10649, 162, 0},
    { 0, 0x41, 8564, 197, 0},
    { 0, 0x51, 3841, 197, 0},
    { 0, 0x55, 4413, 204, 0},
    { 0, 0x64, 2088, 166, 0},
    // 75: Local time: 2016-03-01 09:20:00 PM
    { 0, 0x63, 3696, 197, 0},
    { 0, 0x63, 4609, 194, 0},
    { 46, 0x41, 4519, 169, 0},
    { 22, 0x61, 6896, 146, 0},
    { 0, 0x73, 581, 164, 0},
    { 0, 0x64, 337, 180, 0},
    { 0, 0x55, 0, 180, 0},
    { 0, 0x55, 0, 180, 0},
    { 0, 0x55, 0, 180, 0},
    { 0, 0x55, 0, 175, 0},
    { 0, 0x55, 0, 150, 0},
    { 0, 0x61, 1046, 144, 0},
    { 0, 0x61, 0, 144, 0},
    { 0, 0x61, 0, 144, 0},
    { 0, 0x60, 926, 140, 0},
    // 90: Local time: 2016-03-01 09:35:00 PM
    { 0, 0x6f, 340, 145, 0},
    { 0, 0x60, 53, 145, 0},
    { 12, 0x61, 3617, 145, 0},
    { 0, 0x54, 354, 145, 0},
    { 0, 0x43, 549, 147, 0},
    { 0, 0x43, 0, 146, 0},
    { 0, 0x43, 726, 146, 0},
    { 0, 0x64, 0, 146, 0},
    { 0, 0x64, 0, 146, 0},
    { 0, 0x64, 366, 143, 0},
    { 0, 0x74, 92, 147, 0},
    { 0, 0x55, 0, 147, 0},
    { 0, 0x55, 0, 147, 0},
    { 0, 0x55, 0, 147, 0},
    { 0, 0x55, 0, 143, 0},
    // 105: Local time: 2016-03-01 09:50:00 PM
    { 0, 0x55, 3, 147, 0},
    { 10, 0x60, 2224, 147, 0},
    { 8, 0x79, 1637, 148, 0},
    { 0, 0x68, 0, 147, 0},
    { 0, 0x67, 221, 149, 0},
    { 0, 0x66, 123, 147, 0},
    { 0, 0x68, 562, 147, 0},
    { 0, 0x68, 610, 147, 0},
    { 0, 0x67, 595, 147, 0},
    { 0, 0x69, 260, 145, 0},
    { 0, 0x69, 0, 147, 0},
    { 0, 0x69, 0, 148, 0},
    { 0, 0x69, 0, 148, 0},
    { 0, 0x69, 0, 148, 0},
    { 0, 0x69, 0, 144, 0},
    // 120: Local time: 2016-03-01 10:05:00 PM
    { 0, 0x69, 0, 148, 0},
    { 0, 0x69, 0, 148, 0},
    { 0, 0x69, 0, 148, 0},
    { 0, 0x69, 0, 148, 0},
    { 0, 0x69, 0, 149, 0},
    { 0, 0x69, 0, 148, 0},
    { 0, 0x69, 0, 148, 0},
    { 0, 0x69, 0, 148, 0},
    { 0, 0x69, 0, 148, 0},
    { 0, 0x69, 0, 145, 0},
    { 0, 0x69, 0, 148, 0},
    { 0, 0x69, 0, 148, 0},
    { 0, 0x69, 0, 148, 0},
    { 0, 0x69, 0, 147, 0},
    { 0, 0x69, 0, 144, 0},
    // 135: Local time: 2016-03-01 10:20:00 PM
    { 0, 0x69, 0, 147, 0},
    { 0, 0x69, 0, 148, 0},
    { 0, 0x69, 0, 148, 0},
    { 0, 0x69, 0, 147, 0},
    { 0, 0x69, 0, 150, 0},
    { 0, 0x69, 0, 148, 0},
    { 0, 0x69, 0, 148, 0},
    { 0, 0x69, 0, 148, 0},
    { 0, 0x69, 0, 148, 0},
    { 0, 0x69, 0, 145, 0},
    { 0, 0x69, 348, 148, 0},
    { 25, 0x33, 1989, 195, 0},
    { 0, 0x25, 4565, 147, 0},
    { 0, 0x17, 3, 147, 0},
    { 0, 0x17, 0, 144, 0},
    // 150: Local time: 2016-03-01 10:35:00 PM
    { 0, 0x17, 0, 148, 0},
    { 0, 0x17, 0, 148, 0},
    { 0, 0x17, 0, 148, 0},
    { 0, 0x17, 0, 148, 0},
    { 0, 0x17, 0, 149, 0},
    { 0, 0x17, 0, 148, 0},
    { 0, 0x17, 0, 148, 0},
    { 0, 0x17, 0, 148, 0},
    { 0, 0x17, 0, 148, 0},
    { 0, 0x17, 0, 145, 0},
    { 0, 0x17, 0, 148, 0},
    { 0, 0x17, 0, 148, 0},
    { 0, 0x17, 0, 148, 0},
    { 0, 0x17, 0, 148, 0},
    { 0, 0x17, 0, 145, 0},
    // 165: Local time: 2016-03-01 10:50:00 PM
    { 0, 0x17, 0, 148, 0},
    { 0, 0x17, 0, 148, 0},
    { 0, 0x18, 65, 149, 0},
    { 0, 0x18, 0, 148, 0},
    { 0, 0x18, 0, 150, 0},
    { 0, 0x18, 0, 149, 0},
    { 0, 0x18, 0, 148, 0},
    { 0, 0x18, 0, 148, 0},
    { 0, 0x18, 0, 149, 0},
    { 0, 0x18, 0, 145, 0},
    { 0, 0x18, 0, 148, 0},
    { 0, 0x18, 0, 149, 0},
    { 0, 0x18, 0, 148, 0},
    { 0, 0x18, 0, 148, 0},
    { 0, 0x18, 0, 146, 0},
    // 180: Local time: 2016-03-01 11:05:00 PM
    { 0, 0x18, 0, 149, 0},
    { 0, 0x18, 0, 148, 0},
    { 0, 0x18, 0, 149, 0},
    { 0, 0x18, 0, 148, 0},
    { 0, 0x18, 0, 148, 0},
    { 0, 0x18, 0, 149, 0},
    { 0, 0x18, 0, 148, 0},
    { 0, 0x18, 0, 149, 0},
    { 0, 0x18, 0, 148, 0},
    { 0, 0x18, 0, 145, 0},
    { 0, 0x18, 0, 148, 0},
    { 0, 0x18, 11, 148, 0},
    { 0, 0x18, 0, 149, 0},
    { 0, 0x18, 0, 149, 0},
    { 0, 0x18, 0, 146, 0},
    // 195: Local time: 2016-03-01 11:20:00 PM
    { 0, 0x18, 0, 149, 0},
    { 0, 0x18, 0, 149, 0},
    { 0, 0x18, 0, 149, 0},
    { 0, 0x18, 0, 149, 0},
    { 0, 0x18, 0, 149, 0},
    { 0, 0x18, 0, 149, 0},
    { 0, 0x18, 0, 149, 0},
    { 0, 0x18, 0, 149, 0},
    { 0, 0x18, 0, 149, 0},
    { 0, 0x18, 0, 146, 0},
    { 0, 0x18, 0, 149, 0},
    { 0, 0x18, 0, 149, 0},
    { 0, 0x18, 0, 149, 0},
    { 0, 0x18, 0, 149, 0},
    { 0, 0x18, 0, 145, 0},
    // 210: Local time: 2016-03-01 11:35:00 PM
    { 0, 0x18, 0, 149, 0},
    { 0, 0x18, 0, 149, 0},
    { 0, 0x18, 0, 149, 0},
    { 0, 0x18, 0, 149, 0},
    { 0, 0x18, 0, 150, 0},
    { 0, 0x18, 0, 149, 0},
    { 0, 0x18, 0, 149, 0},
    { 0, 0x18, 0, 149, 0},
    { 0, 0x18, 0, 149, 0},
    { 0, 0x18, 0, 146, 0},
    { 0, 0x18, 0, 149, 0},
    { 0, 0x18, 0, 149, 0},
    { 0, 0x18, 0, 149, 0},
    { 0, 0x18, 0, 150, 0},
    { 0, 0x18, 0, 148, 0},
    // 225: Local time: 2016-03-01 11:50:00 PM
    { 0, 0x18, 0, 149, 0},
    { 0, 0x18, 0, 149, 0},
    { 0, 0x18, 0, 149, 0},
    { 0, 0x18, 0, 150, 0},
    { 0, 0x18, 0, 147, 0},
    { 0, 0x18, 0, 150, 0},
    { 0, 0x18, 0, 149, 0},
    { 0, 0x18, 0, 150, 0},
    { 0, 0x18, 0, 150, 0},
    { 0, 0x18, 0, 151, 0},
    { 0, 0x18, 0, 150, 0},
    { 0, 0x18, 0, 149, 0},
    { 0, 0x18, 0, 150, 0},
    { 0, 0x18, 0, 150, 0},
    { 0, 0x18, 0, 147, 0},
    // 240: Local time: 2016-03-02 12:05:00 AM
    { 0, 0x18, 0, 150, 0},
    { 0, 0x18, 0, 150, 0},
    { 0, 0x18, 34, 150, 0},
    { 0, 0x18, 0, 149, 0},
    { 0, 0x18, 0, 147, 0},
    { 0, 0x18, 0, 150, 0},
    { 0, 0x18, 0, 150, 0},
    { 0, 0x18, 0, 150, 0},
    { 0, 0x18, 0, 149, 0},
    { 0, 0x18, 0, 147, 0},
    { 0, 0x18, 0, 150, 0},
    { 0, 0x18, 0, 150, 0},
    { 0, 0x18, 0, 150, 0},
    { 0, 0x18, 0, 150, 0},
    { 0, 0x18, 0, 147, 0},
    // 255: Local time: 2016-03-02 12:20:00 AM
    { 0, 0x18, 0, 150, 0},
    { 0, 0x18, 0, 150, 0},
    { 0, 0x18, 0, 150, 0},
    { 0, 0x18, 0, 149, 0},
    { 0, 0x18, 0, 147, 0},
    { 0, 0x18, 0, 150, 0},
    { 0, 0x18, 0, 150, 0},
    { 0, 0x18, 0, 150, 0},
    { 0, 0x18, 0, 150, 0},
    { 0, 0x18, 0, 147, 0},
    { 0, 0x18, 0, 150, 0},
    { 0, 0x18, 0, 150, 0},
    { 0, 0x18, 0, 149, 0},
    { 0, 0x47, 1119, 149, 0},
    { 0, 0x74, 0, 146, 0},
    // 270: Local time: 2016-03-02 12:35:00 AM
    { 0, 0x74, 0, 149, 0},
    { 0, 0x74, 0, 149, 0},
    { 0, 0x74, 0, 149, 0},
    { 0, 0x74, 0, 149, 0},
    { 0, 0x74, 0, 151, 0},
    { 0, 0x74, 0, 149, 0},
    { 0, 0x74, 0, 149, 0},
    { 0, 0x74, 0, 149, 0},
    { 0, 0x84, 1069, 149, 0},
    { 0, 0x7d, 0, 146, 0},
    { 0, 0x7d, 0, 149, 0},
    { 0, 0x7d, 0, 149, 0},
    { 0, 0x7d, 0, 149, 0},
    { 0, 0x7d, 0, 149, 0},
    { 0, 0x7d, 0, 146, 0},
    // 285: Local time: 2016-03-02 12:50:00 AM
    { 0, 0x7d, 0, 149, 0},
    { 0, 0x7d, 0, 149, 0},
    { 0, 0x7d, 0, 149, 0},
    { 0, 0x7d, 0, 149, 0},
    { 0, 0x7d, 0, 133, 0},
    { 0, 0x7d, 0, 149, 0},
    { 0, 0x7d, 0, 149, 0},
    { 0, 0x7d, 0, 149, 0},
    { 0, 0x7d, 0, 150, 0},
    { 0, 0x7d, 0, 146, 0},
    { 0, 0x7d, 0, 149, 0},
    { 0, 0x7d, 0, 149, 0},
    { 0, 0x7d, 0, 149, 0},
    { 0, 0x7d, 0, 149, 0},
    { 0, 0x7c, 889, 147, 0},
    // 300: Local time: 2016-03-02 01:05:00 AM
    { 16, 0x32, 3536, 194, 0},
    { 12, 0x23, 2093, 165, 0},
    { 22, 0x74, 5937, 148, 0},
    { 5, 0x74, 863, 148, 0},
    { 0, 0x74, 0, 149, 0},
    { 12, 0x74, 2271, 148, 0},
    { 0, 0x74, 0, 148, 0},
    { 0, 0x74, 0, 148, 0},
    { 0, 0x74, 0, 148, 0},
    { 0, 0x74, 0, 145, 0},
    { 0, 0x74, 159, 148, 0},
    { 0, 0x74, 0, 148, 0},
    { 0, 0x74, 0, 148, 0},
    { 0, 0x74, 0, 148, 0},
    { 0, 0x74, 0, 145, 0},
    // 315: Local time: 2016-03-02 01:20:00 AM
    { 0, 0x74, 0, 148, 0},
    { 0, 0x74, 668, 148, 0},
    { 0, 0x64, 550, 148, 0},
    { 0, 0x74, 0, 148, 0},
    { 0, 0x74, 0, 149, 0},
    { 0, 0x74, 0, 148, 0},
    { 0, 0x74, 0, 148, 0},
    { 0, 0x74, 0, 148, 0},
    { 0, 0x74, 0, 148, 0},
    { 0, 0x74, 0, 145, 0},
    { 0, 0x74, 0, 148, 0},
    { 0, 0x74, 0, 148, 0},
    { 0, 0x74, 0, 148, 0},
    { 0, 0x74, 0, 148, 0},
    { 0, 0x74, 0, 144, 0},
    // 330: Local time: 2016-03-02 01:35:00 AM
    { 0, 0x74, 0, 148, 0},
    { 0, 0x74, 0, 148, 0},
    { 0, 0x74, 0, 148, 0},
    { 0, 0x74, 0, 148, 0},
    { 0, 0x74, 0, 149, 0},
    { 0, 0x74, 0, 148, 0},
    { 0, 0x74, 0, 148, 0},
    { 0, 0x74, 0, 148, 0},
    { 0, 0x74, 0, 148, 0},
    { 0, 0x74, 0, 144, 0},
    { 0, 0x74, 0, 148, 0},
    { 0, 0x74, 0, 148, 0},
    { 0, 0x74, 0, 148, 0},
    { 0, 0x74, 0, 148, 0},
    { 0, 0x74, 0, 144, 0},
    // 345: Local time: 2016-03-02 01:50:00 AM
    { 0, 0x74, 0, 148, 0},
    { 0, 0x74, 0, 148, 0},
    { 0, 0x74, 0, 148, 0},
    { 0, 0x74, 0, 148, 0},
    { 0, 0x74, 0, 146, 0},
    { 0, 0x7f, 604, 148, 0},
    { 0, 0x6e, 0, 147, 0},
    { 0, 0x6e, 0, 149, 0},
    { 0, 0x6e, 0, 147, 0},
    { 0, 0x6e, 0, 143, 0},
    { 0, 0x6e, 0, 147, 0},
    { 0, 0x6e, 0, 147, 0},
    { 0, 0x6e, 0, 147, 0},
    { 0, 0x6e, 0, 147, 0},
    { 0, 0x6e, 0, 143, 0},
    // 360: Local time: 2016-03-02 02:05:00 AM
    { 0, 0x6e, 0, 147, 0},
    { 0, 0x6e, 0, 147, 0},
    { 0, 0x6e, 0, 147, 0},
    { 0, 0x6e, 0, 147, 0},
    { 0, 0x6e, 0, 148, 0},
    { 0, 0x6e, 0, 147, 0},
    { 0, 0x6e, 0, 147, 0},
    { 0, 0x6e, 0, 147, 0},
    { 0, 0x6e, 0, 147, 0},
    { 0, 0x6f, 102, 143, 0},
    { 0, 0x6f, 0, 147, 0},
    { 0, 0x6f, 0, 147, 0},
    { 0, 0x6f, 0, 147, 0},
    { 0, 0x6f, 0, 147, 0},
    { 0, 0x6f, 0, 143, 0},
    // 375: Local time: 2016-03-02 02:20:00 AM
    { 0, 0x6f, 0, 147, 0},
    { 0, 0x6f, 0, 147, 0},
    { 0, 0x6f, 0, 147, 0},
    { 0, 0x6f, 0, 147, 0},
    { 0, 0x6f, 0, 149, 0},
    { 0, 0x6f, 0, 148, 0},
    { 0, 0x6f, 0, 147, 0},
    { 0, 0x6f, 0, 147, 0},
    { 0, 0x6f, 0, 147, 0},
    { 0, 0x6f, 0, 143, 0},
    { 12, 0x32, 1342, 147, 0},
    { 0, 0x23, 0, 147, 0},
    { 0, 0x23, 0, 148, 0},
    { 0, 0x23, 0, 148, 0},
    { 0, 0x23, 0, 145, 0},
    // 390: Local time: 2016-03-02 02:35:00 AM
    { 0, 0x23, 0, 148, 0},
    { 0, 0x23, 0, 148, 0},
    { 0, 0x23, 0, 149, 0},
    { 0, 0x23, 1895, 148, 0},
    { 0, 0x9, 0, 149, 0},
    { 0, 0x9, 0, 148, 0},
    { 0, 0x9, 0, 148, 0},
    { 0, 0x9, 0, 148, 0},
    { 0, 0x9, 0, 148, 0},
    { 0, 0x9, 0, 144, 0},
    { 0, 0x9, 0, 148, 0},
    { 0, 0x9, 0, 148, 0},
    { 0, 0x9, 0, 148, 0},
    { 0, 0x9, 0, 148, 0},
    { 0, 0x9, 0, 144, 0},
    // 405: Local time: 2016-03-02 02:50:00 AM
    { 0, 0x9, 0, 148, 0},
    { 0, 0x9, 0, 148, 0},
    { 0, 0x9, 0, 148, 0},
    { 0, 0x9, 0, 148, 0},
    { 0, 0x9, 0, 150, 0},
    { 0, 0x9, 0, 149, 0},
    { 0, 0x9, 0, 148, 0},
    { 0, 0x8, 0, 148, 0},
    { 0, 0x7, 0, 148, 0},
    { 0, 0x7, 0, 145, 0},
    { 0, 0x7, 0, 149, 0},
    { 0, 0x7, 0, 149, 0},
    { 0, 0x7, 0, 148, 0},
    { 0, 0x7, 0, 149, 0},
    { 0, 0x7, 0, 145, 0},
    // 420: Local time: 2016-03-02 03:05:00 AM
    { 0, 0x7, 0, 149, 0},
    { 0, 0x7, 0, 149, 0},
    { 0, 0x7, 0, 149, 0},
    { 0, 0x7, 0, 149, 0},
    { 0, 0x7, 0, 146, 0},
    { 0, 0x7, 0, 149, 0},
    { 0, 0x7, 0, 149, 0},
    { 0, 0x7, 0, 149, 0},
    { 0, 0x7, 0, 149, 0},
    { 0, 0x7, 0, 147, 0},
    { 0, 0x7, 0, 149, 0},
    { 0, 0x7, 0, 149, 0},
    { 0, 0x7, 0, 149, 0},
    { 0, 0x7, 0, 149, 0},
    { 0, 0x7, 0, 146, 0},
    // 435: Local time: 2016-03-02 03:20:00 AM
    { 0, 0x7, 0, 149, 0},
    { 0, 0x7, 0, 149, 0},
    { 0, 0x7, 113, 170, 0},
    { 0, 0x77, 774, 149, 0},
    { 0, 0x77, 0, 144, 0},
    { 0, 0x77, 0, 148, 0},
    { 0, 0x77, 0, 149, 0},
    { 0, 0x77, 0, 149, 0},
    { 0, 0x77, 0, 149, 0},
    { 0, 0x77, 0, 144, 0},
    { 0, 0x77, 0, 148, 0},
    { 0, 0x77, 0, 148, 0},
    { 0, 0x77, 0, 149, 0},
    { 0, 0x78, 258, 148, 0},
    { 0, 0x69, 0, 144, 0},
    // 450: Local time: 2016-03-02 03:35:00 AM
    { 0, 0x6a, 0, 148, 0},
    { 0, 0x78, 302, 148, 0},
    { 0, 0x78, 73, 148, 0},
    { 0, 0x78, 0, 148, 0},
    { 0, 0x78, 1155, 149, 0},
    { 0, 0x77, 0, 148, 0},
    { 0, 0x68, 1171, 148, 0},
    { 0, 0x69, 0, 148, 0},
    { 0, 0x69, 273, 148, 0},
    { 0, 0x68, 4750, 149, 0},
    { 0, 0x33, 3244, 172, 0},
    { 0, 0x71, 5763, 146, 0},
    { 0, 0x75, 7, 147, 0},
    { 0, 0x75, 0, 147, 0},
    { 0, 0x75, 0, 143, 0},
    // 465: Local time: 2016-03-02 03:50:00 AM
    { 0, 0x75, 0, 147, 0},
    { 0, 0x64, 235, 147, 0},
    { 0, 0x64, 0, 148, 0},
    { 0, 0x54, 2791, 148, 0},
    { 0, 0x66, 5, 149, 0},
    { 0, 0x68, 175, 148, 0},
    { 0, 0x68, 0, 148, 0},
    { 0, 0x68, 65, 148, 0},
    { 0, 0x68, 0, 148, 0},
    { 0, 0x57, 1820, 144, 0},
    { 0, 0x35, 196, 148, 0},
    { 0, 0x45, 0, 148, 0},
    { 0, 0x25, 396, 148, 0},
    { 33, 0x44, 6141, 154, 0},
    { 20, 0x60, 4448, 144, 0},
    // 480: Local time: 2016-03-02 04:05:00 AM
    { 0, 0x6f, 0, 148, 0},
    { 0, 0x6f, 21, 148, 0},
    { 0, 0x6f, 697, 148, 0},
    { 0, 0x6f, 884, 148, 0},
    { 12, 0x79, 2095, 149, 0},
    { 16, 0x69, 2109, 149, 0},
    { 0, 0x68, 785, 148, 0},
    { 15, 0x69, 1870, 148, 0},
    { 0, 0x58, 362, 148, 0},
    { 9, 0x66, 1036, 144, 0},
    { 10, 0x67, 2685, 147, 0},
    { 0, 0x66, 1905, 147, 0},
    { 0, 0x66, 1088, 147, 0},
    { 0, 0x65, 3, 147, 0},
    { 0, 0x66, 0, 143, 0},
    // 495: Local time: 2016-03-02 04:20:00 AM
    { 0, 0x65, 574, 147, 0},
    { 16, 0x47, 2209, 146, 0},
    { 0, 0x55, 402, 146, 0},
    { 0, 0x55, 28, 146, 0},
    { 16, 0x53, 5328, 160, 0},
    { 13, 0x53, 5607, 146, 0},
    { 15, 0x54, 1394, 146, 0},
    { 0, 0x34, 0, 146, 0},
    { 0, 0x34, 0, 147, 0},
    { 0, 0x34, 200, 143, 0},
    { 0, 0x34, 0, 147, 0},
    { 0, 0x34, 1, 147, 0},
    { 0, 0x34, 0, 147, 0},
    { 0, 0x34, 0, 147, 0},
    { 0, 0x34, 0, 145, 0},
    // 510: Local time: 2016-03-02 04:35:00 AM
    { 0, 0x34, 0, 147, 0},
    { 0, 0x34, 0, 148, 0},
    { 0, 0x34, 0, 148, 0},
    { 0, 0x34, 0, 148, 0},
    { 0, 0x34, 3, 147, 0},
    { 0, 0x25, 693, 147, 0},
    { 0, 0x25, 0, 147, 0},
    { 0, 0x25, 0, 147, 0},
    { 0, 0x25, 406, 148, 0},
    { 0, 0x55, 13, 144, 0},
    { 0, 0x55, 0, 148, 0},
    { 0, 0x55, 0, 147, 0},
    { 0, 0x55, 0, 147, 0},
    { 0, 0x78, 1282, 148, 0},
    { 0, 0x69, 356, 144, 0},
    // 525: Local time: 2016-03-02 04:50:00 AM
    { 0, 0x69, 0, 148, 0},
    { 0, 0x69, 498, 148, 0},
    { 0, 0x69, 7, 148, 0},
    { 0, 0x69, 0, 148, 0},
    { 0, 0x69, 0, 149, 0},
    { 0, 0x69, 0, 148, 0},
    { 0, 0x69, 0, 148, 0},
    { 0, 0x69, 75, 149, 0},
    { 0, 0x69, 19, 149, 0},
    { 0, 0x69, 0, 145, 0},
    { 0, 0x69, 13, 149, 0},
    { 0, 0x69, 0, 149, 0},
    { 0, 0x68, 456, 148, 0},
    { 0, 0x66, 0, 148, 0},
    { 0, 0x66, 194, 144, 0},
    // 540: Local time: 2016-03-02 05:05:00 AM
    { 10, 0x62, 6137, 165, 0},
    { 3, 0x54, 4972, 201, 0},
    { 0, 0x42, 5848, 183, 0},
    { 42, 0x51, 7518, 205, 0},
    { 0, 0x41, 4923, 197, 0},
    { 30, 0x52, 11279, 188, 0},
    { 29, 0x41, 2897, 159, 0},
    { 4, 0x42, 7688, 157, 0},
    { 0, 0x43, 5237, 155, 0},
    { 0, 0x44, 2868, 151, 0},
    { 0, 0x53, 4003, 186, 0},
    { 0, 0x45, 6307, 184, 0},
    { 16, 0x44, 3118, 176, 0},
    { 13, 0x42, 6085, 159, 0},
    { 108, 0x41, 3481, 141, 0},
    // 555: Local time: 2016-03-02 05:20:00 AM
    { 108, 0x40, 3475, 156, 0},
    { 66, 0x51, 7547, 147, 0},
    { 130, 0x42, 27135, 172, 0},
    { 143, 0x43, 28113, 34, 0},
    { 158, 0x33, 32012, 159, 0},
    { 157, 0x33, 31660, 171, 0},
    { 131, 0x33, 25700, 11, 0},
    { 156, 0x33, 33319, 169, 0},
    { 150, 0x33, 29836, 170, 0},
    { 156, 0x33, 29547, 150, 0},
    { 143, 0x33, 27790, 101, 0},
    { 155, 0x43, 29350, 176, 0},
    { 150, 0x43, 28766, 11, 0},
    { 138, 0x43, 26447, 160, 0},
    { 154, 0x43, 29240, 140, 0},
    // 570: Local time: 2016-03-02 05:35:00 AM
    { 156, 0x43, 29439, 172, 0},
    { 143, 0x43, 26958, 146, 0},
    { 154, 0x43, 29242, 30, 0},
    { 142, 0x43, 25648, 156, 0},
    { 156, 0x43, 30610, 173, 0},
    { 156, 0x43, 29337, 156, 0},
    { 143, 0x33, 26108, 166, 0},
    { 156, 0x33, 30065, 12, 0},
    { 156, 0x33, 32739, 161, 0},
    { 143, 0x33, 30082, 165, 0},
    { 156, 0x33, 32193, 171, 0},
    { 146, 0x33, 30874, 142, 0},
    { 158, 0x33, 34162, 100, 0},
    { 144, 0x33, 30993, 165, 0},
    { 157, 0x33, 32093, 179, 0},
    // 585: Local time: 2016-03-02 05:50:00 AM
    { 146, 0x33, 28974, 99, 0},
    { 156, 0x33, 33058, 172, 0},
    { 113, 0x43, 15388, 148, 0},
    { 84, 0x41, 4571, 158, 0},
    { 98, 0x41, 5580, 154, 0},
    { 99, 0x41, 4769, 144, 0},
    { 112, 0x41, 4875, 149, 0},
    { 77, 0x41, 5925, 146, 0},
    { 42, 0x52, 6890, 164, 0},
    { 27, 0x43, 7135, 181, 0},
    { 20, 0x64, 3922, 186, 0},
    { 0, 0x7c, 0, 187, 1},
    { 0, 0x7c, 0, 187, 1},
    { 0, 0x7c, 0, 187, 1},
    { 0, 0x7c, 0, 172, 1},
    // 600: Local time: 2016-03-02 06:05:00 AM
    { 0, 0x7c, 0, 187, 1},
    { 0, 0x7c, 0, 187, 1},
    { 0, 0x7c, 0, 187, 1},
    { 0, 0x7c, 0, 172, 1},
    { 0, 0x7c, 0, 172, 1},
    { 0, 0x7c, 0, 187, 1},
    { 0, 0x7c, 0, 187, 1},
    { 0, 0x7c, 0, 172, 1},
    { 0, 0x7c, 0, 187, 1},
    { 0, 0x7c, 0, 187, 1},
    { 0, 0x7c, 0, 187, 1},
    { 0, 0x7c, 0, 187, 1},
    { 0, 0x7c, 0, 187, 1},
    { 0, 0x7c, 0, 187, 1},
    { 0, 0x7c, 0, 187, 1},
    // 615: Local time: 2016-03-02 06:20:00 AM
    { 0, 0x7c, 0, 187, 1},
    { 0, 0x7c, 0, 187, 1},
    { 0, 0x7c, 0, 187, 1},
    { 0, 0x7c, 0, 187, 1},
    { 0, 0x7c, 0, 173, 1},
    { 0, 0x7c, 0, 173, 1},
    { 0, 0x7c, 0, 179, 1},
    { 0, 0x7c, 0, 187, 1},
    { 0, 0x7c, 0, 187, 1},
    { 0, 0x7c, 0, 187, 1},
    { 0, 0x7c, 0, 188, 1},
    { 0, 0x7c, 0, 187, 1},
    { 0, 0x7c, 0, 187, 1},
    { 0, 0x7c, 0, 188, 1},
    { 0, 0x7c, 0, 187, 1},
    // 630: Local time: 2016-03-02 06:35:00 AM
    { 0, 0x7c, 0, 187, 1},
    { 0, 0x7c, 0, 188, 1},
    { 0, 0x7c, 0, 188, 1},
    { 0, 0x7c, 0, 176, 1},
    { 0, 0x7c, 0, 173, 1},
    { 0, 0x7c, 0, 188, 1},
    { 0, 0x7c, 0, 188, 1},
    { 0, 0x7c, 0, 188, 1},
    { 0, 0x7c, 0, 188, 1},
    { 0, 0x7c, 0, 188, 1},
    { 0, 0x7c, 0, 189, 1},
    { 0, 0x7c, 0, 185, 1},
    { 0, 0x7c, 0, 188, 1},
    { 0, 0x7c, 0, 188, 1},
    { 0, 0x7c, 0, 188, 1},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}

