# Network Plugin
This is a plug-in for [Corda CLI plugin host](https://github.com/corda/corda-cli-plugin-host) for membership operations.

> The commands below assume you have access to corda-cli.sh   
> To use this plugin, build the JAR with `./gradlew :tools:plugins:network:build`, move the JAR to 
> `corda-cli-plugin-host/build/plugins/` and run the commands as shown below by locating corda-cli.sh in 
> `corda-cli-plugin-host/build/generatedScripts/`.

# Static Network Operations

## Generate Group Policy

This is a sub-command under the `network` plugin for generating a GroupPolicy.json file.

Running `groupPolicy` without any command line arguments prints a sample GroupPolicy file for the user to manually tweak.
```shell
./corda-cli.sh network groupPolicy
```

NOTE: The `groupPolicy` sub-command is also available under the `mgm` command in order to preserve backwards compatibility.

Alternatively, the following command line arguments can be used to define the static network section of the GroupPolicy:

| Argument            | Description                                                          |
|---------------------|----------------------------------------------------------------------|
| --file, -f          | Path to a JSON or YAML file that contains static network information |
| --name              | Member's X.500 name                                                  |
| --endpoint          | Endpoint base URL                                                    |
| --endpoint-protocol | Version of end-to-end authentication protocol                        |

To generate GroupPolicy using file input:
> Sample files are available [here](#sample-files).
```shell
./corda-cli.sh network groupPolicy --file="app/build/resources/src.yaml"
```
Note:
1. Only one of `memberNames` and `members` blocks may be present.
2. Single endpoint is assumed for all members when `memberNames` is used.
3. Endpoint information specified under `members` overrides endpoint information set at the root level. An error is thrown if endpoint information is not provided at all.
4. The `groupPolicy` sub-command is also available under the `mgm` command in order to preserve backwards compatibility.

To generate GroupPolicy using string parameters:
```shell
./corda-cli.sh network groupPolicy --name="C=GB, L=London, O=Member1" --name="C=GB, L=London, O=Member2" --endpoint-protocol=5 --endpoint="http://dummy-url"
```
Note:
1. Passing one or more `--name` without specifying endpoint information will throw an error.
2. Not passing any `--name` will return a GroupPolicy with an empty list of static members.
3. Single endpoint is assumed for all members.
4. The `groupPolicy` sub-command is also available under the `mgm` command in order to preserve backwards compatibility.

### Sample files

1. Sample JSON with `memberNames`
```json
{
  "endpoint": "http://dummy-url",
  "endpointProtocol": 5,
  "memberNames": ["C=GB, L=London, O=Member1", "C=GB, L=London, O=Member2"]
}
```

2. Sample JSON with `members`
```json
{
  "members": [
    {
      "name": "C=GB, L=London, O=Member1",
      "status": "PENDING",
      "endpoint": "http://dummy-url",
      "endpointProtocol": 5
    },
    {
      "name": "C=GB, L=London, O=Member2",
      "endpoint": "http://dummy-url2",
      "endpointProtocol": 5
    }
  ]
}
```

3. Sample YAML with `memberNames`
```yaml
endpoint: "http://dummy-url"
endpointProtocol: 5
memberNames: ["C=GB, L=London, O=Member1", "C=GB, L=London, O=Member2"]
```

4. Sample YAML with `members` which all use a common endpoint, and Member1 overrides the protocol version
```yaml
endpoint: "http://dummy-url"
endpointProtocol: 5
members:
    - name: "C=GB, L=London, O=Member1"
      status: "PENDING"
      endpointProtocol: 10
    - name: "C=GB, L=London, O=Member2"
```

> Note: The following commands expect the REST endpoints of the target Corda cluster to be available at `https://localhost:8888`. To allow insecure server connections with SSL, use `--insecure`.

# Setting up a dynamic application network

The `dynamic` command is for operations related to dynamic networks, including MGM and member onboarding.

## Onboard MGM

The `onboard-mgm` command creates a virtual node for an MGM and initiates the onboarding process, through which an application network is created. The session and ECDH keys are auto-generated by the Network plugin during registration. The group policy is also exported to be used for creating Member CPI(s).

```
./corda-cli.sh network dynamic onboard-mgm "O=MGM, L=London, C=GB" -s <save-group-policy-as> --wait --user=admin --password=admin --target=https://localhost:8888
```
Use `./corda-cli.sh network dynamic onboard-mgm --help` to view all available options.

## Onboard a member

The `onboard-member` command is for onboarding members onto a dynamic network. It creates a virtual node for the member, and starts the registration process by auto-generating session and ledger keys.

To onboard a member using a CPB and group policy:
```
./corda-cli.sh network dynamic onboard-member "O=Alice, L=London, C=GB" --cpb-file <path-to-your-CPB-file> --group-policy-file <path-to-your-group-policy> --wait --user=admin --password=admin --target=https://localhost:8888
```

To onboard a member using the hash of a previously uploaded CPI:
```
./corda-cli.sh network dynamic onboard-member "O=Alice, L=London, C=GB" --cpi-hash <cpi-hash> --wait --user=admin --password=admin --target=https://localhost:8888
```

To onboard a member as a notary:
```
./corda-cli.sh network dynamic onboard-member "O=Alice, L=London, C=GB" --cpi-hash <cpi-hash> --role "notary" --set "corda.notary.service.name"="C=GB, L=London, O=Notary" --wait --user=admin --password=admin --target=https://localhost:8888
```

Use `./corda-cli.sh network dynamic onboard-member --help` to view all available options.

# Get Registrations

The `get-registrations` command is for checking the status of registration requests.

To view all requests for a holding identity:
```
./corda-cli.sh network get-registrations -h <holding-id> --user=admin --password=admin --target=https://localhost:8888
```

To view a specific registration request, use `--request-id`:
```
./corda-cli.sh network get-registrations -h <holding-id> --request-id <request-id> --user=admin --password=admin --target=https://localhost:8888
```

- - - -  
> Note: You can use `--name` and `--group` if the holding ID is not known. If only `--name` is specified, the last created group will be used by default.

# Discovering other members of the network and viewing the group parameters

The `lookup` command is for looking up group parameters or peers on the network.

> Note: You can use `--name` and `--group` if the holding ID is not known. If only `--name` is specified, the last created group will be used by default.

## Discover Members

To look up all members visible to a holding identity:
```
./corda-cli.sh network lookup members -h <holding-id> --user=admin --password=admin --target=https://localhost:8888
```

Use `./corda-cli.sh network lookup members --help` to view all available options, including status and X.500 attribute filters.

## View Group Parameters

To look up group parameters for a holding identity:
```
./corda-cli.sh network lookup group-parameters -h <holding-id> --user=admin --password=admin --target=https://localhost:8888
```

# Operate

The `operate` command allows MGM operators to manage application networks.

## Allow Client Certificate

This is a sub-command under the `operate` command for adding a member TLS certificate subject to the MGM's allowed list, when mutual TLS is enabled.

To add a certificate subject to the MGM's allowed list, use the following command:

```shell 
./corda-cli.sh network operate allow-client-certificate <short-hash> <certificate-subject> --user=admin --password=admin --target=https://localhost:8888
```

## Export Group Policy

This is a sub-command under the `operate` command for exporting the group policy file from the MGM.

To export the group policy file, use the following command:

```shell 
./corda-cli.sh network operate export-group-policy -h <holding-id> --save <group-policy-file-path> --user=admin --password=admin --target=https://localhost:8888
```
