package com.r3.corda.testing.smoketests.virtualnode

import com.r3.corda.testing.bundles.dogs.Dog
import net.corda.v5.application.flows.ClientRequestBody
import net.corda.v5.application.flows.ClientStartableFlow
import net.corda.v5.application.flows.CordaInject
import net.corda.v5.application.marshalling.JsonMarshallingService
import net.corda.v5.application.persistence.CordaPersistenceException
import net.corda.v5.application.persistence.PersistenceService
import net.corda.v5.base.annotations.Suspendable
import org.slf4j.LoggerFactory
import java.time.Instant
import java.util.UUID

@Suppress("unused")
class SimplePersistenceCheckFlow : ClientStartableFlow {

    private companion object {
        val log = LoggerFactory.getLogger(this::class.java.enclosingClass)
    }

    @CordaInject
    lateinit var jsonMarshallingService: JsonMarshallingService

    @CordaInject
    lateinit var persistenceService: PersistenceService

    @Suspendable
    override fun call(requestBody: ClientRequestBody): String {
        val id = UUID.randomUUID()

        val dog = Dog(id, "Penny", Instant.now(), "Alice")
        try {
            persistenceService.persist("Penny1", dog)
        } catch (ex: CordaPersistenceException) {
            log.error("exception $ex")
            return "Could not persist dog"
        }
        log.info("Persisted Dog: $dog")
        return "Could persist dog"
    }
}