package net.corda.messaging.api.mediator

/**
 * Multi-source event mediator's message router that routes messages generated by state and event processor to messaging
 * clients. Example:
 *
 * ```
 * MessageRouter { message ->
 *     when (message.payload) {
 *         is FlowMapperEvent -> routeTo(messageBusClient, FLOW_MAPPER_SESSION_OUT_TOPIC)
 *         is FlowStatus -> routeTo(messageBusClient, FLOW_STATUS_TOPIC)
 *         else -> throw IllegalStateException("No route defined for message $message")
 *     }
 * }
 * ```
 */
fun interface MessageRouter {

    /**
     * Provides [RoutingDestination] for given [MediatorMessage].
     *
     * @param message Message.
     * @return Destination for given message.
     */
    fun getDestination(message: MediatorMessage<Any>): RoutingDestination
}
