package net.corda.ledger.consensual.flow.impl.transaction.serializer.kryo

import net.corda.crypto.cipher.suite.SignatureSpecImpl
import net.corda.crypto.core.DigitalSignatureWithKeyId
import net.corda.kryoserialization.testkit.createCheckpointSerializer
import net.corda.ledger.common.data.transaction.PrivacySaltImpl
import net.corda.ledger.common.data.transaction.WireTransaction
import net.corda.ledger.consensual.flow.impl.transaction.ConsensualSignedTransactionImpl
import net.corda.ledger.consensual.test.ConsensualLedgerTest
import net.corda.v5.application.crypto.DigitalSignatureAndMetadata
import net.corda.v5.crypto.DigitalSignature
import org.assertj.core.api.Assertions.assertThat
import org.junit.jupiter.api.Assertions.assertEquals
import org.junit.jupiter.api.Test

class ConsensualSignedTransactionKryoSerializerTest : ConsensualLedgerTest() {
    @Test
    fun `serialization of a Consensual Signed Tx object using the kryo default serialization`() {
        val serializer = createCheckpointSerializer(
            mapOf(
                WireTransaction::class.java to wireTransactionKryoSerializer,
                ConsensualSignedTransactionImpl::class.java to consensualSignedTransactionKryoSerializer
            ),
            emptyList(),
            setOf(
                PrivacySaltImpl::class.java,
                DigitalSignatureAndMetadata::class.java,
                consensualSignedTransactionExample.signatures[0].by::class.java,
                emptyMap<String, String>()::class.java,
                DigitalSignature.WithKeyId::class.java,
                DigitalSignatureWithKeyId::class.java,
                SignatureSpecImpl::class.java,
                mapOf("" to "")::class.java
            )
        )
        val bytes = serializer.serialize(consensualSignedTransactionExample)
        val deserialized = serializer.deserialize(bytes, ConsensualSignedTransactionImpl::class.java)

        assertThat(deserialized).isEqualTo(consensualSignedTransactionExample)
        org.junit.jupiter.api.Assertions.assertDoesNotThrow {
            deserialized.id
        }
        assertEquals(consensualSignedTransactionExample.id, deserialized.id)
    }
}
