package net.corda.flow.application.persistence.external.events

import net.corda.data.KeyValuePairList
import net.corda.data.flow.event.external.ExternalEventContext
import net.corda.data.persistence.EntityRequest
import net.corda.data.persistence.FindWithNamedQuery
import net.corda.flow.ALICE_X500_HOLDING_IDENTITY
import net.corda.flow.state.FlowCheckpoint
import net.corda.virtualnode.toCorda
import org.junit.jupiter.api.Assertions.assertEquals
import org.junit.jupiter.api.Assertions.assertNull
import org.junit.jupiter.api.Test
import org.mockito.kotlin.mock
import org.mockito.kotlin.whenever

class NamedQueryExternalEventFactoryTest {

    @Test
    fun `creates a record containing an EntityRequest with a FindWithNamedQuery payload`() {
        val checkpoint = mock<FlowCheckpoint>()
        val externalEventContext = ExternalEventContext("request id", "flow id", KeyValuePairList(emptyList()))

        whenever(checkpoint.holdingIdentity).thenReturn(ALICE_X500_HOLDING_IDENTITY.toCorda())

        val externalEventRecord = NamedQueryExternalEventFactory().createExternalEvent(
            checkpoint,
            externalEventContext,
            NamedQueryParameters("query", emptyMap(), 1, Int.MAX_VALUE)
        )
        assertNull(externalEventRecord.key)
        assertEquals(
            EntityRequest(
                ALICE_X500_HOLDING_IDENTITY,
                FindWithNamedQuery("query", emptyMap(), 1, Int.MAX_VALUE, null),
                externalEventContext
            ),
            externalEventRecord.payload
        )
    }
}
