<p align="center">
  <img src="https://corda.net/wp-content/uploads/2021/11/corda-logo.svg" alt="Corda" width="500">
</p>

---

[![License](https://img.shields.io/badge/License-Apache%202.0-blue.svg)](https://opensource.org/licenses/Apache-2.0)

<h2>Project Overview</h2>

Corda is a scalable, permissioned peer-to-peer (P2P) distributed ledger technology (DLT) platform that enables the building of applications that foster and deliver digital trust between parties in regulated markets.

Corda is developed and maintained by [R3](https://r3.com), and is made available under the Apache 2.0 license.

This repo contains the code that will evolve to become the Corda 5 release. For the current Corda 4 codebase, head over to the [Corda 4 repo](https://github.com/corda/corda).

We encourage you to use this code to explore how Corda 5 will work, rebuild it, and experiment with deploying it locally. We'd love your comments and feedback! But be warned it is pre-release software and is not yet intended to facilitate full CorDapp development. 

Note that there is a large engineering team at R3 working on this codebase so if you see something wrong or missing, we encourage you to contact us before working on any significant PRs of your own: it's possible we may already be working on the same thing or we may have tips on how best to structure your work to maximise the chance of it being merged into the codebase.

The best way to stay up-to-date with Corda is to monitor the following resources: 

 * Slack - [cordaledger.slack.com](https://cordaledger.slack.com)
 * Our Blog - [corda.net/blog/](https://www.corda.net/blog/)
 * Community Forum - [community.r3.com](https://community.r3.com)
  
<h2>Getting Started</h2>

See [github.com/corda/corda-runtime-os/wiki/Quick-Start-Guide](https://github.com/corda/corda-runtime-os/wiki/Quick-Start-Guide)
