/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.io.serialization.kryo;

import co.paralleluniverse.common.reflection.GetAccessDeclaredMethod;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.FieldSerializer;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedActionException;

class ReplacableObjectSerializer
extends FieldSerializer<Object> {
    public ReplacableObjectSerializer(Kryo kryo, Class<?> type) {
        super(kryo, type);
    }

    public void write(Kryo kryo, Output output, Object object) {
        super.write(kryo, output, ReplacableObjectSerializer.getReplacement(object, "writeReplace"));
    }

    public Object read(Kryo kryo, Input input, Class<Object> type) {
        return ReplacableObjectSerializer.getReplacement(super.read(kryo, input, type), "readResolve");
    }

    private static Method getDeclaredMethod(Class<?> clazz, String methodName) throws NoSuchMethodException {
        try {
            return AccessController.doPrivileged(new GetAccessDeclaredMethod(clazz, methodName, new Class[0]));
        }
        catch (PrivilegedActionException e) {
            Throwable t = e.getCause();
            if (t instanceof NoSuchMethodException) {
                throw (NoSuchMethodException)t;
            }
            throw new RuntimeException(t);
        }
    }

    private static Object getReplacement(Object obj, String replaceMethodName) {
        try {
            Class<?> clazz = obj.getClass();
            if (!Serializable.class.isAssignableFrom(clazz)) {
                return obj;
            }
            Method m = null;
            try {
                m = ReplacableObjectSerializer.getDeclaredMethod(clazz, replaceMethodName);
            }
            catch (NoSuchMethodException ex) {
                for (Class<?> ancestor = clazz.getSuperclass(); ancestor != null; ancestor = ancestor.getSuperclass()) {
                    if (!Serializable.class.isAssignableFrom(ancestor)) {
                        return obj;
                    }
                    try {
                        m = ReplacableObjectSerializer.getDeclaredMethod(ancestor, replaceMethodName);
                        if (!Modifier.isPublic(m.getModifiers()) && !Modifier.isProtected(m.getModifiers())) {
                            return obj;
                        }
                        break;
                    }
                    catch (NoSuchMethodException ex1) {
                        continue;
                    }
                }
            }
            if (m == null) {
                return obj;
            }
            return m.invoke(obj, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
            if (ex instanceof InvocationTargetException) {
                ((InvocationTargetException)ex).getTargetException().printStackTrace();
            }
            return obj;
        }
    }
}

