/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.fibers.instrument;

import co.paralleluniverse.asm.Type;
import co.paralleluniverse.asm.tree.AbstractInsnNode;
import co.paralleluniverse.asm.tree.MethodInsnNode;
import co.paralleluniverse.asm.tree.analysis.Analyzer;
import co.paralleluniverse.asm.tree.analysis.AnalyzerException;
import co.paralleluniverse.asm.tree.analysis.BasicValue;
import co.paralleluniverse.asm.tree.analysis.Frame;
import co.paralleluniverse.asm.tree.analysis.Interpreter;
import co.paralleluniverse.asm.tree.analysis.Value;
import co.paralleluniverse.fibers.instrument.MethodDatabase;
import co.paralleluniverse.fibers.instrument.NewValue;
import co.paralleluniverse.fibers.instrument.TypeInterpreter;

class TypeAnalyzer
extends Analyzer {
    TypeAnalyzer(MethodDatabase db) {
        super(new TypeInterpreter(db));
    }

    @Override
    protected Frame newFrame(int nLocals, int nStack) {
        return new TypeFrame(nLocals, nStack);
    }

    @Override
    protected Frame newFrame(Frame src) {
        return new TypeFrame(src);
    }

    static int getNumArguments(String methodDesc) {
        int off = 1;
        int size = 0;
        char car;
        while ((car = methodDesc.charAt(off++)) != ')') {
            if (car == '[') continue;
            ++size;
            if (car != 'L') continue;
            off = methodDesc.indexOf(59, off) + 1;
        }
        return size;
    }

    static class TypeFrame
    extends Frame {
        TypeFrame(int nLocals, int nStack) {
            super(nLocals, nStack);
        }

        TypeFrame(Frame src) {
            super(src);
        }

        @Override
        public void execute(AbstractInsnNode insn, Interpreter interpreter) throws AnalyzerException {
            switch (insn.getOpcode()) {
                case 182: 
                case 183: 
                case 184: 
                case 185: {
                    Type returnType;
                    String desc = ((MethodInsnNode)insn).desc;
                    for (int i = TypeAnalyzer.getNumArguments(desc); i > 0; --i) {
                        this.pop();
                    }
                    if (insn.getOpcode() != 184) {
                        this.pop();
                        if (insn.getOpcode() == 183 && this.getStackSize() > 0 && "<init>".equals(((MethodInsnNode)insn).name)) {
                            Value value = this.pop();
                            if (value instanceof NewValue) {
                                value = new BasicValue(((NewValue)value).getType());
                            }
                            this.push(value);
                        }
                    }
                    if ((returnType = Type.getReturnType(desc)) == Type.VOID_TYPE) break;
                    this.push(interpreter.newValue(returnType));
                    break;
                }
                default: {
                    super.execute(insn, interpreter);
                }
            }
        }
    }
}

