/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.fibers.instrument;

import co.paralleluniverse.fibers.instrument.MethodDatabase;
import co.paralleluniverse.fibers.instrument.Pair;
import co.paralleluniverse.fibers.instrument.SuspendableClassifier;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class SimpleSuspendableClassifier
implements SuspendableClassifier {
    private static final String PREFIX = "META-INF/";
    private static final String SUSPENDABLES_FILE = "suspendables";
    private static final String SUSPENDABLE_SUPERS_FILE = "suspendable-supers";
    private final Set<String> suspendables = new HashSet<String>();
    private final Set<String> suspendableClasses = new HashSet<String>();
    private final Set<String> suspendableSupers = new HashSet<String>();
    private final Set<String> suspendableSuperInterfaces = new HashSet<String>();

    public SimpleSuspendableClassifier(ClassLoader classLoader) {
        this.readFiles(classLoader, SUSPENDABLES_FILE, this.suspendables, this.suspendableClasses);
        this.readFiles(classLoader, SUSPENDABLE_SUPERS_FILE, this.suspendableSupers, this.suspendableSuperInterfaces);
    }

    public SimpleSuspendableClassifier(ClassLoader classLoader, String[] suspendablesResources, String[] suspendableSupersResources) {
        for (String sus : suspendablesResources) {
            this.readFiles(classLoader, sus, this.suspendables, this.suspendableClasses);
        }
        for (String sus : suspendableSupersResources) {
            this.readFiles(classLoader, sus, this.suspendableSupers, this.suspendableSuperInterfaces);
        }
    }

    SimpleSuspendableClassifier(String suspendablesFileName) {
        this.readSuspendablesFile(suspendablesFileName, this.suspendables, this.suspendableClasses);
    }

    Set<String> getSuspendables() {
        return this.suspendables;
    }

    Set<String> getSuspendableClasses() {
        return this.suspendableClasses;
    }

    private static Enumeration<URL> getFiles(ClassLoader classLoader, String fileName) {
        return AccessController.doPrivileged(new GetResourcesAction(classLoader, PREFIX + fileName));
    }

    private void readFiles(ClassLoader classLoader, String fileName, Set<String> set, Set<String> classSet) {
        Enumeration<URL> susFiles = SimpleSuspendableClassifier.getFiles(classLoader, fileName);
        while (susFiles.hasMoreElements()) {
            URL file = susFiles.nextElement();
            SimpleSuspendableClassifier.parse(file, set, classSet);
        }
    }

    private void readSuspendablesFile(String fileName, Set<String> set, Set<String> classSet) {
        try {
            SimpleSuspendableClassifier.parse(new File(fileName).toURI().toURL(), set, classSet);
        }
        catch (MalformedURLException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    private static void parse(URL file, Set<String> set, Set<String> classSet) {
        AccessController.doPrivileged(new ParseFileAction(file, set, classSet));
    }

    public boolean isSuspendable(String className, String methodName, String methodDesc) {
        return this.suspendables.contains(className + '.' + methodName + methodDesc) || this.suspendables.contains(className + '.' + methodName) || this.suspendableClasses.contains(className);
    }

    public boolean isSuperSuspendable(String className, String methodName, String methodDesc) {
        return this.suspendableSupers.contains(className + '.' + methodName + methodDesc) || this.suspendableSupers.contains(className + '.' + methodName) || this.suspendableSuperInterfaces.contains(className);
    }

    @Override
    public MethodDatabase.SuspendableType isSuspendable(MethodDatabase db, String sourceName, String sourceDebugInfo, boolean isInterface, String className, String superClassName, String[] interfaces, String methodName, String methodDesc, String methodSignature, String[] methodExceptions) {
        MethodDatabase.ClassEntry ce;
        MethodDatabase ownerDB;
        Pair<MethodDatabase, MethodDatabase.ClassEntry> dbEntry;
        String fullMethodName = className + '.' + methodName;
        if (this.suspendables.contains(fullMethodName + methodDesc)) {
            return MethodDatabase.SuspendableType.SUSPENDABLE;
        }
        if (this.suspendables.contains(fullMethodName)) {
            return MethodDatabase.SuspendableType.SUSPENDABLE;
        }
        if (this.suspendableClasses.contains(className)) {
            return MethodDatabase.SuspendableType.SUSPENDABLE;
        }
        if (this.suspendableSupers.contains(fullMethodName + methodDesc)) {
            return MethodDatabase.SuspendableType.SUSPENDABLE_SUPER;
        }
        if (this.suspendableSupers.contains(fullMethodName)) {
            return MethodDatabase.SuspendableType.SUSPENDABLE_SUPER;
        }
        if (this.suspendableSuperInterfaces.contains(className)) {
            return MethodDatabase.SuspendableType.SUSPENDABLE_SUPER;
        }
        if (superClassName != null && (dbEntry = db.getOrLoadClassEntry(superClassName)) != null && this.isSuspendable(ownerDB = dbEntry.getFirst(), sourceName, sourceDebugInfo, isInterface, superClassName, (ce = dbEntry.getSecond()).getSuperName(), ce.getInterfaces(), methodName, methodDesc, methodSignature, methodExceptions) == MethodDatabase.SuspendableType.SUSPENDABLE) {
            return MethodDatabase.SuspendableType.SUSPENDABLE;
        }
        if (interfaces != null) {
            for (String iface : interfaces) {
                MethodDatabase.ClassEntry ce2;
                MethodDatabase ownerDB2;
                Pair<MethodDatabase, MethodDatabase.ClassEntry> dbEntry2 = db.getOrLoadClassEntry(iface);
                if (dbEntry2 == null || this.isSuspendable(ownerDB2 = dbEntry2.getFirst(), (ce2 = dbEntry2.getSecond()).getSourceName(), ce2.getSourceDebugInfo(), ce2.isInterface(), iface, ce2.getSuperName(), ce2.getInterfaces(), methodName, methodDesc, methodSignature, methodExceptions) != MethodDatabase.SuspendableType.SUSPENDABLE) continue;
                return MethodDatabase.SuspendableType.SUSPENDABLE;
            }
        }
        return null;
    }

    public static boolean extendsOrImplements(String superOrIface, MethodDatabase db, String superClassName, String[] interfaces) {
        if (superOrIface == null) {
            throw new IllegalArgumentException("superOrIface is null");
        }
        if (Objects.equals(superOrIface, superClassName)) {
            return true;
        }
        for (String iface : interfaces) {
            if (!Objects.equals(superOrIface, iface)) continue;
            return true;
        }
        if (SimpleSuspendableClassifier.extendsOrImplements(superOrIface, db, superClassName)) {
            return true;
        }
        for (String iface : interfaces) {
            if (!SimpleSuspendableClassifier.extendsOrImplements(superOrIface, db, iface)) continue;
            return true;
        }
        return false;
    }

    private static boolean extendsOrImplements(String superOrIface, MethodDatabase db, String className) {
        if (className == null) {
            return false;
        }
        Pair<MethodDatabase, MethodDatabase.ClassEntry> dbEntry = db.getOrLoadClassEntry(className);
        if (dbEntry != null) {
            MethodDatabase ownerDB = dbEntry.getFirst();
            MethodDatabase.ClassEntry ce = dbEntry.getSecond();
            if (Objects.equals(superOrIface, ce.getSuperName())) {
                return true;
            }
            for (String iface : ce.getInterfaces()) {
                if (!Objects.equals(superOrIface, iface)) continue;
                return true;
            }
            if (SimpleSuspendableClassifier.extendsOrImplements(superOrIface, ownerDB, ce.getSuperName())) {
                return true;
            }
            for (String iface : ce.getInterfaces()) {
                if (!SimpleSuspendableClassifier.extendsOrImplements(superOrIface, ownerDB, iface)) continue;
                return true;
            }
        }
        return false;
    }

    private static MethodDatabase.SuspendableType max(MethodDatabase.SuspendableType a, MethodDatabase.SuspendableType b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        if (a == MethodDatabase.SuspendableType.SUSPENDABLE || b == MethodDatabase.SuspendableType.SUSPENDABLE) {
            return MethodDatabase.SuspendableType.SUSPENDABLE;
        }
        if (a != b) {
            throw new AssertionError((Object)("a: " + (Object)((Object)a) + " b: " + (Object)((Object)b)));
        }
        return a;
    }

    private static final class ParseFileAction
    implements PrivilegedAction<Void> {
        private final URL file;
        private final Set<String> set;
        private final Set<String> classSet;

        ParseFileAction(URL file, Set<String> set, Set<String> classSet) {
            this.file = file;
            this.set = set;
            this.classSet = classSet;
        }

        @Override
        public Void run() {
            try (InputStream is = this.file.openStream();
                 BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
                String line;
                int linenum = 1;
                while ((line = reader.readLine()) != null) {
                    String s = line.trim();
                    if (!s.isEmpty() && s.charAt(0) != '#') {
                        int index = s.lastIndexOf(46);
                        if (index <= 0) {
                            System.err.println("Can't parse line " + linenum + " in " + this.file + ": " + line);
                        } else {
                            String className = s.substring(0, index).replace('.', '/');
                            String methodName = s.substring(index + 1);
                            String fullName = className + '.' + methodName;
                            if (methodName.equals("*")) {
                                if (this.classSet != null) {
                                    this.classSet.add(className);
                                }
                            } else {
                                this.set.add(fullName);
                            }
                        }
                    }
                    ++linenum;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
        }
    }

    private static final class GetResourcesAction
    implements PrivilegedAction<Enumeration<URL>> {
        private final ClassLoader classLoader;
        private final String resourceName;

        GetResourcesAction(ClassLoader classLoader, String resourceName) {
            this.classLoader = classLoader;
            this.resourceName = resourceName;
        }

        @Override
        public Enumeration<URL> run() {
            try {
                return this.classLoader.getResources(this.resourceName);
            }
            catch (IOException e) {
                return Collections.emptyEnumeration();
            }
        }
    }
}

