/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.fibers.instrument;

import co.paralleluniverse.asm.ClassReader;
import co.paralleluniverse.asm.util.Textifier;
import co.paralleluniverse.asm.util.TraceClassVisitor;
import co.paralleluniverse.fibers.instrument.MethodDatabase;
import co.paralleluniverse.fibers.instrument.QuasarInstrumentor;
import co.paralleluniverse.fibers.instrument.SuspendableHelper;
import java.io.PrintWriter;
import java.lang.instrument.ClassDefinition;
import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class Retransform {
    static volatile Instrumentation instrumentation;
    static volatile QuasarInstrumentor instrumentor;
    static volatile Set<WeakReference<ClassLoader>> classLoaders;
    private static final CopyOnWriteArrayList<ClassLoadListener> listeners;

    public static void retransform(Class<?> clazz) throws UnmodifiableClassException {
        instrumentation.retransformClasses(clazz);
    }

    public static void redefine(Collection<ClassDefinition> classDefinitions) {
        try {
            instrumentation.redefineClasses(classDefinitions.toArray(new ClassDefinition[0]));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static MethodDatabase getMethodDB(ClassLoader cl) {
        return instrumentor.getMethodDatabase(cl);
    }

    public static QuasarInstrumentor getInstrumentor() {
        return instrumentor;
    }

    public static void addWaiver(String className, String methodName) {
        SuspendableHelper.addWaiver(className, methodName);
    }

    public static boolean isWaiver(String className, String methodName) {
        return SuspendableHelper.isWaiver(className, methodName);
    }

    public static Boolean isSuspendable(ClassLoader cl, String className, String methodName) {
        MethodDatabase.ClassEntry ce = Retransform.getMethodDB(cl).getClassEntry(className);
        if (ce == null) {
            return null;
        }
        return ce.isSuspendable(methodName);
    }

    static void beforeTransform(String className, Class<?> clazz, byte[] data) {
        for (ClassLoadListener listener : listeners) {
            listener.beforeTransform(className, clazz, data);
        }
    }

    static void afterTransform(String className, Class<?> clazz, byte[] data) {
        for (ClassLoadListener listener : listeners) {
            listener.afterTransform(className, clazz, data);
        }
    }

    public static void dumpClass(String className, byte[] data) {
        System.err.println("DUMP OF CLASS: " + className);
        ClassReader cr = new ClassReader(data);
        TraceClassVisitor cv = new TraceClassVisitor(null, new Textifier(), new PrintWriter(System.err));
        cr.accept(cv, 4);
        System.out.println("=================");
    }

    public static void addClassLoadListener(ClassLoadListener listener) {
        listeners.addIfAbsent(listener);
    }

    static {
        classLoaders = Collections.newSetFromMap(new ConcurrentHashMap());
        listeners = new CopyOnWriteArrayList();
    }

    public static interface ClassLoadListener {
        public void beforeTransform(String var1, Class<?> var2, byte[] var3);

        public void afterTransform(String var1, Class<?> var2, byte[] var3);
    }
}

