/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.fibers.instrument;

import co.paralleluniverse.common.reflection.GetAccessDeclaredField;
import co.paralleluniverse.common.reflection.GetAccessDeclaredMethod;
import co.paralleluniverse.fibers.instrument.Log;
import co.paralleluniverse.fibers.instrument.LogLevel;
import co.paralleluniverse.fibers.instrument.MethodDatabase;
import co.paralleluniverse.fibers.instrument.QuasarInstrumentor;
import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.ByteBuffer;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSigner;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.util.Arrays;
import java.util.jar.Manifest;
import sun.misc.Resource;
import sun.misc.URLClassPath;

public final class QuasarURLClassLoaderHelper {
    private final URLClassLoader cl;
    private final QuasarInstrumentor instrumentor;
    private static final Field ucpField;
    private static final Field accField;
    private static final Method defineClassMethod;

    public QuasarURLClassLoaderHelper(URLClassLoader cl) {
        this.cl = cl;
        this.instrumentor = this.newInstrumentor();
    }

    private QuasarInstrumentor newInstrumentor() {
        return new QuasarInstrumentor(new Log(){

            @Override
            public void log(LogLevel level, String msg, Object ... args) {
                System.err.println("[quasar] " + (Object)((Object)level) + ": " + String.format(msg, args));
            }

            @Override
            public void error(String msg, Throwable exc) {
                System.err.println("[quasar] ERROR: " + msg);
                exc.printStackTrace(System.err);
            }
        });
    }

    public void setLog(boolean verbose, boolean debug) {
        this.instrumentor.setVerbose(verbose);
        this.instrumentor.setDebug(debug);
    }

    public Class<?> findClass(final String name) throws ClassNotFoundException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Class>(){

                @Override
                public Class run() throws ClassNotFoundException {
                    String path = name.replace('.', '/').concat(".class");
                    Resource res = QuasarURLClassLoaderHelper.this.ucp().getResource(path, false);
                    if (res != null) {
                        try {
                            return QuasarURLClassLoaderHelper.this.defineClass(name, QuasarURLClassLoaderHelper.this.instrument(name, res));
                        }
                        catch (IOException e) {
                            throw new ClassNotFoundException(name, e);
                        }
                    }
                    throw new ClassNotFoundException(name);
                }
            }, this.acc());
        }
        catch (PrivilegedActionException pae) {
            throw (ClassNotFoundException)pae.getException();
        }
    }

    public InputStream instrumentResourceStream(String resourceName, InputStream is) {
        if (is != null && resourceName.endsWith(".class")) {
            try {
                byte[] bytes = ByteStreams.toByteArray((InputStream)is);
                byte[] instrumented = this.instrumentor.instrumentClass((ClassLoader)this.cl, resourceName.substring(0, resourceName.length() - ".class".length()), bytes);
                return new ByteArrayInputStream(instrumented);
            }
            catch (IOException e) {
                return new InputStream(){

                    @Override
                    public int read() throws IOException {
                        throw new IOException(e);
                    }
                };
            }
        }
        return is;
    }

    private Resource instrument(final String className, final Resource res) {
        return new Resource(){
            private byte[] instrumented;

            public synchronized byte[] getBytes() throws IOException {
                if (this.instrumented == null) {
                    byte[] bytes;
                    ByteBuffer bb = res.getByteBuffer();
                    if (bb != null) {
                        int size = bb.remaining();
                        bytes = new byte[size];
                        bb.get(bytes);
                    } else {
                        bytes = res.getBytes();
                    }
                    try {
                        this.instrumented = QuasarURLClassLoaderHelper.this.instrumentor.instrumentClass((ClassLoader)QuasarURLClassLoaderHelper.this.cl, className, bytes);
                    }
                    catch (Exception ex) {
                        if (MethodDatabase.isProblematicClass(className)) {
                            QuasarURLClassLoaderHelper.this.instrumentor.log(LogLevel.INFO, "Skipping problematic class instrumentation %s - %s %s", className, ex, Arrays.toString(ex.getStackTrace()));
                        } else {
                            QuasarURLClassLoaderHelper.this.instrumentor.error("Unable to instrument " + className, ex);
                        }
                        this.instrumented = bytes;
                    }
                }
                return this.instrumented;
            }

            public ByteBuffer getByteBuffer() throws IOException {
                return null;
            }

            public InputStream getInputStream() throws IOException {
                throw new AssertionError();
            }

            public String getName() {
                return res.getName();
            }

            public URL getURL() {
                return res.getURL();
            }

            public URL getCodeSourceURL() {
                return res.getCodeSourceURL();
            }

            public int getContentLength() throws IOException {
                return res.getContentLength();
            }

            public Manifest getManifest() throws IOException {
                return res.getManifest();
            }

            public Certificate[] getCertificates() {
                return res.getCertificates();
            }

            public CodeSigner[] getCodeSigners() {
                return res.getCodeSigners();
            }
        };
    }

    private Class defineClass(String name, Resource res) throws IOException {
        try {
            return (Class)defineClassMethod.invoke((Object)this.cl, name, res);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new AssertionError((Object)e);
        }
    }

    private URLClassPath ucp() {
        try {
            return (URLClassPath)ucpField.get(this.cl);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new AssertionError((Object)e);
        }
    }

    private AccessControlContext acc() {
        try {
            return (AccessControlContext)accField.get(this.cl);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new AssertionError((Object)e);
        }
    }

    static {
        try {
            ucpField = AccessController.doPrivileged(new GetAccessDeclaredField(URLClassLoader.class, "ucp"));
            accField = AccessController.doPrivileged(new GetAccessDeclaredField(URLClassLoader.class, "acc"));
            defineClassMethod = AccessController.doPrivileged(new GetAccessDeclaredMethod(URLClassLoader.class, "defineClass", String.class, Resource.class));
        }
        catch (PrivilegedActionException e) {
            throw new RuntimeException(e.getCause());
        }
    }
}

