/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.fibers.instrument;

import co.paralleluniverse.fibers.instrument.Log;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.security.PrivilegedAction;

final class OpenInputStreamAction
implements PrivilegedAction<InputStream> {
    private final URL resource;
    private final Log log;

    OpenInputStreamAction(URL resource, Log log) {
        this.resource = resource;
        this.log = log;
    }

    @Override
    public InputStream run() {
        try {
            return this.resource.openStream();
        }
        catch (IOException e) {
            String message = "While opening " + this.resource;
            if (this.log != null) {
                this.log.error(message, e);
            }
            throw new UncheckedIOException(message, e);
        }
    }
}

