/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.fibers.instrument;

import co.paralleluniverse.asm.AnnotationVisitor;
import co.paralleluniverse.asm.ClassVisitor;
import co.paralleluniverse.asm.MethodVisitor;
import co.paralleluniverse.asm.Type;
import co.paralleluniverse.fibers.instrument.InstrumentClass;
import co.paralleluniverse.fibers.instrument.MethodDatabase;
import co.paralleluniverse.fibers.instrument.Pair;
import co.paralleluniverse.fibers.instrument.SuspendableClassifier;
import co.paralleluniverse.fibers.instrument.UnableToInstrumentException;
import java.util.ArrayList;
import java.util.List;

class CheckInstrumentationVisitor
extends ClassVisitor {
    private final MethodDatabase db;
    private final SuspendableClassifier classifier;
    private String sourceName;
    private String sourceDebugInfo;
    private boolean isInterface;
    private String className;
    private boolean suspendableInterface;
    private MethodDatabase.ClassEntry classEntry;
    private boolean hasSuspendable;
    private boolean alreadyInstrumented;
    private final List<Pair<String, String>> methodsSyntheticStatic = new ArrayList<Pair<String, String>>();

    CheckInstrumentationVisitor(MethodDatabase db) {
        super(327680);
        this.db = db;
        this.classifier = db.getClassifier();
    }

    public boolean needsInstrumentation() {
        return this.hasSuspendable;
    }

    MethodDatabase.ClassEntry getClassEntry() {
        return this.classEntry;
    }

    public String getName() {
        return this.className;
    }

    public boolean isAlreadyInstrumented() {
        return this.alreadyInstrumented;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.className = name;
        this.isInterface = (access & 0x200) != 0;
        this.classEntry = new MethodDatabase.ClassEntry(superName);
        this.classEntry.setInterfaces(interfaces);
        this.classEntry.setIsInterface(this.isInterface);
    }

    @Override
    public void visitSource(String source, String debug) {
        this.sourceName = source;
        this.sourceDebugInfo = debug;
        super.visitSource(source, debug);
        this.classEntry.setSourceName(this.sourceName);
        this.classEntry.setSourceDebugInfo(this.sourceDebugInfo);
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        if (desc.equals("Lco/paralleluniverse/fibers/Instrumented;")) {
            this.alreadyInstrumented = true;
        } else if (this.isInterface && desc.equals("Lco/paralleluniverse/fibers/Suspendable;")) {
            this.suspendableInterface = true;
        }
        return null;
    }

    @Override
    public MethodVisitor visitMethod(final int access, final String name, final String desc, String signature, String[] exceptions) {
        MethodDatabase.SuspendableType suspendable = null;
        if (this.suspendableInterface) {
            suspendable = MethodDatabase.SuspendableType.SUSPENDABLE_SUPER;
        }
        if (suspendable == null) {
            suspendable = this.classEntry.check(name, desc);
        }
        if (suspendable == null) {
            suspendable = this.classifier.isSuspendable(this.db, this.sourceName, this.sourceDebugInfo, this.isInterface, this.className, this.classEntry.getSuperName(), this.classEntry.getInterfaces(), name, desc, signature, exceptions);
        }
        if (suspendable == MethodDatabase.SuspendableType.SUSPENDABLE) {
            this.hasSuspendable = true;
            if ((access & 0x20) == 32 && !this.className.equals("clojure/lang/LazySeq") && !this.db.isAllowMonitors()) {
                throw new UnableToInstrumentException("synchronized method", this.className, name, desc);
            }
        }
        suspendable = InstrumentClass.suspendableToSuperIfAbstract(access, suspendable);
        this.classEntry.set(name, desc, suspendable);
        if (suspendable == null) {
            return new MethodVisitor(327680){
                private boolean susp;
                {
                    super(x0);
                    this.susp = false;
                }

                @Override
                public AnnotationVisitor visitAnnotation(String adesc, boolean visible) {
                    if (adesc.equals("Lco/paralleluniverse/fibers/Suspendable;")) {
                        this.susp = true;
                    }
                    return null;
                }

                @Override
                public void visitEnd() {
                    super.visitEnd();
                    int ACC_STATIC_SYNTHETIC = 4104;
                    if (!this.susp && (access & 0x1008) == 4104 && name.endsWith("$default")) {
                        CheckInstrumentationVisitor.this.methodsSyntheticStatic.add(new Pair<String, String>(name, desc));
                    }
                    CheckInstrumentationVisitor.this.classEntry.set(name, desc, InstrumentClass.suspendableToSuperIfAbstract(access, this.susp ? MethodDatabase.SuspendableType.SUSPENDABLE : MethodDatabase.SuspendableType.NON_SUSPENDABLE));
                    CheckInstrumentationVisitor.this.hasSuspendable = CheckInstrumentationVisitor.this.hasSuspendable | this.susp;
                }
            };
        }
        return null;
    }

    private String buildDescriptorFromSyntheticStatic(int startAt, String descStatic) {
        Type[] staticMethodTypes = Type.getArgumentTypes(descStatic);
        StringBuilder desc = new StringBuilder("(");
        for (int i = startAt; i < staticMethodTypes.length - 2; ++i) {
            desc.append(staticMethodTypes[i].toString());
        }
        desc.append(')');
        desc.append(Type.getReturnType(descStatic));
        return desc.toString();
    }

    @Override
    public void visitEnd() {
        block0: for (Pair<String, String> p : this.methodsSyntheticStatic) {
            int defaultLen = "$default".length();
            String name = p.getFirst().substring(0, p.getFirst().length() - defaultLen);
            for (int i = 0; i < 2; ++i) {
                MethodDatabase.SuspendableType type = this.classEntry.check(name, this.buildDescriptorFromSyntheticStatic(i, p.getSecond()));
                if (type == null) continue;
                if (type == MethodDatabase.SuspendableType.NON_SUSPENDABLE) continue block0;
                this.classEntry.set(p.getFirst(), p.getSecond(), MethodDatabase.SuspendableType.SUSPENDABLE);
                continue block0;
            }
        }
        super.visitEnd();
    }
}

