/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.fibers;

import co.paralleluniverse.fibers.Fiber;
import co.paralleluniverse.fibers.SuspendExecution;
import java.io.Serializable;
import java.util.Arrays;

public final class Stack
implements Serializable {
    private static final int INITIAL_METHOD_STACK_DEPTH = 16;
    private static final int FRAME_RECORD_SIZE = 1;
    private static final long serialVersionUID = 12786283751253L;
    private final Fiber<?> fiber;
    private int sp;
    private transient boolean pushed;
    private long[] dataLong;
    private Object[] dataObject;
    private static final long MASK_FULL = -1L;

    Stack(Fiber<?> fiber, int stackSize) {
        if (stackSize <= 0) {
            throw new IllegalArgumentException("stackSize");
        }
        this.fiber = fiber;
        this.dataLong = new long[stackSize + 16];
        this.dataObject = new Object[stackSize + 16];
        this.resumeStack();
    }

    public static Stack getStack() {
        Fiber<?> currentFiber = Fiber.currentFiber();
        return currentFiber != null ? currentFiber.stack : null;
    }

    Fiber<?> getFiber() {
        return this.fiber;
    }

    final void resumeStack() {
        this.sp = 0;
    }

    void resetStack() {
        this.resumeStack();
    }

    public final int nextMethodEntry() {
        int idx = 0;
        int slots = 0;
        if (this.sp > 0) {
            slots = Stack.getNumSlots(this.dataLong[this.sp - 1]);
            idx = this.sp + slots;
        }
        this.sp = idx + 1;
        long record = this.dataLong[idx];
        int entry = Stack.getEntry(record);
        this.dataLong[idx] = Stack.setPrevNumSlots(record, slots);
        if (this.fiber.isRecordingLevel(2)) {
            this.fiber.record(2, "Stack", "nextMethodEntry", "%s %s %s", (Object)Thread.currentThread().getStackTrace()[2], (Object)entry, (Object)this.sp);
        }
        return entry;
    }

    public final boolean isFirstInStackOrPushed() {
        boolean p = this.pushed;
        this.pushed = false;
        if (this.sp == 1 | p) {
            return true;
        }
        this.sp -= 1 + Stack.getPrevNumSlots(this.dataLong[this.sp - 1]);
        return false;
    }

    public final void pushMethod(int entry, int numSlots) {
        this.pushed = true;
        int idx = this.sp - 1;
        long record = this.dataLong[idx];
        record = Stack.setEntry(record, entry);
        this.dataLong[idx] = record = Stack.setNumSlots(record, numSlots);
        int nextMethodIdx = this.sp + numSlots;
        int nextMethodSP = nextMethodIdx + 1;
        if (nextMethodSP >= this.dataObject.length) {
            this.growStack(nextMethodSP);
        }
        this.dataLong[nextMethodIdx] = 0L;
        if (this.fiber.isRecordingLevel(2)) {
            this.fiber.record(2, "Stack", "pushMethod     ", "%s %d %d", (Object)Thread.currentThread().getStackTrace()[2], (Object)entry, (Object)this.sp);
        }
    }

    public final void popMethod(int slots) {
        this.pushed = false;
        int oldSP = this.sp;
        int idx = oldSP - 1;
        long record = this.dataLong[idx];
        int newSP = idx - Stack.getPrevNumSlots(record);
        this.dataLong[idx] = 0L;
        for (int i = oldSP; i < oldSP + slots && i < this.dataObject.length; ++i) {
            this.dataObject[i] = null;
        }
        this.sp = newSP;
        if (this.fiber.isRecordingLevel(2)) {
            this.fiber.record(2, "Stack", "popMethod      ", "%s %d", (Object)Thread.currentThread().getStackTrace()[2], (Object)this.sp);
        }
    }

    public final void postRestore() throws SuspendExecution, InterruptedException {
        this.fiber.onResume();
    }

    public final void preemptionPoint(int type) throws SuspendExecution {
        this.fiber.preemptionPoint(type);
    }

    private void growStack(int required) {
        int newSize = this.dataObject.length;
        while ((newSize *= 2) < required) {
        }
        this.dataLong = Arrays.copyOf(this.dataLong, newSize);
        this.dataObject = Arrays.copyOf(this.dataObject, newSize);
    }

    void dump() {
        int m = 0;
        int k = 0;
        while (k < this.sp - 1) {
            long record = this.dataLong[k++];
            int slots = Stack.getNumSlots(record);
            System.err.println("\tm=" + m++ + " entry=" + Stack.getEntry(record) + " sp=" + k + " slots=" + slots + " prevSlots=" + Stack.getPrevNumSlots(record));
            int i = 0;
            while (i < slots) {
                System.err.println("\t\tsp=" + k + " long=" + this.dataLong[k] + " obj=" + this.dataObject[k]);
                ++i;
                ++k;
            }
        }
    }

    public static void push(int value, Stack s, int idx) {
        s.dataLong[s.sp + idx] = value;
    }

    public static void push(float value, Stack s, int idx) {
        s.dataLong[s.sp + idx] = Float.floatToRawIntBits(value);
    }

    public static void push(long value, Stack s, int idx) {
        s.dataLong[s.sp + idx] = value;
    }

    public static void push(double value, Stack s, int idx) {
        s.dataLong[s.sp + idx] = Double.doubleToRawLongBits(value);
    }

    public static void push(Object value, Stack s, int idx) {
        s.dataObject[s.sp + idx] = value;
    }

    public final int getInt(int idx) {
        return (int)this.dataLong[this.sp + idx];
    }

    public final float getFloat(int idx) {
        return Float.intBitsToFloat((int)this.dataLong[this.sp + idx]);
    }

    public final long getLong(int idx) {
        return this.dataLong[this.sp + idx];
    }

    public final double getDouble(int idx) {
        return Double.longBitsToDouble(this.dataLong[this.sp + idx]);
    }

    public final Object getObject(int idx) {
        return this.dataObject[this.sp + idx];
    }

    private static long setEntry(long record, int entry) {
        return Stack.setBits(record, 0, 14, entry);
    }

    private static int getEntry(long record) {
        return (int)Stack.getUnsignedBits(record, 0, 14);
    }

    private static long setNumSlots(long record, int numSlots) {
        return Stack.setBits(record, 14, 16, numSlots);
    }

    private static int getNumSlots(long record) {
        return (int)Stack.getUnsignedBits(record, 14, 16);
    }

    private static long setPrevNumSlots(long record, int numSlots) {
        return Stack.setBits(record, 30, 16, numSlots);
    }

    private static int getPrevNumSlots(long record) {
        return (int)Stack.getUnsignedBits(record, 30, 16);
    }

    private static long getUnsignedBits(long word, int offset, int length) {
        int a = 64 - length;
        int b = a - offset;
        return word >>> b & -1L >>> a;
    }

    private static long getSignedBits(long word, int offset, int length) {
        int a = 64 - length;
        int b = a - offset;
        long xx = word >>> b & -1L >>> a;
        return xx << a >> a;
    }

    private static long setBits(long word, int offset, int length, long value) {
        int a = 64 - length;
        int b = a - offset;
        word &= -1L >>> a << b ^ 0xFFFFFFFFFFFFFFFFL;
        return word |= value << b;
    }

    private static boolean getBit(long word, int offset) {
        return Stack.getUnsignedBits(word, offset, 1) != 0L;
    }

    private static long setBit(long word, int offset, boolean value) {
        return Stack.setBits(word, offset, 1, value ? 1L : 0L);
    }

    static class TraceLine {
        final String method;
        final int line;
        final boolean pushed;

        TraceLine(String method, int line, boolean pushed) {
            this.method = method;
            this.line = line;
            this.pushed = pushed;
        }

        TraceLine(String method, int line) {
            this(method, line, true);
        }
    }
}

