/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.fibers;

import co.paralleluniverse.fibers.Fiber;
import co.paralleluniverse.fibers.FiberScheduler;
import co.paralleluniverse.fibers.Instrumented;
import co.paralleluniverse.fibers.SuspendExecution;
import co.paralleluniverse.strands.concurrent.ReentrantLock;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;

@Instrumented
public class SchedulerLocal<T> {
    private final Lock lock = new ReentrantLock();

    protected T initialValue(FiberScheduler scheduler) {
        return null;
    }

    public final void set(T value) {
        this.getEntry(SchedulerLocal.getMap()).value = value;
    }

    public final void remove() {
        SchedulerLocal.getMap().remove(this);
    }

    private static ConcurrentMap<SchedulerLocal<?>, Entry<?>> getMap() {
        return SchedulerLocal.currentScheduler().schedLocals;
    }

    private Entry<T> getEntry(ConcurrentMap<SchedulerLocal<?>, Entry<?>> map) {
        Entry old;
        Entry entry = (Entry)map.get(this);
        if (entry == null && (old = map.putIfAbsent(this, entry = new Entry())) != null) {
            entry = old;
        }
        return entry;
    }

    private static FiberScheduler currentScheduler() {
        Fiber<?> currentFiber = Fiber.currentFiber();
        if (currentFiber == null) {
            throw new IllegalStateException("Method called not within a fiber");
        }
        return currentFiber.getScheduler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Instrumented(methodOptimized=true, methodStart=43, methodEnd=60, suspendableCallSites={}, suspendableCallSiteNames={}, suspendableCallSitesOffsetsAfterInstr={})
    public final T get() throws SuspendExecution {
        FiberScheduler scheduler = SchedulerLocal.currentScheduler();
        ConcurrentMap<SchedulerLocal<?>, Entry<?>> map = scheduler.schedLocals;
        Entry entry = (Entry)map.get(this);
        if (entry == null) {
            this.lock.lock();
            try {
                entry = (Entry)map.get(this);
                if (entry == null) {
                    entry = new Entry();
                    entry.value = this.initialValue(scheduler);
                    Entry old = map.putIfAbsent(this, entry);
                    assert (old == null);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return entry.value;
    }

    static class Entry<T> {
        T value;

        Entry() {
        }
    }
}

