/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.fibers;

import co.paralleluniverse.common.monitoring.Metrics;
import co.paralleluniverse.fibers.Fiber;
import co.paralleluniverse.fibers.FiberScheduler;
import co.paralleluniverse.fibers.FibersMonitor;
import co.paralleluniverse.strands.Strand;
import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

class MetricsFibersMonitor
implements FibersMonitor {
    private final Counter activeCount;
    private final Counter waitingCount;
    private final Meter spuriousWakeups;
    private final Histogram timedParkLatency;
    private final Gauge<Map<String, String>> runawayFibers;
    private Map<Fiber<?>, StackTraceElement[]> problemFibers;

    public MetricsFibersMonitor(String name, FiberScheduler scheduler) {
        this.activeCount = Metrics.counter(this.metric(name, "numActiveFibers"));
        this.waitingCount = Metrics.counter(this.metric(name, "numWaitingFibers"));
        this.spuriousWakeups = Metrics.meter(this.metric(name, "spuriousWakeups"));
        this.timedParkLatency = Metrics.histogram(this.metric(name, "timedParkLatency"));
        this.runawayFibers = new Gauge<Map<String, String>>(){

            public Map<String, String> getValue() {
                HashMap<String, String> map = new HashMap<String, String>();
                if (MetricsFibersMonitor.this.problemFibers != null) {
                    for (Map.Entry e : MetricsFibersMonitor.this.problemFibers.entrySet()) {
                        map.put(((Fiber)e.getKey()).toString(), Strand.toString((StackTraceElement[])e.getValue()));
                    }
                }
                return map;
            }
        };
        Metrics.register("runawayFibers", this.runawayFibers);
    }

    protected final String metric(String poolName, String name) {
        return MetricRegistry.name((String)"co.paralleluniverse", (String[])new String[]{"fibers", poolName, name});
    }

    @Override
    public void unregister() {
    }

    @Override
    public void fiberStarted(Fiber<?> fiber) {
        this.activeCount.inc();
    }

    @Override
    public void fiberTerminated(Fiber<?> fiber) {
        this.activeCount.dec();
    }

    @Override
    public void fiberSuspended() {
        this.waitingCount.inc();
    }

    @Override
    public void fiberResumed() {
        this.waitingCount.dec();
    }

    @Override
    public void spuriousWakeup() {
        this.spuriousWakeups.mark();
    }

    @Override
    public void timedParkLatency(long ns) {
        this.timedParkLatency.update(ns);
    }

    @Override
    public void setRunawayFibers(Collection<Fiber<?>> fs) {
        if (fs == null || fs.isEmpty()) {
            this.problemFibers = null;
        } else {
            this.problemFibers = new HashMap();
            for (Fiber<?> f : fs) {
                this.problemFibers.put(f, f.getStackTrace());
            }
        }
    }
}

