/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.fibers;

import co.paralleluniverse.common.asm.ASMUtil;
import co.paralleluniverse.common.util.ExtendedStackTraceElement;
import co.paralleluniverse.common.util.Pair;
import co.paralleluniverse.fibers.Instrumented;
import co.paralleluniverse.fibers.instrument.SuspendableHelper;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;

final class FiberHelper {
    static Member lookupMethod(ExtendedStackTraceElement ste) {
        if (ste.getDeclaringClass() == null) {
            return null;
        }
        if (ste.getMethod() != null) {
            return ste.getMethod();
        }
        return AccessController.doPrivileged(new LookupMethod(ste));
    }

    static Pair<Boolean, Instrumented> isCallSiteInstrumented(Member m, int sourceLine, int bci, ExtendedStackTraceElement[] stes, int currentSteIdx) {
        Instrumented i;
        block16: {
            int[] scs;
            block15: {
                ExtendedStackTraceElement calleeSte;
                if (m == null) {
                    return new Pair<Boolean, Object>(false, null);
                }
                if (SuspendableHelper.isSyntheticAndNotLambda(m)) {
                    return new Pair<Boolean, Object>(true, null);
                }
                ExtendedStackTraceElement extendedStackTraceElement = calleeSte = currentSteIdx - 1 >= 0 ? stes[currentSteIdx - 1] : null;
                if (calleeSte != null && (calleeSte.getClassName().equals("co.paralleluniverse.fibers.Fiber") && calleeSte.getMethodName().equals("verifySuspend") || calleeSte.getClassName().equals("co.paralleluniverse.fibers.Stack") && calleeSte.getMethodName().equals("popMethod"))) {
                    return new Pair<Boolean, Object>(true, null);
                }
                i = FiberHelper.getAnnotation(m, Instrumented.class);
                if (i == null) {
                    return new Pair<Boolean, Object>(false, null);
                }
                if (calleeSte != null) {
                    Member callee = calleeSte.getMethod();
                    if (callee == null) {
                        String methodName = "." + calleeSte.getMethodName() + "(";
                        String[] stringArray = i.suspendableCallSiteNames();
                        int n = stringArray.length;
                        for (int j = 0; j < n; ++j) {
                            String callsite = stringArray[j];
                            if (!callsite.contains(methodName)) continue;
                            return new Pair<Boolean, Instrumented>(true, i);
                        }
                    } else {
                        String[] callsites;
                        String nameAndDescSuffix = "." + callee.getName() + ASMUtil.getDescriptor(callee);
                        for (String callsite : callsites = i.suspendableCallSiteNames()) {
                            Class<?> owner;
                            Class<?> callsiteOwner;
                            if (!callsite.endsWith(nameAndDescSuffix)) continue;
                            String ownerName = FiberHelper.getCallsiteOwner(callsite);
                            try {
                                callsiteOwner = Class.forName(ownerName, true, Thread.currentThread().getContextClassLoader());
                            }
                            catch (ClassNotFoundException e) {
                                try {
                                    callsiteOwner = Class.forName(ownerName, true, FiberHelper.class.getClassLoader());
                                }
                                catch (ClassNotFoundException e2) {
                                    callsiteOwner = null;
                                }
                            }
                            if (callsiteOwner == null || !AccessController.doPrivileged(new DeclareInCommonAncestor(nameAndDescSuffix, owner = callee.getDeclaringClass(), callsiteOwner)).booleanValue()) continue;
                            return new Pair<Boolean, Instrumented>(true, i);
                        }
                    }
                }
                if (bci < 0) break block15;
                for (int j : scs = i.suspendableCallSitesOffsetsAfterInstr()) {
                    if (j != bci) continue;
                    return new Pair<Boolean, Instrumented>(true, i);
                }
                break block16;
            }
            if (sourceLine < 0) break block16;
            for (int j : scs = i.suspendableCallSites()) {
                if (j != sourceLine) continue;
                return new Pair<Boolean, Instrumented>(true, i);
            }
        }
        return new Pair<Boolean, Instrumented>(false, i);
    }

    private static boolean declareInCommonAncestor(String nameAndDescSuffix, Class<?> c1, Class<?> c2) {
        if (nameAndDescSuffix == null || c1 == null || c2 == null) {
            return false;
        }
        if (c1.isAssignableFrom(c2)) {
            return FiberHelper.hasMethodWithDescriptor(nameAndDescSuffix, c1);
        }
        if (c2.isAssignableFrom(c1)) {
            return FiberHelper.hasMethodWithDescriptor(nameAndDescSuffix, c2);
        }
        return FiberHelper.declareInCommonAncestor(nameAndDescSuffix, c1.getSuperclass(), c2) || FiberHelper.declareInCommonAncestor(nameAndDescSuffix, c1.getInterfaces(), c2);
    }

    private static boolean hasMethodWithDescriptor(String nameAndDescSuffix, Class<?> c) {
        if (nameAndDescSuffix == null || c == null) {
            return false;
        }
        for (Method method : c.getDeclaredMethods()) {
            String n = "." + method.getName() + ASMUtil.getDescriptor(method);
            if (!nameAndDescSuffix.equals(n)) continue;
            return true;
        }
        if (FiberHelper.hasMethodWithDescriptor(nameAndDescSuffix, c.getSuperclass())) {
            return true;
        }
        for (GenericDeclaration genericDeclaration : c.getInterfaces()) {
            if (!FiberHelper.hasMethodWithDescriptor(nameAndDescSuffix, genericDeclaration)) continue;
            return true;
        }
        return false;
    }

    private static boolean declareInCommonAncestor(String nameAndDescSuffix, Class<?>[] c1s, Class<?> c2) {
        if (nameAndDescSuffix == null || c1s == null || c2 == null) {
            return false;
        }
        for (Class<?> c1 : c1s) {
            if (!FiberHelper.declareInCommonAncestor(nameAndDescSuffix, c1, c2)) continue;
            return true;
        }
        return false;
    }

    static String getCallsiteOwner(String callsiteName) {
        return callsiteName.substring(0, callsiteName.indexOf(46)).replace('/', '.');
    }

    static String getCallsiteName(String callsiteName) {
        return callsiteName.substring(callsiteName.indexOf(46) + 1, callsiteName.indexOf(40));
    }

    static String getCallsiteDesc(String callsiteName) {
        return callsiteName.substring(callsiteName.indexOf(40));
    }

    static boolean isInstrumented(Member m) {
        return m != null && (SuspendableHelper.isSyntheticAndNotLambda(m) || FiberHelper.getAnnotation(m, Instrumented.class) != null);
    }

    static boolean isOptimized(Member m) {
        if (m == null) {
            return false;
        }
        Instrumented i = FiberHelper.getAnnotation(m, Instrumented.class);
        return i != null && i.methodOptimized();
    }

    private static <T extends Annotation> T getAnnotation(Member m, Class<T> annotationClass) {
        if (m == null || annotationClass == null) {
            return null;
        }
        if (m instanceof Constructor) {
            return ((Constructor)m).getAnnotation(annotationClass);
        }
        return ((Method)m).getAnnotation(annotationClass);
    }

    private FiberHelper() {
    }

    static final class DeclareInCommonAncestor
    implements PrivilegedAction<Boolean> {
        private final String nameAndDescSuffix;
        private final Class<?> owner;
        private final Class<?> callsiteOwner;

        DeclareInCommonAncestor(String nameAndDescSuffix, Class<?> owner, Class<?> callsiteOwner) {
            this.nameAndDescSuffix = nameAndDescSuffix;
            this.owner = owner;
            this.callsiteOwner = callsiteOwner;
        }

        @Override
        public Boolean run() {
            return FiberHelper.declareInCommonAncestor(this.nameAndDescSuffix, this.owner, this.callsiteOwner);
        }
    }

    static final class LookupMethod
    implements PrivilegedAction<Method> {
        private final ExtendedStackTraceElement ste;

        LookupMethod(ExtendedStackTraceElement ste) {
            this.ste = ste;
        }

        @Override
        public Method run() {
            for (Method m : this.ste.getDeclaringClass().getDeclaredMethods()) {
                if (!m.getName().equals(this.ste.getMethodName())) continue;
                Instrumented i = (Instrumented)FiberHelper.getAnnotation(m, Instrumented.class);
                if (!m.isSynthetic() && !SuspendableHelper.isWaiver(m.getDeclaringClass().getName(), m.getName()) && (i == null || this.ste.getLineNumber() < i.methodStart() || this.ste.getLineNumber() > i.methodEnd())) continue;
                return m;
            }
            return null;
        }
    }
}

