/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.fibers;

import co.paralleluniverse.common.monitoring.MonitorType;
import co.paralleluniverse.fibers.FiberForkJoinScheduler;
import co.paralleluniverse.fibers.FiberScheduler;

public class DefaultFiberScheduler {
    private static final String PROPERTY_PARALLELISM = "co.paralleluniverse.fibers.DefaultFiberPool.parallelism";
    private static final String PROPERTY_EXCEPTION_HANDLER = "co.paralleluniverse.fibers.DefaultFiberPool.exceptionHandler";
    private static final String PROPERTY_MONITOR_TYPE = "co.paralleluniverse.fibers.DefaultFiberPool.monitor";
    private static final String PROPERTY_DETAILED_FIBER_INFO = "co.paralleluniverse.fibers.DefaultFiberPool.detailedFiberInfo";
    private static final int MAX_CAP = Short.MAX_VALUE;
    private static final FiberScheduler instance;

    public static FiberScheduler getInstance() {
        return instance;
    }

    static {
        String dfis;
        String mt;
        String name = "default-fiber-pool";
        int par = 0;
        Thread.UncaughtExceptionHandler handler = null;
        MonitorType monitorType = null;
        boolean detailedFiberInfo = false;
        try {
            String pp = System.getProperty(PROPERTY_PARALLELISM);
            String hp = System.getProperty(PROPERTY_EXCEPTION_HANDLER);
            if (hp != null) {
                handler = (Thread.UncaughtExceptionHandler)ClassLoader.getSystemClassLoader().loadClass(hp).newInstance();
            }
            if (pp != null) {
                par = Integer.parseInt(pp);
            }
        }
        catch (Exception pp) {
            // empty catch block
        }
        if (par <= 0) {
            par = Runtime.getRuntime().availableProcessors();
        }
        if (par > Short.MAX_VALUE) {
            par = Short.MAX_VALUE;
        }
        if ((mt = System.getProperty(PROPERTY_MONITOR_TYPE)) != null) {
            monitorType = MonitorType.valueOf(mt.toUpperCase());
        }
        if ((dfis = System.getProperty(PROPERTY_DETAILED_FIBER_INFO)) != null) {
            detailedFiberInfo = Boolean.parseBoolean(dfis);
        }
        instance = new FiberForkJoinScheduler("default-fiber-pool", par, handler, monitorType, detailedFiberInfo);
    }
}

