/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.concurrent.util;

import co.paralleluniverse.common.reflection.GetDeclaredField;
import co.paralleluniverse.common.util.UtilUnsafe;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.AbstractQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Random;
import sun.misc.Unsafe;

public class ConcurrentSkipListPriorityQueue<E>
extends AbstractQueue<E>
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -8627078645895051609L;
    private static final Random seedGenerator = new Random();
    private static final Object BASE_HEADER = new Object();
    private volatile transient HeadIndex<E> head;
    private final Comparator<? super E> comparator;
    private transient int randomSeed;
    private static final Unsafe UNSAFE;
    private static final long headOffset;

    final void initialize() {
        this.randomSeed = seedGenerator.nextInt() | 0x100;
        this.head = new HeadIndex<Object>(new Node<Object>(null, BASE_HEADER, null), null, null, 1);
    }

    private boolean casHead(HeadIndex<E> cmp, HeadIndex<E> val) {
        return UNSAFE.compareAndSwapObject(this, headOffset, cmp, val);
    }

    private Comparable<? super E> comparable(Object key) throws ClassCastException {
        if (key == null) {
            throw new NullPointerException();
        }
        if (this.comparator != null) {
            return new ComparableUsingComparator<E>(key, this.comparator);
        }
        return (Comparable)key;
    }

    int compare(E k1, E k2) throws ClassCastException {
        Comparator<E> cmp = this.comparator;
        if (cmp != null) {
            return cmp.compare(k1, k2);
        }
        return ((Comparable)k1).compareTo(k2);
    }

    private Node<E> findPredecessor(Comparable<? super E> key) {
        Index q;
        if (key == null) {
            throw new NullPointerException();
        }
        block0: while (true) {
            q = this.head;
            Index r = q.right;
            while (true) {
                Index d;
                if (r != null) {
                    Node n = r.node;
                    Object k = n.key;
                    if (n.value == null) {
                        if (!q.unlink(r)) continue block0;
                        r = q.right;
                        continue;
                    }
                    if (key.compareTo(k) >= 0) {
                        q = r;
                        r = r.right;
                        continue;
                    }
                }
                if ((d = q.down) == null) break block0;
                q = d;
                r = d.right;
            }
            break;
        }
        return q.node;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    Node<E> findNode(Comparable<? super E> key) {
        block0: while (true) {
            b /* !! */  = this.findPredecessor(key);
            n = b /* !! */ .next;
            while (true) {
                if (n == null) {
                    return null;
                }
                f = n.next;
                if (n != b /* !! */ .next) continue block0;
                v = n.value;
                if (v == null) {
                    n.helpDelete(b /* !! */ , f);
                    continue block0;
                }
                if (v != n && b /* !! */ .value != null) ** break;
                continue block0;
                c = key.compareTo(n.key);
                if (c == 0) {
                    if (key.equals(n.key)) {
                        return n;
                    }
                } else if (c < 0) {
                    return null;
                }
                b /* !! */  = n;
                n = f;
            }
            break;
        }
    }

    private E doGet(Object okey) {
        Node<E> n;
        Object v;
        Comparable<E> key = this.comparable(okey);
        do {
            if ((n = this.findNode(key)) != null) continue;
            return null;
        } while ((v = n.value) == null);
        return (E)v;
    }

    private void doPut(E kkey) {
        Node<E> z;
        Comparable<E> key = this.comparable(kkey);
        block0: while (true) {
            Node<E> b = this.findPredecessor(key);
            Node<E> n = b.next;
            while (n != null) {
                Node f = n.next;
                if (n != b.next) continue block0;
                Object v = n.value;
                if (v == null) {
                    n.helpDelete(b, f);
                    continue block0;
                }
                if (v == n || b.value == null) continue block0;
                int c = key.compareTo(n.key);
                if (c < 0) break;
                b = n;
                n = f;
            }
            if (b.casNext(n, z = new Node<E>(kkey, n))) break;
        }
        int level = this.randomLevel();
        if (level > 0) {
            this.insertIndex(z, level);
        }
    }

    private int randomLevel() {
        int x = this.randomSeed;
        x ^= x << 13;
        x ^= x >>> 17;
        x ^= x << 5;
        this.randomSeed = x;
        if ((x & 0x80000001) != 0) {
            return 0;
        }
        int level = 1;
        while (((x >>>= 1) & 1) != 0) {
            ++level;
        }
        return level;
    }

    private void insertIndex(Node<E> z, int level) {
        HeadIndex<E> h = this.head;
        int max = h.level;
        if (level <= max) {
            Index<E> idx = null;
            for (int i = 1; i <= level; ++i) {
                idx = new Index<E>(z, idx, null);
            }
            this.addIndex(idx, h, level);
        } else {
            int k;
            HeadIndex<E> oldh;
            Index[] idxs;
            block7: {
                int oldLevel;
                HeadIndex<E> newh;
                level = max + 1;
                idxs = new Index[level + 1];
                Index<E> idx = null;
                for (int i = 1; i <= level; ++i) {
                    idxs[i] = idx = new Index<E>(z, idx, null);
                }
                do {
                    oldh = this.head;
                    oldLevel = oldh.level;
                    if (level <= oldLevel) {
                        k = level;
                        break block7;
                    }
                    newh = oldh;
                    Node oldbase = oldh.node;
                    for (int j = oldLevel + 1; j <= level; ++j) {
                        newh = new HeadIndex<E>(oldbase, newh, idxs[j], j);
                    }
                } while (!this.casHead(oldh, newh));
                k = oldLevel;
            }
            this.addIndex(idxs[k], oldh, k);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void addIndex(Index<E> idx, HeadIndex<E> h, int indexLevel) {
        insertionLevel = indexLevel;
        key = this.comparable(idx.node.key);
        if (key == null) {
            throw new NullPointerException();
        }
        block0: while (true) {
            j = h.level;
            q = h;
            r = q.right;
            t = idx;
            while (true) {
                if (r != null) {
                    n = r.node;
                    c = key.compareTo(n.key);
                    if (n.value == null) {
                        if (!q.unlink(r)) continue block0;
                        r = q.right;
                        continue;
                    }
                    if (c > 0) {
                        q = r;
                        r = r.right;
                        continue;
                    }
                }
                if (j == insertionLevel) {
                    if (t.indexesDeletedNode()) {
                        this.findNode(key);
                        return;
                    }
                    if (q.link(r, t)) ** break;
                    continue block0;
                    if (--insertionLevel == 0) {
                        if (t.indexesDeletedNode()) {
                            this.findNode(key);
                        }
                        return;
                    }
                }
                if (--j >= insertionLevel && j < indexLevel) {
                    t = t.down;
                }
                q = q.down;
                r = q.right;
            }
            break;
        }
    }

    private E doRemove(Object okey, Object value) {
        Object v;
        Node f;
        Node<Object> n;
        Node<Object> b;
        Comparable<E> key = this.comparable(okey);
        block0: while (true) {
            b = this.findPredecessor(key);
            n = b.next;
            while (true) {
                if (n == null) {
                    return null;
                }
                f = n.next;
                if (n != b.next) continue block0;
                v = n.value;
                if (v == null) {
                    n.helpDelete(b, f);
                    continue block0;
                }
                if (v == n || b.value == null) continue block0;
                int c = key.compareTo(n.key);
                if (c < 0) {
                    return null;
                }
                if (c <= 0) break;
                b = n;
                n = f;
            }
            if (value != null && !value.equals(v)) {
                return null;
            }
            if (n.casValue(v, null)) break;
        }
        if (!n.appendMarker(f) || !b.casNext(n, f)) {
            this.findNode(key);
        } else {
            this.findPredecessor(key);
            if (this.head.right == null) {
                this.tryReduceLevel();
            }
        }
        return (E)v;
    }

    private void tryReduceLevel() {
        HeadIndex e;
        HeadIndex d;
        HeadIndex<E> h = this.head;
        if (h.level > 3 && (d = (HeadIndex)h.down) != null && (e = (HeadIndex)d.down) != null && e.right == null && d.right == null && h.right == null && this.casHead(h, d) && h.right != null) {
            this.casHead(d, h);
        }
    }

    Node<E> findFirst() {
        while (true) {
            Node b = this.head.node;
            Node n = b.next;
            if (n == null) {
                return null;
            }
            if (n.value != null) {
                return n;
            }
            n.helpDelete(b, n.next);
        }
    }

    E doRemoveFirst() {
        Node f;
        Node n;
        Node b;
        while (true) {
            b = this.head.node;
            n = b.next;
            if (n == null) {
                return null;
            }
            f = n.next;
            if (n != b.next) continue;
            Object v = n.value;
            if (v == null) {
                n.helpDelete(b, f);
                continue;
            }
            if (n.casValue(v, null)) break;
        }
        if (!n.appendMarker(f) || !b.casNext(n, f)) {
            this.findFirst();
        }
        this.clearIndexToFirst();
        return (E)n.key;
    }

    private void clearIndexToFirst() {
        block0: while (true) {
            Index q = this.head;
            do {
                Index r;
                if ((r = q.right) != null && r.indexesDeletedNode() && !q.unlink(r)) continue block0;
            } while ((q = q.down) != null);
            break;
        }
        if (this.head.right == null) {
            this.tryReduceLevel();
        }
    }

    Node<E> findLast() {
        Index q = this.head;
        while (true) {
            Index r;
            if ((r = q.right) != null) {
                if (r.indexesDeletedNode()) {
                    q.unlink(r);
                    q = this.head;
                    continue;
                }
                q = r;
                continue;
            }
            Index d = q.down;
            if (d != null) {
                q = d;
                continue;
            }
            Node b = q.node;
            Node n = b.next;
            while (true) {
                if (n == null) {
                    return b.isBaseHeader() ? null : b;
                }
                Node f = n.next;
                if (n != b.next) break;
                Object v = n.value;
                if (v == null) {
                    n.helpDelete(b, f);
                    break;
                }
                if (v == n || b.value == null) break;
                b = n;
                n = f;
            }
            q = this.head;
        }
    }

    private Node<E> findPredecessorOfLast() {
        Index q;
        block0: while (true) {
            q = this.head;
            while (true) {
                Index d;
                Index r;
                if ((r = q.right) != null) {
                    if (r.indexesDeletedNode()) {
                        q.unlink(r);
                        continue block0;
                    }
                    if (r.node.next != null) {
                        q = r;
                        continue;
                    }
                }
                if ((d = q.down) == null) break block0;
                q = d;
            }
            break;
        }
        return q.node;
    }

    E doRemoveLastEntry() {
        Node f;
        Node<Object> n;
        Node<Object> b;
        block0: while (true) {
            Object v;
            b = this.findPredecessorOfLast();
            n = b.next;
            if (n == null) {
                if (!b.isBaseHeader()) continue;
                return null;
            }
            while (true) {
                f = n.next;
                if (n != b.next) continue block0;
                v = n.value;
                if (v == null) {
                    n.helpDelete(b, f);
                    continue block0;
                }
                if (v == n || b.value == null) continue block0;
                if (f == null) break;
                b = n;
                n = f;
            }
            if (n.casValue(v, null)) break;
        }
        Object key = n.key;
        Comparable<E> ck = this.comparable(key);
        if (!n.appendMarker(f) || !b.casNext(n, f)) {
            this.findNode(ck);
        } else {
            this.findPredecessor(ck);
            if (this.head.right == null) {
                this.tryReduceLevel();
            }
        }
        return (E)key;
    }

    public ConcurrentSkipListPriorityQueue() {
        this.comparator = null;
        this.initialize();
    }

    public ConcurrentSkipListPriorityQueue(Comparator<? super E> comparator) {
        this.comparator = comparator;
        this.initialize();
    }

    public ConcurrentSkipListPriorityQueue(Collection<? extends E> m) {
        this.comparator = null;
        this.initialize();
        this.addAll(m);
    }

    public ConcurrentSkipListPriorityQueue<E> clone() {
        ConcurrentSkipListPriorityQueue clone = null;
        try {
            clone = (ConcurrentSkipListPriorityQueue)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        clone.initialize();
        clone.buildFromSorted(this);
        return clone;
    }

    private void buildFromSorted(ConcurrentSkipListPriorityQueue<E> pq) {
        if (pq == null) {
            throw new NullPointerException();
        }
        HeadIndex<E> h = this.head;
        Node<E> basepred = h.node;
        ArrayList<Index<E>> preds = new ArrayList<Index<E>>();
        for (int i = 0; i <= h.level; ++i) {
            preds.add(null);
        }
        Index q = h;
        for (int i = h.level; i > 0; --i) {
            preds.set(i, q);
            q = q.down;
        }
        for (E k : pq) {
            int j = this.randomLevel();
            if (j > h.level) {
                j = h.level + 1;
            }
            if (k == null) {
                throw new NullPointerException();
            }
            Node<E> z = new Node<E>(k, null);
            basepred.next = z;
            basepred = z;
            if (j <= 0) continue;
            Index<E> idx = null;
            for (int i = 1; i <= j; ++i) {
                idx = new Index<E>(z, idx, null);
                if (i > h.level) {
                    h = new HeadIndex<E>(h.node, h, idx, i);
                }
                if (i < preds.size()) {
                    ((Index)preds.get((int)i)).right = idx;
                    preds.set(i, idx);
                    continue;
                }
                preds.add(idx);
            }
        }
        this.head = h;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        Node<Object> n = this.findFirst();
        while (n != null) {
            E v = n.getValidValue();
            if (v != null) {
                s.writeObject(n.key);
            }
            n = n.next;
        }
        s.writeObject(null);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        Object k;
        s.defaultReadObject();
        this.initialize();
        HeadIndex<Object> h = this.head;
        Node<Object> basepred = h.node;
        ArrayList<Index<Object>> preds = new ArrayList<Index<Object>>();
        for (int i = 0; i <= h.level; ++i) {
            preds.add(null);
        }
        Index q = h;
        for (int i = h.level; i > 0; --i) {
            preds.set(i, q);
            q = q.down;
        }
        while ((k = s.readObject()) != null) {
            Object key = k;
            int j = this.randomLevel();
            if (j > h.level) {
                j = h.level + 1;
            }
            Node<Object> z = new Node<Object>(key, null);
            basepred.next = z;
            basepred = z;
            if (j <= 0) continue;
            Index<Object> idx = null;
            for (int i = 1; i <= j; ++i) {
                idx = new Index<Object>(z, idx, null);
                if (i > h.level) {
                    h = new HeadIndex<Object>(h.node, h, idx, i);
                }
                if (i < preds.size()) {
                    ((Index)preds.get((int)i)).right = idx;
                    preds.set(i, idx);
                    continue;
                }
                preds.add(idx);
            }
        }
        this.head = h;
    }

    @Override
    public boolean contains(Object key) {
        return this.doGet(key) != null;
    }

    @Override
    public boolean offer(E key) {
        if (key == null) {
            throw new NullPointerException();
        }
        this.doPut(key);
        return true;
    }

    @Override
    public E poll() {
        return this.doRemoveFirst();
    }

    @Override
    public E peek() {
        Node<E> n = this.findFirst();
        if (n == null) {
            return null;
        }
        return (E)n.key;
    }

    public E peekLast() {
        Node<E> n = this.findLast();
        if (n == null) {
            return null;
        }
        return (E)n.key;
    }

    @Override
    public Iterator<E> iterator() {
        return new Iter();
    }

    @Override
    public boolean remove(Object key) {
        return this.doRemove(key, null) != null;
    }

    @Override
    public int size() {
        long count = 0L;
        Node<Object> n = this.findFirst();
        while (n != null) {
            if (n.getValidValue() != null) {
                ++count;
            }
            n = n.next;
        }
        return count >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)count;
    }

    @Override
    public boolean isEmpty() {
        return this.findFirst() == null;
    }

    @Override
    public void clear() {
        this.initialize();
    }

    public Comparator<? super E> comparator() {
        return this.comparator;
    }

    static <E> List<E> toList(Collection<E> c) {
        ArrayList<E> list = new ArrayList<E>(c.size());
        for (E e : c) {
            list.add(e);
        }
        return list;
    }

    @Override
    public Object[] toArray() {
        return ConcurrentSkipListPriorityQueue.toList(this).toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return ConcurrentSkipListPriorityQueue.toList(this).toArray(a);
    }

    static {
        try {
            UNSAFE = UtilUnsafe.getUnsafe();
            Class<ConcurrentSkipListPriorityQueue> k = ConcurrentSkipListPriorityQueue.class;
            headOffset = UNSAFE.objectFieldOffset(AccessController.doPrivileged(new GetDeclaredField(k, "head")));
        }
        catch (PrivilegedActionException e) {
            throw new Error(e.getCause());
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    class Iter
    implements Iterator<E> {
        Node<E> lastReturned;
        Node<E> next;

        Iter() {
            Object x;
            do {
                this.next = ConcurrentSkipListPriorityQueue.this.findFirst();
            } while (this.next != null && ((x = this.next.value) == null || x == this.next));
        }

        @Override
        public final boolean hasNext() {
            return this.next != null;
        }

        @Override
        public E next() {
            Node n = this.next;
            this.advance();
            return n.key;
        }

        final void advance() {
            Object x;
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.next;
            do {
                this.next = this.next.next;
            } while (this.next != null && ((x = this.next.value) == null || x == this.next));
        }

        @Override
        public void remove() {
            Node l = this.lastReturned;
            if (l == null) {
                throw new IllegalStateException();
            }
            ConcurrentSkipListPriorityQueue.this.remove(l.key);
            this.lastReturned = null;
        }
    }

    static final class ComparableUsingComparator<K>
    implements Comparable<K> {
        final K actualKey;
        final Comparator<? super K> cmp;

        ComparableUsingComparator(K key, Comparator<? super K> cmp) {
            this.actualKey = key;
            this.cmp = cmp;
        }

        @Override
        public int compareTo(K k2) {
            return this.cmp.compare(this.actualKey, k2);
        }
    }

    static final class HeadIndex<V>
    extends Index<V> {
        final int level;

        HeadIndex(Node<V> node, Index<V> down, Index<V> right, int level) {
            super(node, down, right);
            this.level = level;
        }
    }

    static class Index<V> {
        final Node<V> node;
        final Index<V> down;
        volatile Index<V> right;
        private static final Unsafe UNSAFE;
        private static final long rightOffset;

        Index(Node<V> node, Index<V> down, Index<V> right) {
            this.node = node;
            this.down = down;
            this.right = right;
        }

        final boolean casRight(Index<V> cmp, Index<V> val) {
            return UNSAFE.compareAndSwapObject(this, rightOffset, cmp, val);
        }

        final boolean indexesDeletedNode() {
            return this.node.value == null;
        }

        final boolean link(Index<V> succ, Index<V> newSucc) {
            Node<V> n = this.node;
            newSucc.right = succ;
            return n.value != null && this.casRight(succ, newSucc);
        }

        final boolean unlink(Index<V> succ) {
            return !this.indexesDeletedNode() && this.casRight(succ, succ.right);
        }

        static {
            try {
                UNSAFE = UtilUnsafe.getUnsafe();
                Class<Index> k = Index.class;
                rightOffset = UNSAFE.objectFieldOffset(AccessController.doPrivileged(new GetDeclaredField(k, "right")));
            }
            catch (PrivilegedActionException e) {
                throw new Error(e.getCause());
            }
            catch (Exception e) {
                throw new Error(e);
            }
        }
    }

    static final class Node<V> {
        final V key;
        volatile Object value;
        volatile Node<V> next;
        private static final Unsafe UNSAFE;
        private static final long valueOffset;
        private static final long nextOffset;

        Node(V key, Node<V> next) {
            this(key, key, next);
        }

        Node(V key, Object value, Node<V> next) {
            this.key = key;
            this.value = value;
            this.next = next;
        }

        Node(Node<V> next) {
            this.key = null;
            this.value = this;
            this.next = next;
        }

        boolean casValue(Object cmp, Object val) {
            return UNSAFE.compareAndSwapObject(this, valueOffset, cmp, val);
        }

        boolean casNext(Node<V> cmp, Node<V> val) {
            return UNSAFE.compareAndSwapObject(this, nextOffset, cmp, val);
        }

        boolean isMarker() {
            return this.value == this;
        }

        boolean isBaseHeader() {
            return this.value == BASE_HEADER;
        }

        boolean appendMarker(Node<V> f) {
            return this.casNext(f, new Node<V>(f));
        }

        void helpDelete(Node<V> b, Node<V> f) {
            if (f == this.next && this == b.next) {
                if (f == null || f.value != f) {
                    this.appendMarker(f);
                } else {
                    b.casNext(this, f.next);
                }
            }
        }

        V getValidValue() {
            Object v = this.value;
            if (v == this || v == BASE_HEADER) {
                return null;
            }
            return (V)v;
        }

        static {
            try {
                UNSAFE = UtilUnsafe.getUnsafe();
                Class<Node> k = Node.class;
                valueOffset = UNSAFE.objectFieldOffset(AccessController.doPrivileged(new GetDeclaredField(k, "value")));
                nextOffset = UNSAFE.objectFieldOffset(AccessController.doPrivileged(new GetDeclaredField(k, "next")));
            }
            catch (PrivilegedActionException e) {
                throw new Error(e.getCause());
            }
            catch (Exception e) {
                throw new Error(e);
            }
        }
    }
}

