/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.common.util;

import co.paralleluniverse.common.asm.ASMUtil;
import co.paralleluniverse.common.util.ExtendedStackTraceClassContext;
import co.paralleluniverse.common.util.ExtendedStackTraceElement;
import co.paralleluniverse.common.util.ExtendedStackTraceHotSpot;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicReference;

public class ExtendedStackTrace
implements Iterable<ExtendedStackTraceElement> {
    protected final Throwable t;
    private ExtendedStackTraceElement[] est;

    public static ExtendedStackTrace of(Throwable t) {
        try {
            return new ExtendedStackTraceHotSpot(t);
        }
        catch (Throwable e) {
            return new ExtendedStackTrace(t);
        }
    }

    public static ExtendedStackTrace here() {
        try {
            return new ExtendedStackTraceHotSpot(new Throwable());
        }
        catch (Throwable e) {
            return new ExtendedStackTraceClassContext();
        }
    }

    protected ExtendedStackTrace(Throwable t) {
        this.t = t;
    }

    @Override
    public Iterator<ExtendedStackTraceElement> iterator() {
        return Arrays.asList(this.get()).iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExtendedStackTraceElement[] get() {
        ExtendedStackTrace extendedStackTrace = this;
        synchronized (extendedStackTrace) {
            StackTraceElement[] st;
            if (this.est == null && (st = this.t.getStackTrace()) != null) {
                this.est = new ExtendedStackTraceElement[st.length];
                for (int i = 0; i < st.length; ++i) {
                    this.est[i] = new BasicExtendedStackTraceElement(st[i]);
                }
            }
            return this.est;
        }
    }

    protected Member getMethod(ExtendedStackTraceElement este) {
        Member method;
        block6: {
            if (este.getDeclaringClass() == null) {
                return null;
            }
            Member[] ms = this.getMethods(este.getDeclaringClass());
            method = null;
            String targetMethodName = este.getMethodName();
            for (Member m : ms) {
                if (!targetMethodName.equals(m.getName())) continue;
                if (method == null) {
                    method = m;
                    continue;
                }
                method = null;
                break;
            }
            if (method == null && este.getLineNumber() >= 0) {
                try {
                    method = AccessController.doPrivileged(new FindMethod(este, ms, targetMethodName));
                }
                catch (PrivilegedActionException pae) {
                    Exception e = pae.getException();
                    if (e instanceof UnsupportedOperationException) break block6;
                    e.printStackTrace();
                }
            }
        }
        return method;
    }

    protected static String getName(Member m) {
        if (m instanceof Constructor) {
            return "<init>";
        }
        return ((Method)m).getName();
    }

    protected final Member[] getMethods(Class<?> clazz) {
        return AccessController.doPrivileged(new GetMethods(clazz));
    }

    protected class BasicExtendedStackTraceElement
    extends ExtendedStackTraceElement {
        protected BasicExtendedStackTraceElement(StackTraceElement ste, Class<?> clazz, Method method, int bci) {
            super(ste, clazz, method, bci);
        }

        protected BasicExtendedStackTraceElement(StackTraceElement ste, Class<?> clazz) {
            super(ste, clazz, null, -1);
        }

        protected BasicExtendedStackTraceElement(StackTraceElement ste) {
            super(ste, null, null, -1);
        }

        @Override
        public Member getMethod() {
            if (this.method == null) {
                this.method = ExtendedStackTrace.this.getMethod(this);
                if (this.method != null && !this.getMethodName().equals(ExtendedStackTrace.getName(this.method))) {
                    throw new IllegalStateException("Method name mismatch: " + this.getMethodName() + ", " + this.method.getName());
                }
            }
            return this.method;
        }

        @Override
        public Class<?> getDeclaringClass() {
            if (this.clazz == null) {
                try {
                    this.clazz = Class.forName(this.getClassName(), true, Thread.currentThread().getContextClassLoader());
                }
                catch (ClassNotFoundException e) {
                    try {
                        this.clazz = Class.forName(this.getClassName(), true, this.getClass().getClassLoader());
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
            }
            return this.clazz;
        }
    }

    private static final class GetMethods
    implements PrivilegedAction<Member[]> {
        private final Class<?> clazz;

        GetMethods(Class<?> clazz) {
            this.clazz = clazz;
        }

        @Override
        public Member[] run() {
            Method[] ms = this.clazz.getDeclaredMethods();
            Constructor<?>[] cs = this.clazz.getDeclaredConstructors();
            Member[] es = new Member[ms.length + cs.length];
            System.arraycopy(cs, 0, es, 0, cs.length);
            System.arraycopy(ms, 0, es, cs.length, ms.length);
            return es;
        }
    }

    private static class FindMethod
    implements PrivilegedExceptionAction<Member> {
        private final ExtendedStackTraceElement este;
        private final Member[] methods;
        private final String targetName;

        FindMethod(ExtendedStackTraceElement este, Member[] methods, String targetName) {
            this.este = este;
            this.methods = methods;
            this.targetName = targetName;
        }

        @Override
        public Member run() throws IOException {
            AtomicReference<String> exactMatch = new AtomicReference<String>();
            AtomicReference<String> descriptor = new AtomicReference<String>();
            ASMUtil.findMethod(this.este.getDeclaringClass(), this.targetName, this.este.getLineNumber(), exactMatch, descriptor);
            String exactMatchValue = exactMatch.get();
            String descriptorValue = descriptor.get();
            if (exactMatchValue != null) {
                return this.getMatchingMethod(exactMatchValue);
            }
            if (descriptorValue != null) {
                return this.getMatchingMethod(descriptorValue);
            }
            return null;
        }

        private Member getMatchingMethod(String targetDescriptor) {
            for (Member m : this.methods) {
                if (!this.targetName.equals(ExtendedStackTrace.getName(m)) || !targetDescriptor.equals(ASMUtil.getDescriptor(m))) continue;
                return m;
            }
            return null;
        }
    }
}

