/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.common.asm;

import co.paralleluniverse.asm.ClassVisitor;
import co.paralleluniverse.asm.Label;
import co.paralleluniverse.asm.MethodVisitor;
import co.paralleluniverse.asm.Type;
import co.paralleluniverse.asm.tree.ClassNode;
import co.paralleluniverse.common.resource.ClassLoaderUtil;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicReference;

public final class ASMUtil {
    public static final int ASMAPI = 327680;

    public static void findMethod(Class<?> clazz, final String targetMethodName, final int targetLineNumber, final AtomicReference<String> exactMatch, final AtomicReference<String> descriptor) throws IOException {
        co.paralleluniverse.asm.ASMUtil.accept(clazz, 4, new ClassVisitor(327680){

            @Override
            public MethodVisitor visitMethod(int access, String name, final String desc, String signature, String[] exceptions) {
                MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
                if (exactMatch.get() == null && targetMethodName.equals(name)) {
                    mv = new MethodVisitor(this.api, mv){
                        int minLine;
                        int maxLine;
                        {
                            super(x0, x1);
                            this.minLine = Integer.MAX_VALUE;
                            this.maxLine = Integer.MIN_VALUE;
                        }

                        @Override
                        public void visitLineNumber(int line, Label start) {
                            if (line < this.minLine) {
                                this.minLine = line;
                            }
                            if (line > this.maxLine) {
                                this.maxLine = line;
                            }
                            if (targetLineNumber == line) {
                                exactMatch.set(desc);
                            }
                        }

                        @Override
                        public void visitEnd() {
                            if (this.minLine <= targetLineNumber && this.maxLine >= targetLineNumber) {
                                descriptor.compareAndSet(null, desc);
                            }
                            super.visitEnd();
                        }
                    };
                }
                return mv;
            }
        });
    }

    public static boolean isAssignableFrom(Class<?> supertype, String className, ClassLoader cl) {
        return ASMUtil.isAssignableFrom0(ClassLoaderUtil.classToSlashed(supertype), ClassLoaderUtil.classToSlashed(className), cl);
    }

    public static boolean isAssignableFrom(String supertypeName, String className, ClassLoader cl) {
        return ASMUtil.isAssignableFrom0(ClassLoaderUtil.classToSlashed(supertypeName), ClassLoaderUtil.classToSlashed(className), cl);
    }

    private static boolean isAssignableFrom0(String supertypeName, String className, ClassLoader cl) {
        try {
            if (className == null) {
                return false;
            }
            if (supertypeName.equals(className)) {
                return true;
            }
            ClassNode cn = co.paralleluniverse.asm.ASMUtil.getClassNode(className, cl, true);
            if (supertypeName.equals(cn.superName)) {
                return true;
            }
            if (ASMUtil.isAssignableFrom0(supertypeName, cn.superName, cl)) {
                return true;
            }
            if (cn.interfaces != null) {
                for (String iface : cn.interfaces) {
                    if (supertypeName.equals(iface)) {
                        return true;
                    }
                    if (!ASMUtil.isAssignableFrom0(supertypeName, iface, cl)) continue;
                    return true;
                }
            }
            return false;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getDescriptor(Member m) {
        if (m instanceof Method) {
            return Type.getMethodDescriptor((Method)m);
        }
        if (m instanceof Constructor) {
            return Type.getConstructorDescriptor((Constructor)m);
        }
        throw new IllegalArgumentException("Not an executable: " + m);
    }

    public static String getReadableDescriptor(String descriptor) {
        Type[] types = Type.getArgumentTypes(descriptor);
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        for (int i = 0; i < types.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(types[i].getClassName());
        }
        sb.append(')');
        return sb.toString();
    }

    private ASMUtil() {
    }
}

