/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.asm;

import co.paralleluniverse.asm.ClassReader;
import co.paralleluniverse.asm.ClassVisitor;
import co.paralleluniverse.asm.Type;
import co.paralleluniverse.asm.tree.AnnotationNode;
import co.paralleluniverse.asm.tree.ClassNode;
import co.paralleluniverse.asm.tree.MethodNode;
import co.paralleluniverse.common.resource.ClassLoaderUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Objects;

public final class ASMUtil {
    public static InputStream getClassInputStream(String className, ClassLoader cl) {
        String resource = ClassLoaderUtil.classToResource(className);
        return cl != null ? cl.getResourceAsStream(resource) : ClassLoader.getSystemResourceAsStream(resource);
    }

    public static InputStream getClassInputStream(Class<?> clazz) {
        InputStream is = ASMUtil.getClassInputStream(clazz.getName(), clazz.getClassLoader());
        if (is == null) {
            throw new UnsupportedOperationException("Class file " + clazz.getName() + " could not be loaded by the class's classloader " + clazz.getClassLoader());
        }
        return is;
    }

    public static <T extends ClassVisitor> T accept(InputStream is, int flags, T visitor) throws IOException {
        if (is == null) {
            return null;
        }
        try (InputStream is1 = is;){
            new ClassReader(is1).accept(visitor, flags);
            T t = visitor;
            return t;
        }
    }

    public static <T extends ClassVisitor> T accept(byte[] buffer, int flags, T visitor) {
        if (buffer == null) {
            throw new NullPointerException("Buffer is null");
        }
        new ClassReader(buffer).accept(visitor, flags);
        return visitor;
    }

    public static <T extends ClassVisitor> T accept(String className, ClassLoader cl, int flags, T visitor) throws IOException {
        return ASMUtil.accept(ASMUtil.getClassInputStream(className, cl), flags, visitor);
    }

    public static <T extends ClassVisitor> T accept(Class<?> clazz, int flags, T visitor) throws IOException {
        return ASMUtil.accept(ASMUtil.getClassInputStream(clazz), flags, visitor);
    }

    public static ClassNode getClassNode(InputStream is, boolean skipCode) throws IOException {
        return ASMUtil.accept(is, 2 | (skipCode ? 0 : 1), new ClassNode());
    }

    public static ClassNode getClassNode(String className, ClassLoader cl, boolean skipCode) throws IOException {
        ClassNode cn = ASMUtil.getClassNode(ASMUtil.getClassInputStream(className, cl), skipCode);
        if (cn == null) {
            throw new IOException("Resource " + ClassLoaderUtil.classToResource(className) + " not found.");
        }
        return cn;
    }

    public static boolean hasAnnotation(String annDesc, List<AnnotationNode> anns) {
        if (anns == null) {
            return false;
        }
        for (AnnotationNode ann : anns) {
            if (!ann.desc.equals(annDesc)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasAnnotation(Class<?> ann, List<AnnotationNode> anns) {
        return ASMUtil.hasAnnotation(Type.getDescriptor(ann), anns);
    }

    public static boolean hasAnnotation(Class<?> ann, MethodNode m) {
        return ASMUtil.hasAnnotation(ann, (List<AnnotationNode>)m.visibleAnnotations);
    }

    public static MethodNode getMethod(MethodNode method, List<MethodNode> ms) {
        if (ms == null) {
            return null;
        }
        for (MethodNode m : ms) {
            if (!ASMUtil.equals(method, m)) continue;
            return m;
        }
        return null;
    }

    public static MethodNode getMethod(MethodNode method, ClassNode c) {
        return ASMUtil.getMethod(method, c.methods);
    }

    public static boolean hasMethod(MethodNode method, List<MethodNode> ms) {
        return ASMUtil.getMethod(method, ms) != null;
    }

    public static boolean hasMethod(MethodNode method, ClassNode c) {
        return ASMUtil.hasMethod(method, c.methods);
    }

    public static boolean equals(MethodNode m1, MethodNode m2) {
        return Objects.equals(m1.name, m2.name) && Objects.equals(m1.desc, m2.desc);
    }

    public static boolean equals(ClassNode c1, ClassNode c2) {
        return Objects.equals(c1.name, c2.name);
    }

    private ASMUtil() {
    }
}

