/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.usermanager;

import java.io.Serializable;
import java.util.ArrayList;
import org.apache.ftpserver.ftplet.Authority;
import org.apache.ftpserver.ftplet.AuthorizationRequest;
import org.apache.ftpserver.ftplet.User;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseUser
implements User,
Serializable {
    private static final long serialVersionUID = -47371353779731294L;
    private String name = null;
    private String password = null;
    private int maxIdleTimeSec = 0;
    private String homeDir = null;
    private boolean isEnabled = true;
    private Authority[] authorities = new Authority[0];

    public BaseUser() {
    }

    public BaseUser(User user) {
        this.name = user.getName();
        this.password = user.getPassword();
        this.authorities = user.getAuthorities();
        this.maxIdleTimeSec = user.getMaxIdleTime();
        this.homeDir = user.getHomeDirectory();
        this.isEnabled = user.getEnabled();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String pass) {
        this.password = pass;
    }

    public Authority[] getAuthorities() {
        return this.authorities;
    }

    public void setAuthorities(Authority[] authorities) {
        this.authorities = authorities;
    }

    public int getMaxIdleTime() {
        return this.maxIdleTimeSec;
    }

    public void setMaxIdleTime(int idleSec) {
        this.maxIdleTimeSec = idleSec;
        if (this.maxIdleTimeSec < 0) {
            this.maxIdleTimeSec = 0;
        }
    }

    public boolean getEnabled() {
        return this.isEnabled;
    }

    public void setEnabled(boolean enb) {
        this.isEnabled = enb;
    }

    public String getHomeDirectory() {
        return this.homeDir;
    }

    public void setHomeDirectory(String home) {
        this.homeDir = home;
    }

    public String toString() {
        return this.name;
    }

    public AuthorizationRequest authorize(AuthorizationRequest request) {
        Authority[] authorities = this.getAuthorities();
        boolean someoneCouldAuthorize = false;
        for (int i = 0; i < authorities.length; ++i) {
            Authority authority = authorities[i];
            if (!authority.canAuthorize(request)) continue;
            someoneCouldAuthorize = true;
            if ((request = authority.authorize(request)) != null) continue;
            return null;
        }
        if (someoneCouldAuthorize) {
            return request;
        }
        return null;
    }

    public Authority[] getAuthorities(Class<Authority> clazz) {
        ArrayList<Authority> selected = new ArrayList<Authority>();
        for (int i = 0; i < this.authorities.length; ++i) {
            if (!this.authorities[i].getClass().equals(clazz)) continue;
            selected.add(this.authorities[i]);
        }
        return selected.toArray(new Authority[0]);
    }
}

