/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.listener.mina;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.ftpserver.DefaultFtpHandler;
import org.apache.ftpserver.FtpHandler;
import org.apache.ftpserver.filter.FtpLoggingFilter;
import org.apache.ftpserver.interfaces.FtpIoSession;
import org.apache.ftpserver.interfaces.FtpServerContext;
import org.apache.ftpserver.listener.AbstractListener;
import org.apache.ftpserver.listener.mina.FtpHandlerAdapter;
import org.apache.ftpserver.listener.mina.FtpServerProtocolCodecFactory;
import org.apache.ftpserver.ssl.ClientAuth;
import org.apache.ftpserver.ssl.SslConfiguration;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.executor.ExecutorFilter;
import org.apache.mina.filter.executor.OrderedThreadPoolExecutor;
import org.apache.mina.filter.firewall.BlacklistFilter;
import org.apache.mina.filter.firewall.Subnet;
import org.apache.mina.filter.logging.MdcInjectionFilter;
import org.apache.mina.filter.ssl.SslFilter;
import org.apache.mina.transport.socket.SocketAcceptor;
import org.apache.mina.transport.socket.nio.NioSocketAcceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MinaListener
extends AbstractListener {
    private final Logger LOG = LoggerFactory.getLogger(MinaListener.class);
    private SocketAcceptor acceptor;
    private InetSocketAddress address;
    boolean suspended = false;
    private ExecutorService filterExecutor = new OrderedThreadPoolExecutor();
    private FtpHandler handler = new DefaultFtpHandler();
    private int idleTimeout = 300;
    private List<InetAddress> blockedAddresses;
    private List<Subnet> blockedSubnets;
    private FtpServerContext context;

    public int getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(int idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    private void updateBlacklistFilter() {
        BlacklistFilter filter;
        if (this.acceptor != null && (filter = (BlacklistFilter)this.acceptor.getFilterChain().get("ipFilter")) != null) {
            if (this.blockedAddresses != null) {
                filter.setBlacklist(this.blockedAddresses);
            } else if (this.blockedSubnets != null) {
                filter.setSubnetBlacklist(this.blockedSubnets);
            } else {
                filter.setSubnetBlacklist(new ArrayList());
            }
        }
    }

    @Override
    public void start(FtpServerContext context) throws Exception {
        this.context = context;
        this.acceptor = new NioSocketAcceptor(Runtime.getRuntime().availableProcessors());
        this.address = this.getServerAddress() != null ? new InetSocketAddress(this.getServerAddress(), this.getPort()) : new InetSocketAddress(this.getPort());
        this.acceptor.setReuseAddress(true);
        this.acceptor.getSessionConfig().setReadBufferSize(2048);
        this.acceptor.getSessionConfig().setIdleTime(IdleStatus.BOTH_IDLE, this.idleTimeout);
        this.acceptor.getSessionConfig().setReceiveBufferSize(512);
        MdcInjectionFilter mdcFilter = new MdcInjectionFilter();
        this.acceptor.getFilterChain().addLast("mdcFilter", (IoFilter)mdcFilter);
        this.acceptor.getFilterChain().addLast("ipFilter", (IoFilter)new BlacklistFilter());
        this.updateBlacklistFilter();
        this.acceptor.getFilterChain().addLast("threadPool", (IoFilter)new ExecutorFilter((Executor)this.filterExecutor));
        this.acceptor.getFilterChain().addLast("codec", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)new FtpServerProtocolCodecFactory()));
        this.acceptor.getFilterChain().addLast("logger", (IoFilter)new FtpLoggingFilter());
        this.acceptor.getFilterChain().addLast("mdcFilter2", (IoFilter)mdcFilter);
        if (this.isImplicitSsl()) {
            SslConfiguration ssl = this.getSsl();
            SslFilter sslFilter = new SslFilter(ssl.getSSLContext());
            if (ssl.getClientAuth() == ClientAuth.NEED) {
                sslFilter.setNeedClientAuth(true);
            } else if (ssl.getClientAuth() == ClientAuth.WANT) {
                sslFilter.setWantClientAuth(true);
            }
            if (ssl.getEnabledCipherSuites() != null) {
                sslFilter.setEnabledCipherSuites(ssl.getEnabledCipherSuites());
            }
            this.acceptor.getFilterChain().addFirst("sslFilter", (IoFilter)sslFilter);
        }
        this.handler.init(context, this);
        this.acceptor.setHandler((IoHandler)new FtpHandlerAdapter(context, this.handler));
        this.acceptor.bind((SocketAddress)this.address);
        this.setPort(this.acceptor.getLocalAddress().getPort());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void stop() {
        if (this.acceptor != null) {
            this.acceptor.unbind();
            this.acceptor.dispose();
            this.acceptor = null;
        }
        if (this.filterExecutor != null) {
            this.filterExecutor.shutdown();
            try {
                this.filterExecutor.awaitTermination(5000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    public boolean isStopped() {
        return this.acceptor == null;
    }

    @Override
    public boolean isSuspended() {
        return this.suspended;
    }

    @Override
    public void resume() {
        if (this.acceptor != null && this.suspended) {
            try {
                this.acceptor.bind((SocketAddress)this.address);
            }
            catch (IOException e) {
                this.LOG.error("Failed to resume listener", (Throwable)e);
            }
        }
    }

    @Override
    public void suspend() {
        if (this.acceptor != null && !this.suspended) {
            this.acceptor.unbind((SocketAddress)this.address);
        }
    }

    public ExecutorService getFilterExecutor() {
        return this.filterExecutor;
    }

    public void setFilterExecutor(ExecutorService filterExecutor) {
        this.filterExecutor = filterExecutor;
    }

    public FtpHandler getHandler() {
        return this.handler;
    }

    public void setHandler(FtpHandler handler) {
        this.handler = handler;
        if (this.acceptor != null) {
            ((FtpHandlerAdapter)this.acceptor.getHandler()).setFtpHandler(handler);
        }
    }

    public List<InetAddress> getBlockedAddresses() {
        return this.blockedAddresses;
    }

    public synchronized void setBlockedAddresses(List<InetAddress> blockedAddresses) {
        this.blockedAddresses = blockedAddresses;
        this.updateBlacklistFilter();
    }

    public List<Subnet> getBlockedSubnets() {
        return this.blockedSubnets;
    }

    public synchronized void setBlockedSubnets(List<Subnet> blockedSubnets) {
        this.blockedSubnets = blockedSubnets;
        this.updateBlacklistFilter();
    }

    @Override
    public Set<FtpIoSession> getActiveSessions() {
        Set sessions = this.acceptor.getManagedSessions();
        HashSet<FtpIoSession> ftpSessions = new HashSet<FtpIoSession>();
        for (IoSession session : sessions) {
            ftpSessions.add(new FtpIoSession(session, this.context));
        }
        return ftpSessions;
    }
}

