/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.command;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.SocketException;
import org.apache.ftpserver.DefaultFtpReply;
import org.apache.ftpserver.IODataConnectionFactory;
import org.apache.ftpserver.ServerDataConnectionFactory;
import org.apache.ftpserver.command.AbstractCommand;
import org.apache.ftpserver.ftplet.DataConnection;
import org.apache.ftpserver.ftplet.DataType;
import org.apache.ftpserver.ftplet.FileObject;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.FtpRequest;
import org.apache.ftpserver.ftplet.FtpletContainer;
import org.apache.ftpserver.ftplet.FtpletEnum;
import org.apache.ftpserver.interfaces.FtpIoSession;
import org.apache.ftpserver.interfaces.FtpServerContext;
import org.apache.ftpserver.interfaces.ServerFtpStatistics;
import org.apache.ftpserver.util.FtpReplyUtil;
import org.apache.ftpserver.util.IoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RETR
extends AbstractCommand {
    private final Logger LOG = LoggerFactory.getLogger(RETR.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void execute(FtpIoSession session, FtpServerContext context, FtpRequest request) throws IOException, FtpException {
        block36: {
            try {
                InputStream is;
                boolean failure;
                FtpletEnum ftpletRet;
                FtpletContainer ftpletContainer;
                String fileName;
                block35: {
                    DataConnection dataConnection;
                    InetAddress address;
                    long skipLen = session.getFileOffset();
                    fileName = request.getArgument();
                    if (fileName == null) {
                        session.write(FtpReplyUtil.translate(session, request, context, 501, "RETR", null));
                        return;
                    }
                    ftpletContainer = context.getFtpletContainer();
                    try {
                        ftpletRet = ftpletContainer.onDownloadStart(session.getFtpletSession(), request);
                    }
                    catch (Exception e) {
                        this.LOG.debug("Ftplet container threw exception", (Throwable)e);
                        ftpletRet = FtpletEnum.RET_DISCONNECT;
                    }
                    if (ftpletRet == FtpletEnum.RET_SKIP) {
                        return;
                    }
                    if (ftpletRet == FtpletEnum.RET_DISCONNECT) {
                        session.closeOnFlush().awaitUninterruptibly(10000L);
                        return;
                    }
                    FileObject file = null;
                    try {
                        file = session.getFileSystemView().getFileObject(fileName);
                    }
                    catch (Exception ex) {
                        this.LOG.debug("Exception getting file object", (Throwable)ex);
                    }
                    if (file == null) {
                        session.write(FtpReplyUtil.translate(session, request, context, 550, "RETR.missing", fileName));
                        return;
                    }
                    fileName = file.getFullName();
                    if (!file.doesExist()) {
                        session.write(FtpReplyUtil.translate(session, request, context, 550, "RETR.missing", fileName));
                        return;
                    }
                    if (!file.isFile()) {
                        session.write(FtpReplyUtil.translate(session, request, context, 550, "RETR.invalid", fileName));
                        return;
                    }
                    if (!file.hasReadPermission()) {
                        session.write(FtpReplyUtil.translate(session, request, context, 550, "RETR.permission", fileName));
                        return;
                    }
                    ServerDataConnectionFactory connFactory = session.getDataConnection();
                    if (connFactory instanceof IODataConnectionFactory && (address = ((IODataConnectionFactory)connFactory).getInetAddress()) == null) {
                        session.write(new DefaultFtpReply(503, "PORT or PASV must be issued first"));
                        return;
                    }
                    session.write(FtpReplyUtil.translate(session, request, context, 150, "RETR", null));
                    failure = false;
                    is = null;
                    try {
                        dataConnection = session.getDataConnection().openConnection();
                    }
                    catch (Exception e) {
                        this.LOG.debug("Exception getting the output data stream", (Throwable)e);
                        session.write(FtpReplyUtil.translate(session, request, context, 425, "RETR", null));
                        session.resetState();
                        session.getDataConnection().closeDataConnection();
                        return;
                    }
                    try {
                        is = this.openInputStream(session, file, skipLen);
                        long transSz = dataConnection.transferToClient(is);
                        String userName = session.getUser().getName();
                        this.LOG.info("File download : " + userName + " - " + fileName);
                        ServerFtpStatistics ftpStat = (ServerFtpStatistics)context.getFtpStatistics();
                        if (ftpStat == null) break block35;
                        ftpStat.setDownload(session, file, transSz);
                    }
                    catch (SocketException ex) {
                        this.LOG.debug("Socket exception during data transfer", (Throwable)ex);
                        failure = true;
                        session.write(FtpReplyUtil.translate(session, request, context, 426, "RETR", fileName));
                        IoUtils.close(is);
                    }
                    catch (IOException ex2) {
                        this.LOG.debug("IOException during data transfer", (Throwable)ex2);
                        failure = true;
                        session.write(FtpReplyUtil.translate(session, request, context, 551, "RETR", fileName));
                        {
                            catch (Throwable throwable) {
                                IoUtils.close(is);
                                throw throwable;
                            }
                        }
                        IoUtils.close(is);
                    }
                }
                IoUtils.close(is);
                if (failure) break block36;
                session.write(FtpReplyUtil.translate(session, request, context, 226, "RETR", fileName));
                try {
                    ftpletRet = ftpletContainer.onDownloadEnd(session.getFtpletSession(), request);
                }
                catch (Exception e) {
                    this.LOG.debug("Ftplet container threw exception", (Throwable)e);
                    ftpletRet = FtpletEnum.RET_DISCONNECT;
                }
                if (ftpletRet == FtpletEnum.RET_DISCONNECT) {
                    session.closeOnFlush().awaitUninterruptibly(10000L);
                    return;
                }
            }
            finally {
                session.resetState();
                session.getDataConnection().closeDataConnection();
            }
        }
    }

    public InputStream openInputStream(FtpIoSession session, FileObject file, long skipLen) throws IOException {
        InputStream in;
        if (session.getDataType() == DataType.ASCII) {
            long offset = 0L;
            in = new BufferedInputStream(file.createInputStream(0L));
            while (offset++ < skipLen) {
                int c = in.read();
                if (c == -1) {
                    throw new IOException("Cannot skip");
                }
                if (c != 10) continue;
                ++offset;
            }
        } else {
            in = file.createInputStream(skipLen);
        }
        return in;
    }
}

