/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.command;

import java.io.IOException;
import org.apache.ftpserver.command.AbstractCommand;
import org.apache.ftpserver.ftplet.FileObject;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.FtpRequest;
import org.apache.ftpserver.interfaces.FtpIoSession;
import org.apache.ftpserver.interfaces.FtpServerContext;
import org.apache.ftpserver.listing.ListArgument;
import org.apache.ftpserver.listing.ListArgumentParser;
import org.apache.ftpserver.listing.MLSTFileFormater;
import org.apache.ftpserver.util.FtpReplyUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MLST
extends AbstractCommand {
    private final Logger LOG = LoggerFactory.getLogger(MLST.class);

    public void execute(FtpIoSession session, FtpServerContext context, FtpRequest request) throws IOException {
        session.resetState();
        ListArgument parsedArg = ListArgumentParser.parse(request.getArgument());
        FileObject file = null;
        try {
            file = session.getFileSystemView().getFileObject(parsedArg.getFile());
            if (file != null && file.doesExist()) {
                MLSTFileFormater formater = new MLSTFileFormater((String[])session.getAttribute("MLST.types"));
                session.write(FtpReplyUtil.translate(session, request, context, 250, "MLST", formater.format(file)));
            } else {
                session.write(FtpReplyUtil.translate(session, request, context, 501, "MLST", null));
            }
        }
        catch (FtpException ex) {
            this.LOG.debug("Exception sending the file listing", (Throwable)ex);
            session.write(FtpReplyUtil.translate(session, request, context, 501, "MLST", null));
        }
    }
}

