/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.command;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import org.apache.ftpserver.command.AbstractCommand;
import org.apache.ftpserver.ftplet.FtpRequest;
import org.apache.ftpserver.interfaces.DataConnectionConfig;
import org.apache.ftpserver.interfaces.FtpIoSession;
import org.apache.ftpserver.interfaces.FtpServerContext;
import org.apache.ftpserver.util.FtpReplyUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EPRT
extends AbstractCommand {
    private final Logger LOG = LoggerFactory.getLogger(EPRT.class);

    public void execute(FtpIoSession session, FtpServerContext context, FtpRequest request) throws IOException {
        InetAddress clientAddr;
        session.resetState();
        String arg = request.getArgument();
        if (arg == null) {
            session.write(FtpReplyUtil.translate(session, request, context, 501, "EPRT", null));
            return;
        }
        DataConnectionConfig dataCfg = session.getListener().getDataConnectionConfig();
        if (!dataCfg.isActiveEnabled()) {
            session.write(FtpReplyUtil.translate(session, request, context, 510, "EPRT.disabled", null));
            return;
        }
        String host = null;
        String port = null;
        try {
            char delim = arg.charAt(0);
            int lastDelimIdx = arg.indexOf(delim, 3);
            host = arg.substring(3, lastDelimIdx);
            port = arg.substring(lastDelimIdx + 1, arg.length() - 1);
        }
        catch (Exception ex) {
            this.LOG.debug("Exception parsing host and port: " + arg, (Throwable)ex);
            session.write(FtpReplyUtil.translate(session, request, context, 510, "EPRT", null));
            return;
        }
        InetAddress dataAddr = null;
        try {
            dataAddr = InetAddress.getByName(host);
        }
        catch (UnknownHostException ex) {
            this.LOG.debug("Unknown host: " + host, (Throwable)ex);
            session.write(FtpReplyUtil.translate(session, request, context, 553, "EPRT.host", null));
            return;
        }
        if (dataCfg.isActiveIpCheck() && session.getRemoteAddress() instanceof InetSocketAddress && !dataAddr.equals(clientAddr = ((InetSocketAddress)session.getRemoteAddress()).getAddress())) {
            session.write(FtpReplyUtil.translate(session, request, context, 510, "EPRT.mismatch", null));
            return;
        }
        int dataPort = 0;
        try {
            dataPort = Integer.parseInt(port);
        }
        catch (NumberFormatException ex) {
            this.LOG.debug("Invalid port: " + port, (Throwable)ex);
            session.write(FtpReplyUtil.translate(session, request, context, 552, "EPRT.invalid", null));
            return;
        }
        session.getDataConnection().initActiveDataConnection(new InetSocketAddress(dataAddr, dataPort));
        session.write(FtpReplyUtil.translate(session, request, context, 200, "EPRT", null));
    }
}

