/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.security.cert.Certificate;
import java.util.Date;
import org.apache.ftpserver.ftplet.DataConnectionFactory;
import org.apache.ftpserver.ftplet.DataType;
import org.apache.ftpserver.ftplet.FileObject;
import org.apache.ftpserver.ftplet.FileSystemView;
import org.apache.ftpserver.ftplet.FtpSession;
import org.apache.ftpserver.ftplet.Structure;
import org.apache.ftpserver.ftplet.User;
import org.apache.ftpserver.interfaces.FtpIoSession;

public class FtpSessionImpl
implements FtpSession {
    private FtpIoSession ioSession;

    public FtpSessionImpl(FtpIoSession ioSession) {
        this.ioSession = ioSession;
    }

    public boolean isLoggedIn() {
        return this.ioSession.isLoggedIn();
    }

    public DataConnectionFactory getDataConnection() {
        return this.ioSession.getDataConnection();
    }

    public FileSystemView getFileSystemView() {
        return this.ioSession.getFileSystemView();
    }

    public Date getConnectionTime() {
        return new Date(this.ioSession.getCreationTime());
    }

    public Date getLoginTime() {
        return this.ioSession.getLoginTime();
    }

    public Date getLastAccessTime() {
        return this.ioSession.getLastAccessTime();
    }

    public long getFileOffset() {
        return this.ioSession.getFileOffset();
    }

    public FileObject getRenameFrom() {
        return this.ioSession.getRenameFrom();
    }

    public String getUserArgument() {
        return this.ioSession.getUserArgument();
    }

    public String getLanguage() {
        return this.ioSession.getLanguage();
    }

    public User getUser() {
        return this.ioSession.getUser();
    }

    public InetAddress getClientAddress() {
        if (this.ioSession.getRemoteAddress() instanceof InetSocketAddress) {
            return ((InetSocketAddress)this.ioSession.getRemoteAddress()).getAddress();
        }
        return null;
    }

    public Object getAttribute(String name) {
        if (name.startsWith("org.apache.ftpserver.")) {
            throw new IllegalArgumentException("Illegal lookup of internal attribute");
        }
        return this.ioSession.getAttribute(name);
    }

    public void setAttribute(String name, Object value) {
        if (name.startsWith("org.apache.ftpserver.")) {
            throw new IllegalArgumentException("Illegal setting of internal attribute");
        }
        this.ioSession.setAttribute(name, value);
    }

    public int getMaxIdleTime() {
        return this.ioSession.getMaxIdleTime();
    }

    public void setMaxIdleTime(int maxIdleTime) {
        this.ioSession.setMaxIdleTime(maxIdleTime);
    }

    public DataType getDataType() {
        return this.ioSession.getDataType();
    }

    public Structure getStructure() {
        return this.ioSession.getStructure();
    }

    public Certificate[] getClientCertificates() {
        return this.ioSession.getClientCertificates();
    }

    public InetAddress getServerAddress() {
        if (this.ioSession.getLocalAddress() instanceof InetSocketAddress) {
            return ((InetSocketAddress)this.ioSession.getLocalAddress()).getAddress();
        }
        return null;
    }

    public int getServerPort() {
        if (this.ioSession.getLocalAddress() instanceof InetSocketAddress) {
            return ((InetSocketAddress)this.ioSession.getLocalAddress()).getPort();
        }
        return 0;
    }

    public int getFailedLogins() {
        return this.ioSession.getFailedLogins();
    }

    public void removeAttribute(String name) {
        if (name.startsWith("org.apache.ftpserver.")) {
            throw new IllegalArgumentException("Illegal removal of internal attribute");
        }
        this.ioSession.removeAttribute(name);
    }
}

