/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver;

import java.util.Map;
import org.apache.ftpserver.DefaultFtpServerContext;
import org.apache.ftpserver.interfaces.FtpServerContext;
import org.apache.ftpserver.listener.Listener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FtpServer {
    private final Logger LOG = LoggerFactory.getLogger(FtpServer.class);
    private FtpServerContext serverContext;
    private boolean suspended;
    private boolean started = false;

    public FtpServer() throws Exception {
        this.serverContext = new DefaultFtpServerContext();
    }

    public FtpServer(FtpServerContext serverContext) throws Exception {
        this.serverContext = serverContext;
    }

    public void start() throws Exception {
        Map<String, Listener> listeners = this.serverContext.getListeners();
        for (Listener listener : listeners.values()) {
            listener.start(this.serverContext);
        }
        this.started = true;
        this.LOG.info("FTP server started");
    }

    public void stop() {
        if (!this.started || this.serverContext == null) {
            return;
        }
        Map<String, Listener> listeners = this.serverContext.getListeners();
        for (Listener listener : listeners.values()) {
            listener.stop();
        }
        if (this.serverContext != null) {
            this.serverContext.dispose();
            this.serverContext = null;
        }
        this.started = false;
    }

    public boolean isStopped() {
        return !this.started;
    }

    public void suspend() {
        Map<String, Listener> listeners = this.serverContext.getListeners();
        for (Listener listener : listeners.values()) {
            listener.suspend();
        }
        this.suspended = true;
    }

    public void resume() {
        Map<String, Listener> listeners = this.serverContext.getListeners();
        for (Listener listener : listeners.values()) {
            listener.resume();
        }
        this.suspended = false;
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    public FtpServerContext getServerContext() {
        return this.serverContext;
    }

    public void setServerContext(FtpServerContext serverContext) {
        this.serverContext = serverContext;
    }
}

