/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.ftpserver.Bean;
import org.apache.ftpserver.ConnectionConfig;
import org.apache.ftpserver.DefaultCommandFactory;
import org.apache.ftpserver.DefaultConnectionConfig;
import org.apache.ftpserver.FtpStatisticsImpl;
import org.apache.ftpserver.filesystem.NativeFileSystemManager;
import org.apache.ftpserver.ftplet.Authority;
import org.apache.ftpserver.ftplet.Configuration;
import org.apache.ftpserver.ftplet.DefaultFtplet;
import org.apache.ftpserver.ftplet.DefaultFtpletContainer;
import org.apache.ftpserver.ftplet.FileSystemManager;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.FtpStatistics;
import org.apache.ftpserver.ftplet.Ftplet;
import org.apache.ftpserver.ftplet.FtpletContainer;
import org.apache.ftpserver.ftplet.FtpletContext;
import org.apache.ftpserver.ftplet.User;
import org.apache.ftpserver.ftplet.UserManager;
import org.apache.ftpserver.interfaces.CommandFactory;
import org.apache.ftpserver.interfaces.FtpServerContext;
import org.apache.ftpserver.interfaces.MessageResource;
import org.apache.ftpserver.listener.Listener;
import org.apache.ftpserver.listener.mina.MinaListener;
import org.apache.ftpserver.message.MessageResourceImpl;
import org.apache.ftpserver.usermanager.BaseUser;
import org.apache.ftpserver.usermanager.ConcurrentLoginPermission;
import org.apache.ftpserver.usermanager.PropertiesUserManager;
import org.apache.ftpserver.usermanager.TransferRatePermission;
import org.apache.ftpserver.usermanager.WritePermission;
import org.apache.ftpserver.util.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurableFtpServerContext
implements FtpServerContext {
    private final Logger LOG = LoggerFactory.getLogger(ConfigurableFtpServerContext.class);
    private Bean messageResourceBean;
    private Bean userManagerBean;
    private Bean fileSystemManagerBean;
    private Bean ftpletContainerBean;
    private Bean statisticsBean;
    private Bean commandFactoryBean;
    private Bean connectionConfigBean;
    private Map<String, Bean> listeners = new HashMap<String, Bean>();
    private static final Authority[] ADMIN_AUTHORITIES = new Authority[]{new WritePermission()};
    private static final Authority[] ANON_AUTHORITIES = new Authority[]{new ConcurrentLoginPermission(20, 2), new TransferRatePermission(4800, 4800)};

    public ConfigurableFtpServerContext(Configuration conf) throws Exception {
        try {
            this.listeners = this.createListeners(conf, "listeners");
            this.messageResourceBean = this.createComponent(conf, "message", MessageResourceImpl.class.getName());
            this.userManagerBean = this.createComponent(conf, "user-manager", PropertiesUserManager.class.getName());
            this.fileSystemManagerBean = this.createComponent(conf, "file-system-manager", NativeFileSystemManager.class.getName());
            this.statisticsBean = this.createComponent(conf, "statistics", FtpStatisticsImpl.class.getName());
            this.commandFactoryBean = this.createComponent(conf, "command-factory", DefaultCommandFactory.class.getName());
            this.connectionConfigBean = this.createComponent(conf, "connection-config", DefaultConnectionConfig.class.getName());
            boolean userCreate = conf.getBoolean("create-default-user", true);
            if (userCreate) {
                this.createDefaultUsers();
            }
            this.ftpletContainerBean = this.createComponent(conf, "ftplet-container", DefaultFtpletContainer.class.getName());
            this.initFtplets((FtpletContainer)this.ftpletContainerBean.getBean(), conf);
        }
        catch (Exception ex) {
            this.dispose();
            throw ex;
        }
    }

    private Map<String, Bean> createListeners(Configuration conf, String prefix) throws Exception {
        HashMap<String, Bean> map = new HashMap<String, Bean>();
        Configuration listenersConfig = conf.subset(prefix);
        if (listenersConfig.isEmpty()) {
            Bean listenerBean = this.createComponent(listenersConfig, "default", MinaListener.class.getName());
            map.put("default", listenerBean);
        } else {
            Iterator keys = listenersConfig.getKeys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                Bean listenerBean = this.createComponent(listenersConfig, key, MinaListener.class.getName());
                map.put(key, listenerBean);
            }
        }
        return map;
    }

    private void initFtplets(FtpletContainer container, Configuration conf) throws FtpException {
        String ftpletNames = conf.getString("ftplets", null);
        Configuration ftpletConf = conf.subset("ftplet");
        if (ftpletNames == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(ftpletNames, " ,;\r\n\t");
        try {
            while (st.hasMoreTokens()) {
                String ftpletName = st.nextToken();
                this.LOG.info("Configuring ftplet : " + ftpletName);
                Configuration subConfig = ftpletConf.subset(ftpletName);
                Ftplet ftplet = (Ftplet)ClassUtils.createBean(subConfig, DefaultFtplet.class.getName());
                ftplet.init((FtpletContext)this);
                container.addFtplet(ftpletName, ftplet);
            }
        }
        catch (FtpException ex) {
            container.destroy();
            throw ex;
        }
        catch (Exception ex) {
            container.destroy();
            this.LOG.error("FtpletContainer.init()", (Throwable)ex);
            throw new FtpException("FtpletContainer.init()", (Throwable)ex);
        }
    }

    private Bean createComponent(Configuration parentConfig, String configName, String defaultClass) throws Exception {
        Configuration conf = parentConfig.subset(configName);
        Bean bean = Bean.createBean(conf, defaultClass);
        bean.initBean();
        return bean;
    }

    private void createDefaultUsers() throws Exception {
        String adminName;
        UserManager userManager = this.getUserManager();
        if (!userManager.doesExist(adminName = userManager.getAdminName())) {
            this.LOG.info("Creating user : " + adminName);
            BaseUser adminUser = new BaseUser();
            adminUser.setName(adminName);
            adminUser.setPassword(adminName);
            adminUser.setEnabled(true);
            adminUser.setAuthorities(ADMIN_AUTHORITIES);
            adminUser.setHomeDirectory("./res/home");
            adminUser.setMaxIdleTime(0);
            userManager.save((User)adminUser);
        }
        if (!userManager.doesExist("anonymous")) {
            this.LOG.info("Creating user : anonymous");
            BaseUser anonUser = new BaseUser();
            anonUser.setName("anonymous");
            anonUser.setPassword("");
            anonUser.setAuthorities(ANON_AUTHORITIES);
            anonUser.setEnabled(true);
            anonUser.setHomeDirectory("./res/home");
            anonUser.setMaxIdleTime(300);
            userManager.save((User)anonUser);
        }
    }

    public UserManager getUserManager() {
        return (UserManager)this.userManagerBean.getBean();
    }

    public FileSystemManager getFileSystemManager() {
        return (FileSystemManager)this.fileSystemManagerBean.getBean();
    }

    @Override
    public MessageResource getMessageResource() {
        return (MessageResource)this.messageResourceBean.getBean();
    }

    public FtpStatistics getFtpStatistics() {
        return (FtpStatistics)this.statisticsBean.getBean();
    }

    @Override
    public FtpletContainer getFtpletContainer() {
        return (FtpletContainer)this.ftpletContainerBean.getBean();
    }

    @Override
    public CommandFactory getCommandFactory() {
        return (CommandFactory)this.commandFactoryBean.getBean();
    }

    public Ftplet getFtplet(String name) {
        return ((FtpletContainer)this.ftpletContainerBean.getBean()).getFtplet(name);
    }

    @Override
    public void dispose() {
        for (Bean listenerBean : this.listeners.values()) {
            listenerBean.destroyBean();
        }
        if (this.ftpletContainerBean != null && this.ftpletContainerBean.getBean() != null) {
            this.ftpletContainerBean.destroyBean();
        }
        if (this.userManagerBean != null && this.userManagerBean.getBean() != null) {
            this.userManagerBean.destroyBean();
        }
        if (this.fileSystemManagerBean != null && this.fileSystemManagerBean.getBean() != null) {
            this.fileSystemManagerBean.destroyBean();
        }
        if (this.statisticsBean != null && this.statisticsBean.getBean() != null) {
            this.statisticsBean.destroyBean();
        }
        if (this.messageResourceBean != null && this.messageResourceBean.getBean() != null) {
            this.messageResourceBean.destroyBean();
        }
    }

    @Override
    public Listener getListener(String name) {
        Bean listenerBean = this.listeners.get(name);
        if (listenerBean != null) {
            return (Listener)listenerBean.getBean();
        }
        return null;
    }

    @Override
    public ConnectionConfig getConnectionConfig() {
        return (ConnectionConfig)this.connectionConfigBean.getBean();
    }

    @Override
    public Map<String, Listener> getListeners() {
        HashMap<String, Listener> result = new HashMap<String, Listener>();
        for (Map.Entry<String, Bean> entry : this.listeners.entrySet()) {
            result.put(entry.getKey(), (Listener)entry.getValue().getBean());
        }
        return result;
    }
}

