/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.thrift.transport;

import com.facebook.thrift.transport.TServerTransport;
import com.facebook.thrift.transport.TSocket;
import com.facebook.thrift.transport.TTransportException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;

public class TServerSocket
extends TServerTransport {
    private ServerSocket serverSocket_ = null;
    private int port_ = 0;
    private int clientTimeout_ = 0;

    public TServerSocket(ServerSocket serverSocket) {
        this(serverSocket, 0);
    }

    public TServerSocket(ServerSocket serverSocket, int n) {
        this.serverSocket_ = serverSocket;
        this.clientTimeout_ = n;
    }

    public TServerSocket(int n) throws TTransportException {
        this(n, 0);
    }

    public TServerSocket(int n, int n2) throws TTransportException {
        this.port_ = n;
        this.clientTimeout_ = n2;
        try {
            this.serverSocket_ = new ServerSocket();
            this.serverSocket_.setReuseAddress(true);
            this.serverSocket_.bind(new InetSocketAddress(this.port_));
        }
        catch (IOException iOException) {
            this.serverSocket_ = null;
            throw new TTransportException("Could not create ServerSocket on port " + n + ".");
        }
    }

    @Override
    public void listen() throws TTransportException {
        if (this.serverSocket_ != null) {
            try {
                this.serverSocket_.setSoTimeout(0);
            }
            catch (SocketException socketException) {
                socketException.printStackTrace();
            }
        }
    }

    @Override
    protected TSocket acceptImpl() throws TTransportException {
        if (this.serverSocket_ == null) {
            throw new TTransportException(1, "No underlying server socket.");
        }
        try {
            Socket socket = this.serverSocket_.accept();
            TSocket tSocket = new TSocket(socket);
            tSocket.setTimeout(this.clientTimeout_);
            return tSocket;
        }
        catch (IOException iOException) {
            throw new TTransportException(iOException);
        }
    }

    @Override
    public void close() {
        if (this.serverSocket_ != null) {
            try {
                this.serverSocket_.close();
            }
            catch (IOException iOException) {
                System.err.println("WARNING: Could not close server socket: " + iOException.getMessage());
            }
            this.serverSocket_ = null;
        }
    }

    @Override
    public void interrupt() {
        this.close();
    }
}

