/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.thrift.transport;

import com.facebook.thrift.transport.TTransport;
import com.facebook.thrift.transport.TTransportException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class THttpClient
extends TTransport {
    private URL url_ = null;
    private final ByteArrayOutputStream requestBuffer_ = new ByteArrayOutputStream();
    private InputStream inputStream_ = null;
    private int connectTimeout_ = 0;
    private int readTimeout_ = 0;
    private Map<String, String> customHeaders_ = null;

    public THttpClient(String string) throws TTransportException {
        try {
            this.url_ = new URL(string);
        }
        catch (IOException iOException) {
            throw new TTransportException(iOException);
        }
    }

    public void setConnectTimeout(int n) {
        this.connectTimeout_ = n;
    }

    public void setReadTimeout(int n) {
        this.readTimeout_ = n;
    }

    public void setCustomHeaders(Map<String, String> map) {
        this.customHeaders_ = map;
    }

    public void setCustomHeader(String string, String string2) {
        if (this.customHeaders_ == null) {
            this.customHeaders_ = new HashMap<String, String>();
        }
        this.customHeaders_.put(string, string2);
    }

    @Override
    public void open() {
    }

    @Override
    public void close() {
        if (null != this.inputStream_) {
            try {
                this.inputStream_.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.inputStream_ = null;
        }
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws TTransportException {
        if (this.inputStream_ == null) {
            throw new TTransportException("Response buffer is empty, no request.");
        }
        try {
            int n3 = this.inputStream_.read(byArray, n, n2);
            if (n3 == -1) {
                throw new TTransportException("No more data available.");
            }
            return n3;
        }
        catch (IOException iOException) {
            throw new TTransportException(iOException);
        }
    }

    @Override
    public void write(byte[] byArray, int n, int n2) {
        this.requestBuffer_.write(byArray, n, n2);
    }

    @Override
    public void flush() throws TTransportException {
        byte[] byArray = this.requestBuffer_.toByteArray();
        this.requestBuffer_.reset();
        try {
            HttpURLConnection httpURLConnection = (HttpURLConnection)this.url_.openConnection();
            if (this.connectTimeout_ > 0) {
                httpURLConnection.setConnectTimeout(this.connectTimeout_);
            }
            if (this.readTimeout_ > 0) {
                httpURLConnection.setReadTimeout(this.readTimeout_);
            }
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setRequestProperty("Content-Type", "application/x-thrift");
            httpURLConnection.setRequestProperty("Accept", "application/x-thrift");
            httpURLConnection.setRequestProperty("User-Agent", "Java/THttpClient");
            if (this.customHeaders_ != null) {
                for (Map.Entry<String, String> entry : this.customHeaders_.entrySet()) {
                    httpURLConnection.setRequestProperty(entry.getKey(), entry.getValue());
                }
            }
            httpURLConnection.setDoOutput(true);
            httpURLConnection.connect();
            httpURLConnection.getOutputStream().write(byArray);
            int n = httpURLConnection.getResponseCode();
            if (n != 200) {
                throw new TTransportException("HTTP Response code: " + n);
            }
            this.inputStream_ = httpURLConnection.getInputStream();
        }
        catch (IOException iOException) {
            throw new TTransportException(iOException);
        }
    }
}

