/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.thrift.server;

import com.facebook.thrift.TException;
import com.facebook.thrift.TProcessor;
import com.facebook.thrift.TProcessorFactory;
import com.facebook.thrift.protocol.TBinaryProtocol;
import com.facebook.thrift.protocol.TProtocol;
import com.facebook.thrift.protocol.TProtocolFactory;
import com.facebook.thrift.server.TServer;
import com.facebook.thrift.transport.TServerTransport;
import com.facebook.thrift.transport.TTransport;
import com.facebook.thrift.transport.TTransportException;
import com.facebook.thrift.transport.TTransportFactory;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class TThreadPoolServer
extends TServer {
    private ExecutorService executorService_;
    private volatile boolean stopped_;
    private Options options_;

    public TThreadPoolServer(TProcessor tProcessor, TServerTransport tServerTransport) {
        this(tProcessor, tServerTransport, new TTransportFactory(), new TTransportFactory(), (TProtocolFactory)new TBinaryProtocol.Factory(), (TProtocolFactory)new TBinaryProtocol.Factory());
    }

    public TThreadPoolServer(TProcessorFactory tProcessorFactory, TServerTransport tServerTransport) {
        this(tProcessorFactory, tServerTransport, new TTransportFactory(), new TTransportFactory(), (TProtocolFactory)new TBinaryProtocol.Factory(), (TProtocolFactory)new TBinaryProtocol.Factory());
    }

    public TThreadPoolServer(TProcessor tProcessor, TServerTransport tServerTransport, TProtocolFactory tProtocolFactory) {
        this(tProcessor, tServerTransport, new TTransportFactory(), new TTransportFactory(), tProtocolFactory, tProtocolFactory);
    }

    public TThreadPoolServer(TProcessor tProcessor, TServerTransport tServerTransport, TTransportFactory tTransportFactory, TProtocolFactory tProtocolFactory) {
        this(tProcessor, tServerTransport, tTransportFactory, tTransportFactory, tProtocolFactory, tProtocolFactory);
    }

    public TThreadPoolServer(TProcessorFactory tProcessorFactory, TServerTransport tServerTransport, TTransportFactory tTransportFactory, TProtocolFactory tProtocolFactory) {
        this(tProcessorFactory, tServerTransport, tTransportFactory, tTransportFactory, tProtocolFactory, tProtocolFactory);
    }

    public TThreadPoolServer(TProcessor tProcessor, TServerTransport tServerTransport, TTransportFactory tTransportFactory, TTransportFactory tTransportFactory2, TProtocolFactory tProtocolFactory, TProtocolFactory tProtocolFactory2) {
        this(new TProcessorFactory(tProcessor), tServerTransport, tTransportFactory, tTransportFactory2, tProtocolFactory, tProtocolFactory2);
    }

    public TThreadPoolServer(TProcessorFactory tProcessorFactory, TServerTransport tServerTransport, TTransportFactory tTransportFactory, TTransportFactory tTransportFactory2, TProtocolFactory tProtocolFactory, TProtocolFactory tProtocolFactory2) {
        super(tProcessorFactory, tServerTransport, tTransportFactory, tTransportFactory2, tProtocolFactory, tProtocolFactory2);
        this.options_ = new Options();
        this.executorService_ = Executors.newCachedThreadPool();
    }

    public TThreadPoolServer(TProcessor tProcessor, TServerTransport tServerTransport, TTransportFactory tTransportFactory, TTransportFactory tTransportFactory2, TProtocolFactory tProtocolFactory, TProtocolFactory tProtocolFactory2, Options options) {
        this(new TProcessorFactory(tProcessor), tServerTransport, tTransportFactory, tTransportFactory2, tProtocolFactory, tProtocolFactory2, options);
    }

    public TThreadPoolServer(TProcessorFactory tProcessorFactory, TServerTransport tServerTransport, TTransportFactory tTransportFactory, TTransportFactory tTransportFactory2, TProtocolFactory tProtocolFactory, TProtocolFactory tProtocolFactory2, Options options) {
        super(tProcessorFactory, tServerTransport, tTransportFactory, tTransportFactory2, tProtocolFactory, tProtocolFactory2);
        this.executorService_ = null;
        SynchronousQueue<Runnable> synchronousQueue = new SynchronousQueue<Runnable>();
        this.executorService_ = new ThreadPoolExecutor(options.minWorkerThreads, options.maxWorkerThreads, 60L, TimeUnit.SECONDS, synchronousQueue);
        this.options_ = options;
    }

    @Override
    public void serve() {
        try {
            this.serverTransport_.listen();
        }
        catch (TTransportException tTransportException) {
            tTransportException.printStackTrace();
            return;
        }
        this.stopped_ = false;
        while (!this.stopped_) {
            int n = 0;
            try {
                TTransport tTransport = this.serverTransport_.accept();
                WorkerProcess workerProcess = new WorkerProcess(tTransport);
                this.executorService_.execute(workerProcess);
            }
            catch (TTransportException tTransportException) {
                if (this.stopped_) continue;
                ++n;
                tTransportException.printStackTrace();
            }
        }
        this.executorService_.shutdown();
        try {
            this.executorService_.awaitTermination(this.options_.stopTimeoutVal, this.options_.stopTimeoutUnit);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void stop() {
        this.stopped_ = true;
        this.serverTransport_.interrupt();
    }

    private class WorkerProcess
    implements Runnable {
        private TTransport client_;

        private WorkerProcess(TTransport tTransport) {
            this.client_ = tTransport;
        }

        @Override
        public void run() {
            TProcessor tProcessor = null;
            TTransport tTransport = null;
            TTransport tTransport2 = null;
            TProtocol tProtocol = null;
            TProtocol tProtocol2 = null;
            try {
                tProcessor = TThreadPoolServer.this.processorFactory_.getProcessor(this.client_);
                tTransport = TThreadPoolServer.this.inputTransportFactory_.getTransport(this.client_);
                tTransport2 = TThreadPoolServer.this.outputTransportFactory_.getTransport(this.client_);
                tProtocol = TThreadPoolServer.this.inputProtocolFactory_.getProtocol(tTransport);
                tProtocol2 = TThreadPoolServer.this.outputProtocolFactory_.getProtocol(tTransport2);
                while (tProcessor.process(tProtocol, tProtocol2)) {
                }
            }
            catch (TTransportException tTransportException) {
            }
            catch (TException tException) {
                tException.printStackTrace();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (tTransport != null) {
                tTransport.close();
            }
            if (tTransport2 != null) {
                tTransport2.close();
            }
        }
    }

    public static class Options {
        public int minWorkerThreads = 5;
        public int maxWorkerThreads = Integer.MAX_VALUE;
        public int stopTimeoutVal = 60;
        public TimeUnit stopTimeoutUnit = TimeUnit.SECONDS;
    }
}

