/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.thrift.protocol;

import com.facebook.thrift.TException;
import com.facebook.thrift.protocol.TField;
import com.facebook.thrift.protocol.TList;
import com.facebook.thrift.protocol.TMap;
import com.facebook.thrift.protocol.TProtocol;
import com.facebook.thrift.protocol.TSet;

public class TProtocolUtil {
    private static int maxSkipDepth = Integer.MAX_VALUE;

    public static void setMaxSkipDepth(int n) {
        maxSkipDepth = n;
    }

    public static void skip(TProtocol tProtocol, byte by) throws TException {
        TProtocolUtil.skip(tProtocol, by, maxSkipDepth);
    }

    public static void skip(TProtocol tProtocol, byte by, int n) throws TException {
        if (n <= 0) {
            throw new TException("Maximum skip depth exceeded");
        }
        switch (by) {
            case 2: {
                tProtocol.readBool();
                break;
            }
            case 3: {
                tProtocol.readByte();
                break;
            }
            case 6: {
                tProtocol.readI16();
                break;
            }
            case 8: {
                tProtocol.readI32();
                break;
            }
            case 10: {
                tProtocol.readI64();
                break;
            }
            case 4: {
                tProtocol.readDouble();
                break;
            }
            case 11: {
                tProtocol.readBinary();
                break;
            }
            case 12: {
                tProtocol.readStructBegin();
                while (true) {
                    TField tField = tProtocol.readFieldBegin();
                    if (tField.type == 0) break;
                    TProtocolUtil.skip(tProtocol, tField.type, n - 1);
                    tProtocol.readFieldEnd();
                }
                tProtocol.readStructEnd();
                break;
            }
            case 13: {
                TMap tMap = tProtocol.readMapBegin();
                for (int i = 0; i < tMap.size; ++i) {
                    TProtocolUtil.skip(tProtocol, tMap.keyType, n - 1);
                    TProtocolUtil.skip(tProtocol, tMap.valueType, n - 1);
                }
                tProtocol.readMapEnd();
                break;
            }
            case 14: {
                TSet tSet = tProtocol.readSetBegin();
                for (int i = 0; i < tSet.size; ++i) {
                    TProtocolUtil.skip(tProtocol, tSet.elemType, n - 1);
                }
                tProtocol.readSetEnd();
                break;
            }
            case 15: {
                TList tList = tProtocol.readListBegin();
                for (int i = 0; i < tList.size; ++i) {
                    TProtocolUtil.skip(tProtocol, tList.elemType, n - 1);
                }
                tProtocol.readListEnd();
                break;
            }
        }
    }
}

