/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.config;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import org.apache.ftpserver.ftplet.Configuration;
import org.apache.ftpserver.ftplet.FtpException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesConfiguration
implements Configuration {
    protected Properties prop;
    protected String prefix = "config.";

    protected PropertiesConfiguration() {
    }

    public PropertiesConfiguration(InputStream in) throws IOException {
        this.prop = new Properties();
        this.prop.load(in);
    }

    public PropertiesConfiguration(Properties prop) {
        this.prop = (Properties)prop.clone();
    }

    public boolean isEmpty() {
        boolean empty = true;
        Enumeration<?> keys = this.prop.propertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (!key.startsWith(this.prefix)) continue;
            empty = false;
            break;
        }
        return empty;
    }

    public String getString(String param) throws FtpException {
        String val = this.prop.getProperty(this.prefix + param);
        if (val == null) {
            throw new FtpException("Not found : " + param);
        }
        return val;
    }

    public String getString(String param, String defaultVal) {
        return this.prop.getProperty(this.prefix + param, defaultVal);
    }

    public int getInt(String param) throws FtpException {
        String val = this.prop.getProperty(this.prefix + param);
        if (val == null) {
            throw new FtpException("Not found : " + param);
        }
        try {
            return Integer.parseInt(val);
        }
        catch (Exception ex) {
            throw new FtpException("PropertiesConfiguration.getInt()", (Throwable)ex);
        }
    }

    public int getInt(String param, int defaultVal) {
        int retVal = defaultVal;
        try {
            retVal = this.getInt(param);
        }
        catch (Exception ex) {
            // empty catch block
        }
        return retVal;
    }

    public long getLong(String param) throws FtpException {
        String val = this.prop.getProperty(this.prefix + param);
        if (val == null) {
            throw new FtpException("Not found : " + param);
        }
        try {
            return Long.parseLong(val);
        }
        catch (Exception ex) {
            throw new FtpException("PropertiesConfiguration.getLong()", (Throwable)ex);
        }
    }

    public long getLong(String param, long defaultVal) {
        long retVal = defaultVal;
        try {
            retVal = this.getLong(param);
        }
        catch (Exception ex) {
            // empty catch block
        }
        return retVal;
    }

    public boolean getBoolean(String param) throws FtpException {
        String val = this.prop.getProperty(this.prefix + param);
        if (val == null) {
            throw new FtpException("Not found : " + param);
        }
        return val.equalsIgnoreCase("true");
    }

    public boolean getBoolean(String param, boolean defaultVal) {
        boolean retVal = defaultVal;
        try {
            retVal = this.getBoolean(param);
        }
        catch (Exception ex) {
            // empty catch block
        }
        return retVal;
    }

    public double getDouble(String param) throws FtpException {
        String val = this.prop.getProperty(this.prefix + param);
        if (val == null) {
            throw new FtpException("Not found : " + param);
        }
        try {
            return Double.parseDouble(val);
        }
        catch (Exception ex) {
            throw new FtpException("PropertiesConfiguration.getDouble()", (Throwable)ex);
        }
    }

    public double getDouble(String param, double defaultVal) {
        double retVal = defaultVal;
        try {
            retVal = this.getDouble(param);
        }
        catch (Exception ex) {
            // empty catch block
        }
        return retVal;
    }

    public Configuration subset(String param) {
        PropertiesConfiguration subConfig = new PropertiesConfiguration();
        subConfig.prop = this.prop;
        subConfig.prefix = this.prefix + param + '.';
        return subConfig;
    }

    public Iterator<String> getKeys() {
        ArrayList<String> arr = new ArrayList<String>();
        Enumeration<Object> en = this.prop.keys();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            if (!key.startsWith(this.prefix)) continue;
            int indexOfNextDot = (key = key.substring(this.prefix.length())).indexOf(46);
            if (indexOfNextDot > -1) {
                key = key.substring(0, indexOfNextDot);
            }
            if (arr.contains(key)) continue;
            arr.add(key);
        }
        return arr.iterator();
    }
}

