/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.commandline;

import java.io.FileInputStream;
import org.apache.ftpserver.ConfigurableFtpServerContext;
import org.apache.ftpserver.FtpServer;
import org.apache.ftpserver.config.PropertiesConfiguration;
import org.apache.ftpserver.config.XmlConfigurationHandler;
import org.apache.ftpserver.ftplet.Configuration;
import org.apache.ftpserver.ftplet.EmptyConfiguration;
import org.apache.ftpserver.interfaces.FtpServerContext;
import org.apache.ftpserver.util.IoUtils;

public class CommandLine {
    private CommandLine() {
    }

    public static void main(String[] args) {
        try {
            Configuration config = CommandLine.getConfiguration(args);
            if (config == null) {
                return;
            }
            ConfigurableFtpServerContext serverContext = new ConfigurableFtpServerContext(config);
            FtpServer server = new FtpServer((FtpServerContext)serverContext);
            server.start();
            CommandLine.addShutdownHook(server);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void addShutdownHook(final FtpServer engine) {
        Runnable shutdownHook = new Runnable(){

            public void run() {
                System.out.println("Stopping server...");
                engine.stop();
            }
        };
        Runtime runtime = Runtime.getRuntime();
        runtime.addShutdownHook(new Thread(shutdownHook));
    }

    private static void usage() {
        System.err.println("Usage: java org.apache.ftpserver.commandline.CommandLine [<options>]");
        System.err.println("  <options> := -default |");
        System.err.println("               -xml <XML configuration file> |");
        System.err.println("               -prop <properties configuration file>");
        System.out.println();
        System.out.println("There are three ways to start the FTP server.");
        System.out.println("    -default :: default configuration will be used.");
        System.out.println("    -xml     :: XML configuration will be used. User has to specify the file.");
        System.out.println("    -prop    :: properties configuration will be used. User has to specify the file.");
        System.out.println();
        System.out.println("In case of no option, default configuration will be used.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Configuration getConfiguration(String[] args) throws Exception {
        Object config = null;
        FileInputStream in = null;
        try {
            if (args.length == 0) {
                System.out.println("Using default configuration....");
                config = EmptyConfiguration.INSTANCE;
            } else if (args.length == 1 && args[0].equals("-default")) {
                System.out.println("Using default configuration....");
                config = EmptyConfiguration.INSTANCE;
            } else if (args.length == 2 && args[0].equals("-xml")) {
                System.out.println("Using xml configuration file " + args[1] + "...");
                in = new FileInputStream(args[1]);
                XmlConfigurationHandler xmlHandler = new XmlConfigurationHandler(in);
                config = xmlHandler.parse();
            } else if (args.length == 2 && args[0].equals("-prop")) {
                System.out.println("Using properties configuration file " + args[1] + "...");
                in = new FileInputStream(args[1]);
                config = new PropertiesConfiguration(in);
            }
        }
        finally {
            IoUtils.close(in);
        }
        if (config == null) {
            CommandLine.usage();
        }
        return config;
    }
}

