/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.transport.socket;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.mina.common.ExceptionMonitor;
import org.apache.mina.transport.socket.AbstractSocketSessionConfig;
import org.apache.mina.transport.socket.SocketAcceptor;
import org.apache.mina.transport.socket.SocketService;

public class DefaultSocketSessionConfig
extends AbstractSocketSessionConfig {
    private static Map<InetSocketAddress, InetAddress> TEST_ADDRESSES;
    private static boolean SET_RECEIVE_BUFFER_SIZE_AVAILABLE;
    private static boolean SET_SEND_BUFFER_SIZE_AVAILABLE;
    private static boolean GET_TRAFFIC_CLASS_AVAILABLE;
    private static boolean SET_TRAFFIC_CLASS_AVAILABLE;
    private static boolean DEFAULT_REUSE_ADDRESS;
    private static int DEFAULT_RECEIVE_BUFFER_SIZE;
    private static int DEFAULT_SEND_BUFFER_SIZE;
    private static int DEFAULT_TRAFFIC_CLASS;
    private static boolean DEFAULT_KEEP_ALIVE;
    private static boolean DEFAULT_OOB_INLINE;
    private static int DEFAULT_SO_LINGER;
    private static boolean DEFAULT_TCP_NO_DELAY;
    private SocketService parent;
    private boolean defaultReuseAddress;
    private int defaultReceiveBufferSize;
    private boolean reuseAddress;
    private int receiveBufferSize;
    private int sendBufferSize;
    private int trafficClass;
    private boolean keepAlive;
    private boolean oobInline;
    private int soLinger;
    private boolean tcpNoDelay;

    private static void initializeFallbackDefaultSocketParameters() {
        Socket unconnectedSocket = new Socket();
        try {
            DefaultSocketSessionConfig.initializeDefaultSocketParameters(unconnectedSocket);
        }
        catch (SocketException se) {
            ExceptionMonitor.getInstance().exceptionCaught(se);
            try {
                unconnectedSocket.close();
            }
            catch (IOException ioe) {
                ExceptionMonitor.getInstance().exceptionCaught(ioe);
            }
        }
    }

    private static void initializeTestAddresses() {
        try {
            TEST_ADDRESSES.put(new InetSocketAddress(InetAddress.getByAddress(new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1}), 0), InetAddress.getByAddress(new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1}));
            TEST_ADDRESSES.put(new InetSocketAddress(InetAddress.getByAddress(new byte[]{127, 0, 0, 1}), 0), InetAddress.getByAddress(new byte[]{127, 0, 0, 1}));
            TEST_ADDRESSES.put(new InetSocketAddress(0), InetAddress.getByAddress(new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1}));
            TEST_ADDRESSES.put(new InetSocketAddress(0), InetAddress.getByAddress(new byte[]{127, 0, 0, 1}));
        }
        catch (UnknownHostException e) {
            ExceptionMonitor.getInstance().exceptionCaught(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean initializeDefaultSocketParameters(InetSocketAddress bindAddress, InetAddress connectAddress) {
        ServerSocket ss = null;
        Socket socket = null;
        try {
            ss = new ServerSocket();
            ss.bind(bindAddress);
            socket = new Socket();
            socket.connect(new InetSocketAddress(connectAddress, ss.getLocalPort()), 10000);
            DefaultSocketSessionConfig.initializeDefaultSocketParameters(socket);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException e) {
                    ExceptionMonitor.getInstance().exceptionCaught(e);
                }
            }
            if (ss != null) {
                try {
                    ss.close();
                }
                catch (IOException e) {
                    ExceptionMonitor.getInstance().exceptionCaught(e);
                }
            }
        }
    }

    private static void initializeDefaultSocketParameters(Socket socket) throws SocketException {
        DEFAULT_REUSE_ADDRESS = socket.getReuseAddress();
        DEFAULT_RECEIVE_BUFFER_SIZE = socket.getReceiveBufferSize();
        DEFAULT_SEND_BUFFER_SIZE = socket.getSendBufferSize();
        DEFAULT_KEEP_ALIVE = socket.getKeepAlive();
        DEFAULT_OOB_INLINE = socket.getOOBInline();
        DEFAULT_SO_LINGER = socket.getSoLinger();
        DEFAULT_TCP_NO_DELAY = socket.getTcpNoDelay();
        try {
            socket.setReceiveBufferSize(DEFAULT_RECEIVE_BUFFER_SIZE);
            SET_RECEIVE_BUFFER_SIZE_AVAILABLE = true;
        }
        catch (SocketException e) {
            SET_RECEIVE_BUFFER_SIZE_AVAILABLE = false;
        }
        try {
            socket.setSendBufferSize(DEFAULT_SEND_BUFFER_SIZE);
            SET_SEND_BUFFER_SIZE_AVAILABLE = true;
        }
        catch (SocketException e) {
            SET_SEND_BUFFER_SIZE_AVAILABLE = false;
        }
        try {
            DEFAULT_TRAFFIC_CLASS = socket.getTrafficClass();
            GET_TRAFFIC_CLASS_AVAILABLE = true;
        }
        catch (SocketException e) {
            GET_TRAFFIC_CLASS_AVAILABLE = false;
            DEFAULT_TRAFFIC_CLASS = 0;
        }
    }

    public static boolean isSetReceiveBufferSizeAvailable() {
        return SET_RECEIVE_BUFFER_SIZE_AVAILABLE;
    }

    public static boolean isSetSendBufferSizeAvailable() {
        return SET_SEND_BUFFER_SIZE_AVAILABLE;
    }

    public static boolean isGetTrafficClassAvailable() {
        return GET_TRAFFIC_CLASS_AVAILABLE;
    }

    public static boolean isSetTrafficClassAvailable() {
        return SET_TRAFFIC_CLASS_AVAILABLE;
    }

    public DefaultSocketSessionConfig() {
        this.receiveBufferSize = this.defaultReceiveBufferSize = DEFAULT_RECEIVE_BUFFER_SIZE;
        this.sendBufferSize = DEFAULT_SEND_BUFFER_SIZE;
        this.trafficClass = DEFAULT_TRAFFIC_CLASS;
        this.keepAlive = DEFAULT_KEEP_ALIVE;
        this.oobInline = DEFAULT_OOB_INLINE;
        this.soLinger = DEFAULT_SO_LINGER;
        this.tcpNoDelay = DEFAULT_TCP_NO_DELAY;
    }

    public void init(SocketService parent) {
        this.parent = parent;
        this.defaultReuseAddress = parent instanceof SocketAcceptor ? true : DEFAULT_REUSE_ADDRESS;
        this.reuseAddress = this.defaultReuseAddress;
    }

    public boolean isReuseAddress() {
        return this.reuseAddress;
    }

    public void setReuseAddress(boolean reuseAddress) {
        this.reuseAddress = reuseAddress;
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public void setReceiveBufferSize(int receiveBufferSize) {
        this.receiveBufferSize = receiveBufferSize;
        if (!this.parent.isActive() && this.parent instanceof SocketAcceptor) {
            this.defaultReceiveBufferSize = receiveBufferSize;
        }
    }

    public int getSendBufferSize() {
        return this.sendBufferSize;
    }

    public void setSendBufferSize(int sendBufferSize) {
        this.sendBufferSize = sendBufferSize;
    }

    public int getTrafficClass() {
        return this.trafficClass;
    }

    public void setTrafficClass(int trafficClass) {
        this.trafficClass = trafficClass;
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    public boolean isOobInline() {
        return this.oobInline;
    }

    public void setOobInline(boolean oobInline) {
        this.oobInline = oobInline;
    }

    public int getSoLinger() {
        return this.soLinger;
    }

    public void setSoLinger(int soLinger) {
        this.soLinger = soLinger;
    }

    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
    }

    protected boolean isKeepAliveChanged() {
        return this.keepAlive != DEFAULT_KEEP_ALIVE;
    }

    protected boolean isOobInlineChanged() {
        return this.oobInline != DEFAULT_OOB_INLINE;
    }

    protected boolean isReceiveBufferSizeChanged() {
        return this.receiveBufferSize != this.defaultReceiveBufferSize;
    }

    protected boolean isReuseAddressChanged() {
        return this.reuseAddress != this.defaultReuseAddress;
    }

    protected boolean isSendBufferSizeChanged() {
        return this.sendBufferSize != DEFAULT_SEND_BUFFER_SIZE;
    }

    protected boolean isSoLingerChanged() {
        return this.soLinger != DEFAULT_SO_LINGER;
    }

    protected boolean isTcpNoDelayChanged() {
        return this.tcpNoDelay != DEFAULT_TCP_NO_DELAY;
    }

    protected boolean isTrafficClassChanged() {
        return this.trafficClass != DEFAULT_TRAFFIC_CLASS;
    }

    static {
        Map.Entry<InetSocketAddress, InetAddress> e;
        TEST_ADDRESSES = new LinkedHashMap<InetSocketAddress, InetAddress>();
        SET_RECEIVE_BUFFER_SIZE_AVAILABLE = false;
        SET_SEND_BUFFER_SIZE_AVAILABLE = false;
        GET_TRAFFIC_CLASS_AVAILABLE = false;
        SET_TRAFFIC_CLASS_AVAILABLE = false;
        DEFAULT_REUSE_ADDRESS = false;
        DEFAULT_RECEIVE_BUFFER_SIZE = 1024;
        DEFAULT_SEND_BUFFER_SIZE = 1024;
        DEFAULT_TRAFFIC_CLASS = 0;
        DEFAULT_KEEP_ALIVE = false;
        DEFAULT_OOB_INLINE = false;
        DEFAULT_SO_LINGER = -1;
        DEFAULT_TCP_NO_DELAY = false;
        DefaultSocketSessionConfig.initializeTestAddresses();
        boolean success = false;
        Iterator<Map.Entry<InetSocketAddress, InetAddress>> i$ = TEST_ADDRESSES.entrySet().iterator();
        while (i$.hasNext() && !(success = DefaultSocketSessionConfig.initializeDefaultSocketParameters((e = i$.next()).getKey(), e.getValue()))) {
        }
        if (!success) {
            DefaultSocketSessionConfig.initializeFallbackDefaultSocketParameters();
        }
    }
}

