/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.filter.traffic;

import java.util.ArrayList;
import java.util.Set;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoFilterAdapter;
import org.apache.mina.common.IoFilterChain;
import org.apache.mina.common.IoService;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.WriteException;
import org.apache.mina.common.WriteRequest;
import org.apache.mina.filter.traffic.WriteFloodException;
import org.apache.mina.filter.traffic.WriteThrottlePolicy;
import org.apache.mina.util.CopyOnWriteMap;
import org.apache.mina.util.MapBackedSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriteThrottleFilter
extends IoFilterAdapter {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final Set<IoService> activeServices = new MapBackedSet(new CopyOnWriteMap());
    private final Object logLock = new Object();
    private final Object blockLock = new Object();
    private long lastLogTime = 0L;
    private int blockWaiters = 0;
    private volatile WriteThrottlePolicy policy;
    private volatile int maxSessionScheduledWriteMessages;
    private volatile long maxSessionScheduledWriteBytes;
    private volatile int maxServiceScheduledWriteMessages;
    private volatile long maxServiceScheduledWriteBytes;
    private volatile int maxGlobalScheduledWriteMessages;
    private volatile long maxGlobalScheduledWriteBytes;

    public static int getGlobalScheduledWriteMessages() {
        int answer = 0;
        ArrayList<IoService> inactiveServices = null;
        for (IoService s : activeServices) {
            if (s.isActive()) {
                answer += s.getScheduledWriteMessages();
                continue;
            }
            if (inactiveServices == null) {
                inactiveServices = new ArrayList<IoService>();
            }
            inactiveServices.add(s);
        }
        if (inactiveServices != null) {
            activeServices.removeAll(inactiveServices);
        }
        return answer;
    }

    public static long getGlobalScheduledWriteBytes() {
        long answer = 0L;
        ArrayList<IoService> inactiveServices = null;
        for (IoService s : activeServices) {
            if (s.isActive()) {
                answer += (long)s.getScheduledWriteBytes();
                continue;
            }
            if (inactiveServices == null) {
                inactiveServices = new ArrayList<IoService>();
            }
            inactiveServices.add(s);
        }
        if (inactiveServices != null) {
            activeServices.removeAll(inactiveServices);
        }
        return answer;
    }

    private static int getGlobalScheduledWriteMessages(IoService service) {
        if (!activeServices.contains(service)) {
            activeServices.add(service);
        }
        return WriteThrottleFilter.getGlobalScheduledWriteMessages();
    }

    private static long getGlobalScheduledWriteBytes(IoService service) {
        if (!activeServices.contains(service)) {
            activeServices.add(service);
        }
        return WriteThrottleFilter.getGlobalScheduledWriteBytes();
    }

    public WriteThrottleFilter() {
        this(WriteThrottlePolicy.LOG);
    }

    public WriteThrottleFilter(WriteThrottlePolicy policy) {
        this(policy, 4096, 65536L, 131072, 0x4000000L, 262144, 131657728L);
    }

    public WriteThrottleFilter(int maxSessionScheduledWriteMessages, long maxSessionScheduledWriteBytes, int maxServiceScheduledWriteMessages, long maxServiceScheduledWriteBytes, int maxGlobalScheduledWriteMessages, long maxGlobalScheduledWriteBytes) {
        this(WriteThrottlePolicy.LOG, maxSessionScheduledWriteMessages, maxSessionScheduledWriteBytes, maxServiceScheduledWriteMessages, maxServiceScheduledWriteBytes, maxGlobalScheduledWriteMessages, maxGlobalScheduledWriteBytes);
    }

    public WriteThrottleFilter(WriteThrottlePolicy policy, int maxSessionScheduledWriteMessages, long maxSessionScheduledWriteBytes, int maxServiceScheduledWriteMessages, long maxServiceScheduledWriteBytes, int maxGlobalScheduledWriteMessages, long maxGlobalScheduledWriteBytes) {
        this.setPolicy(policy);
        this.setMaxSessionScheduledWriteMessages(maxSessionScheduledWriteMessages);
        this.setMaxSessionScheduledWriteBytes(maxSessionScheduledWriteBytes);
        this.setMaxServiceScheduledWriteMessages(maxServiceScheduledWriteMessages);
        this.setMaxServiceScheduledWriteBytes(maxServiceScheduledWriteBytes);
        this.setMaxGlobalScheduledWriteMessages(maxGlobalScheduledWriteMessages);
        this.setMaxGlobalScheduledWriteBytes(maxGlobalScheduledWriteBytes);
    }

    public WriteThrottlePolicy getPolicy() {
        return this.policy;
    }

    public void setPolicy(WriteThrottlePolicy policy) {
        if (policy == null) {
            throw new NullPointerException("policy");
        }
        this.policy = policy;
    }

    public int getMaxSessionScheduledWriteMessages() {
        return this.maxSessionScheduledWriteMessages;
    }

    public void setMaxSessionScheduledWriteMessages(int maxSessionScheduledWriteMessages) {
        if (maxSessionScheduledWriteMessages < 0) {
            maxSessionScheduledWriteMessages = 0;
        }
        this.maxSessionScheduledWriteMessages = maxSessionScheduledWriteMessages;
    }

    public long getMaxSessionScheduledWriteBytes() {
        return this.maxSessionScheduledWriteBytes;
    }

    public void setMaxSessionScheduledWriteBytes(long maxSessionScheduledWriteBytes) {
        if (maxSessionScheduledWriteBytes < 0L) {
            maxSessionScheduledWriteBytes = 0L;
        }
        this.maxSessionScheduledWriteBytes = maxSessionScheduledWriteBytes;
    }

    public int getMaxServiceScheduledWriteMessages() {
        return this.maxServiceScheduledWriteMessages;
    }

    public void setMaxServiceScheduledWriteMessages(int maxServiceScheduledWriteMessages) {
        if (maxServiceScheduledWriteMessages < 0) {
            maxServiceScheduledWriteMessages = 0;
        }
        this.maxServiceScheduledWriteMessages = maxServiceScheduledWriteMessages;
    }

    public long getMaxServiceScheduledWriteBytes() {
        return this.maxServiceScheduledWriteBytes;
    }

    public void setMaxServiceScheduledWriteBytes(long maxServiceScheduledWriteBytes) {
        if (maxServiceScheduledWriteBytes < 0L) {
            maxServiceScheduledWriteBytes = 0L;
        }
        this.maxServiceScheduledWriteBytes = maxServiceScheduledWriteBytes;
    }

    public int getMaxGlobalScheduledWriteMessages() {
        return this.maxGlobalScheduledWriteMessages;
    }

    public void setMaxGlobalScheduledWriteMessages(int maxGlobalScheduledWriteMessages) {
        if (maxGlobalScheduledWriteMessages < 0) {
            maxGlobalScheduledWriteMessages = 0;
        }
        this.maxGlobalScheduledWriteMessages = maxGlobalScheduledWriteMessages;
    }

    public long getMaxGlobalScheduledWriteBytes() {
        return this.maxGlobalScheduledWriteBytes;
    }

    public void setMaxGlobalScheduledWriteBytes(long maxGlobalScheduledWriteBytes) {
        if (maxGlobalScheduledWriteBytes < 0L) {
            maxGlobalScheduledWriteBytes = 0L;
        }
        this.maxGlobalScheduledWriteBytes = maxGlobalScheduledWriteBytes;
    }

    public void onPreAdd(IoFilterChain parent, String name, IoFilter.NextFilter nextFilter) throws Exception {
        if (parent.contains(WriteThrottleFilter.class)) {
            throw new IllegalStateException("Only one " + WriteThrottleFilter.class.getName() + " is allowed per chain.");
        }
    }

    public void filterWrite(IoFilter.NextFilter nextFilter, IoSession session, WriteRequest writeRequest) throws Exception {
        WriteThrottlePolicy policy = this.getPolicy();
        if (policy != WriteThrottlePolicy.OFF && !this.readyToWrite(session)) {
            switch (policy) {
                case FAIL: {
                    this.log(session);
                    this.fail(session, writeRequest);
                    break;
                }
                case BLOCK: {
                    this.log(session);
                    this.block(session);
                    break;
                }
                case LOG: {
                    this.log(session);
                }
            }
        }
        nextFilter.filterWrite(session, writeRequest);
    }

    private boolean readyToWrite(IoSession session) {
        if (session.isClosing()) {
            return true;
        }
        int mSession = this.maxSessionScheduledWriteMessages;
        long bSession = this.maxSessionScheduledWriteBytes;
        int mService = this.maxServiceScheduledWriteMessages;
        long bService = this.maxServiceScheduledWriteBytes;
        int mGlobal = this.maxGlobalScheduledWriteMessages;
        long bGlobal = this.maxGlobalScheduledWriteBytes;
        return !(mSession != 0 && session.getScheduledWriteMessages() >= mSession || bSession != 0L && session.getScheduledWriteBytes() >= bSession || mService != 0 && session.getService().getScheduledWriteMessages() >= mService || bService != 0L && (long)session.getService().getScheduledWriteBytes() >= bService || mGlobal != 0 && WriteThrottleFilter.getGlobalScheduledWriteMessages(session.getService()) >= mGlobal || bGlobal != 0L && WriteThrottleFilter.getGlobalScheduledWriteBytes(session.getService()) >= bGlobal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void log(IoSession session) {
        boolean log;
        long currentTime = System.currentTimeMillis();
        Object object = this.logLock;
        synchronized (object) {
            if (currentTime - this.lastLogTime > 3000L) {
                this.lastLogTime = currentTime;
                log = true;
            } else {
                log = false;
            }
        }
        if (log) {
            this.logger.warn(this.getMessage(session));
        }
    }

    public void messageSent(IoFilter.NextFilter nextFilter, IoSession session, WriteRequest writeRequest) throws Exception {
        this.notifyWaitingWriters();
        nextFilter.messageSent(session, writeRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exceptionCaught(IoFilter.NextFilter nextFilter, IoSession session, Throwable cause) throws Exception {
        try {
            nextFilter.exceptionCaught(session, cause);
        }
        finally {
            this.notifyWaitingWriters();
        }
    }

    public void sessionClosed(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
        this.notifyWaitingWriters();
        nextFilter.sessionClosed(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void block(IoSession session) {
        Object object = this.blockLock;
        synchronized (object) {
            ++this.blockWaiters;
            while (!this.readyToWrite(session)) {
                try {
                    this.blockLock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            --this.blockWaiters;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyWaitingWriters() {
        Object object = this.blockLock;
        synchronized (object) {
            if (this.blockWaiters != 0) {
                this.blockLock.notifyAll();
            }
        }
    }

    private void fail(IoSession session, WriteRequest writeRequest) throws WriteException {
        throw new WriteFloodException(writeRequest, this.getMessage(session));
    }

    private String getMessage(IoSession session) {
        int mSession = this.maxSessionScheduledWriteMessages;
        long bSession = this.maxSessionScheduledWriteBytes;
        int mService = this.maxServiceScheduledWriteMessages;
        long bService = this.maxServiceScheduledWriteBytes;
        int mGlobal = this.maxGlobalScheduledWriteMessages;
        long bGlobal = this.maxGlobalScheduledWriteBytes;
        StringBuilder buf = new StringBuilder(512);
        buf.append("Write requests flooded - session: ");
        if (mSession != 0) {
            buf.append(session.getScheduledWriteMessages());
            buf.append(" / ");
            buf.append(mSession);
            buf.append(" msgs, ");
        } else {
            buf.append(session.getScheduledWriteMessages());
            buf.append(" / unlimited msgs, ");
        }
        if (bSession != 0L) {
            buf.append(session.getScheduledWriteBytes());
            buf.append(" / ");
            buf.append(bSession);
            buf.append(" bytes, ");
        } else {
            buf.append(session.getScheduledWriteBytes());
            buf.append(" / unlimited bytes, ");
        }
        buf.append("service: ");
        if (mService != 0) {
            buf.append(session.getService().getScheduledWriteMessages());
            buf.append(" / ");
            buf.append(mService);
            buf.append(" msgs, ");
        } else {
            buf.append(session.getService().getScheduledWriteMessages());
            buf.append(" / unlimited msgs, ");
        }
        if (bService != 0L) {
            buf.append(session.getService().getScheduledWriteBytes());
            buf.append(" / ");
            buf.append(bService);
            buf.append(" bytes, ");
        } else {
            buf.append(session.getService().getScheduledWriteBytes());
            buf.append(" / unlimited bytes, ");
        }
        buf.append("global: ");
        if (mGlobal != 0) {
            buf.append(WriteThrottleFilter.getGlobalScheduledWriteMessages());
            buf.append(" / ");
            buf.append(mGlobal);
            buf.append(" msgs, ");
        } else {
            buf.append(WriteThrottleFilter.getGlobalScheduledWriteMessages());
            buf.append(" / unlimited msgs, ");
        }
        if (bGlobal != 0L) {
            buf.append(WriteThrottleFilter.getGlobalScheduledWriteBytes());
            buf.append(" / ");
            buf.append(bGlobal);
            buf.append(" bytes.");
        } else {
            buf.append(WriteThrottleFilter.getGlobalScheduledWriteBytes());
            buf.append(" / unlimited bytes.");
        }
        return buf.toString();
    }
}

