/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.filter.traffic;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.mina.common.AttributeKey;
import org.apache.mina.common.IoBuffer;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoFilterAdapter;
import org.apache.mina.common.IoFilterChain;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.TrafficMask;
import org.apache.mina.common.WriteRequest;
import org.apache.mina.filter.traffic.DefaultMessageSizeEstimator;
import org.apache.mina.filter.traffic.MessageSizeEstimator;

public class TrafficShapingFilter
extends IoFilterAdapter {
    private final AttributeKey STATE = new AttributeKey(this.getClass(), "state");
    private final ScheduledExecutorService scheduledExecutor;
    private final MessageSizeEstimator messageSizeEstimator;
    private volatile int maxReadThroughput;
    private volatile int maxWriteThroughput;

    public TrafficShapingFilter(ScheduledExecutorService scheduledExecutor, int maxReadThroughput, int maxWriteThroughput) {
        this(scheduledExecutor, null, maxReadThroughput, maxWriteThroughput);
    }

    public TrafficShapingFilter(ScheduledExecutorService scheduledExecutor, MessageSizeEstimator messageSizeEstimator, int maxReadThroughput, int maxWriteThroughput) {
        if (scheduledExecutor == null) {
            throw new NullPointerException("scheduledExecutor");
        }
        if (messageSizeEstimator == null) {
            messageSizeEstimator = new DefaultMessageSizeEstimator(){

                public int estimateSize(Object message) {
                    if (message instanceof IoBuffer) {
                        return ((IoBuffer)message).remaining();
                    }
                    return super.estimateSize(message);
                }
            };
        }
        this.scheduledExecutor = scheduledExecutor;
        this.messageSizeEstimator = messageSizeEstimator;
        this.setMaxReadThroughput(maxReadThroughput);
        this.setMaxWriteThroughput(maxWriteThroughput);
    }

    public ScheduledExecutorService getScheduledExecutor() {
        return this.scheduledExecutor;
    }

    public MessageSizeEstimator getMessageSizeEstimator() {
        return this.messageSizeEstimator;
    }

    public int getMaxReadThroughput() {
        return this.maxReadThroughput;
    }

    public void setMaxReadThroughput(int maxReadThroughput) {
        if (maxReadThroughput < 0) {
            maxReadThroughput = 0;
        }
        this.maxReadThroughput = maxReadThroughput;
    }

    public int getMaxWriteThroughput() {
        return this.maxWriteThroughput;
    }

    public void setMaxWriteThroughput(int maxWriteThroughput) {
        if (maxWriteThroughput < 0) {
            maxWriteThroughput = 0;
        }
        this.maxWriteThroughput = maxWriteThroughput;
    }

    public void onPreAdd(IoFilterChain parent, String name, IoFilter.NextFilter nextFilter) throws Exception {
        if (parent.contains(this)) {
            throw new IllegalArgumentException("You can't add the same filter instance more than once.  Create another instance and add it.");
        }
        parent.getSession().setAttribute(this.STATE, new State());
        this.adjustReadBufferSize(parent.getSession());
    }

    public void onPostRemove(IoFilterChain parent, String name, IoFilter.NextFilter nextFilter) throws Exception {
        parent.getSession().removeAttribute(this.STATE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageReceived(IoFilter.NextFilter nextFilter, final IoSession session, Object message) throws Exception {
        int maxReadThroughput = this.maxReadThroughput;
        if (maxReadThroughput == 0) {
            nextFilter.messageReceived(session, message);
        }
        final State state = (State)session.getAttribute(this.STATE);
        long currentTime = System.currentTimeMillis();
        long suspendTime = 0L;
        boolean firstRead = false;
        State state2 = state;
        synchronized (state2) {
            state.readBytes += this.messageSizeEstimator.estimateSize(message);
            if (!state.suspendedRead) {
                long throughput;
                if (state.readStartTime == 0L) {
                    firstRead = true;
                    state.readStartTime = currentTime - 1000L;
                }
                if ((throughput = state.readBytes * 1000L / (currentTime - state.readStartTime)) >= (long)maxReadThroughput) {
                    suspendTime = Math.max(0L, state.readBytes * 1000L / (long)maxReadThroughput - (firstRead ? 0L : currentTime - state.readStartTime));
                    state.readBytes = 0L;
                    state.readStartTime = 0L;
                    state.suspendedRead = suspendTime != 0L;
                    this.adjustReadBufferSize(session);
                }
            }
        }
        if (suspendTime != 0L) {
            session.suspendRead();
            this.scheduledExecutor.schedule(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    State state2 = state;
                    synchronized (state2) {
                        state.suspendedRead = false;
                    }
                    session.resumeRead();
                }
            }, suspendTime, TimeUnit.MILLISECONDS);
        }
        nextFilter.messageReceived(session, message);
    }

    private void adjustReadBufferSize(IoSession session) {
        int maxReadThroughput = this.maxReadThroughput;
        if (maxReadThroughput == 0) {
            return;
        }
        if (session.getConfig().getReadBufferSize() > maxReadThroughput) {
            session.getConfig().setReadBufferSize(maxReadThroughput);
        }
        if (session.getConfig().getMaxReadBufferSize() > maxReadThroughput) {
            session.getConfig().setMaxReadBufferSize(maxReadThroughput);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageSent(IoFilter.NextFilter nextFilter, final IoSession session, WriteRequest writeRequest) throws Exception {
        int maxWriteThroughput = this.maxWriteThroughput;
        if (maxWriteThroughput == 0) {
            nextFilter.messageSent(session, writeRequest);
        }
        final State state = (State)session.getAttribute(this.STATE);
        long currentTime = System.currentTimeMillis();
        long suspendTime = 0L;
        boolean firstWrite = false;
        State state2 = state;
        synchronized (state2) {
            state.writtenBytes += this.messageSizeEstimator.estimateSize(writeRequest.getMessage());
            if (!state.suspendedWrite) {
                long throughput;
                if (state.writeStartTime == 0L) {
                    firstWrite = true;
                    state.writeStartTime = currentTime - 1000L;
                }
                if ((throughput = state.writtenBytes * 1000L / (currentTime - state.writeStartTime)) >= (long)maxWriteThroughput) {
                    suspendTime = Math.max(0L, state.writtenBytes * 1000L / (long)maxWriteThroughput - (firstWrite ? 0L : currentTime - state.writeStartTime));
                    state.writtenBytes = 0L;
                    state.writeStartTime = 0L;
                    state.suspendedWrite = suspendTime != 0L;
                }
            }
        }
        if (suspendTime != 0L) {
            session.suspendWrite();
            this.scheduledExecutor.schedule(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    State state2 = state;
                    synchronized (state2) {
                        state.suspendedWrite = false;
                    }
                    session.resumeWrite();
                }
            }, suspendTime, TimeUnit.MILLISECONDS);
        }
        nextFilter.messageSent(session, writeRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filterSetTrafficMask(IoFilter.NextFilter nextFilter, IoSession session, TrafficMask trafficMask) throws Exception {
        boolean suspendedWrite;
        boolean suspendedRead;
        State state;
        State state2 = state = (State)session.getAttribute(this.STATE);
        synchronized (state2) {
            suspendedRead = state.suspendedRead;
            suspendedWrite = state.suspendedWrite;
        }
        if (suspendedRead) {
            trafficMask = trafficMask.and(TrafficMask.WRITE);
        }
        if (suspendedWrite) {
            trafficMask = trafficMask.and(TrafficMask.READ);
        }
        nextFilter.filterSetTrafficMask(session, trafficMask);
    }

    private static class State {
        private long readStartTime;
        private long writeStartTime;
        private boolean suspendedRead;
        private boolean suspendedWrite;
        private long readBytes;
        private long writtenBytes;

        private State() {
        }
    }
}

