/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.filter.traffic;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.mina.common.AttributeKey;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoFilterAdapter;
import org.apache.mina.common.IoFilterChain;
import org.apache.mina.common.IoService;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.TrafficMask;
import org.apache.mina.filter.executor.ExecutorFilter;
import org.apache.mina.filter.traffic.DefaultMessageSizeEstimator;
import org.apache.mina.filter.traffic.MessageSizeEstimator;
import org.apache.mina.filter.traffic.ReadFloodException;
import org.apache.mina.filter.traffic.ReadThrottlePolicy;
import org.apache.mina.util.CopyOnWriteMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadThrottleFilter
extends IoFilterAdapter {
    private static final AtomicInteger globalBufferSize = new AtomicInteger();
    private static final Map<IoService, AtomicInteger> serviceBufferSizes = new CopyOnWriteMap<IoService, AtomicInteger>();
    private static final Object globalResumeLock = new Object();
    private static long lastGlobalResumeTime = 0L;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final AttributeKey STATE = new AttributeKey(ReadThrottleFilter.class, "state");
    private volatile ReadThrottlePolicy policy;
    private final MessageSizeEstimator messageSizeEstimator;
    private volatile int maxSessionBufferSize;
    private volatile int maxServiceBufferSize;
    private volatile int maxGlobalBufferSize;
    private final IoFilter enterFilter = new EnterFilter();
    private final ScheduledExecutorService executor;
    private ScheduledFuture<?> resumeOthersFuture;
    private final AtomicInteger sessionCount = new AtomicInteger();
    private final Runnable resumeOthersTask = new Runnable(){

        public void run() {
            ReadThrottleFilter.this.resumeOthers();
        }
    };

    public static int getGlobalBufferSize() {
        return globalBufferSize.get();
    }

    public static int getServiceBufferSize(IoService service) {
        AtomicInteger answer = serviceBufferSizes.get(service);
        if (answer == null) {
            return 0;
        }
        return answer.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int increaseServiceBufferSize(IoService service, int increment) {
        AtomicInteger serviceBufferSize = serviceBufferSizes.get(service);
        if (serviceBufferSize == null) {
            Map<IoService, AtomicInteger> map = serviceBufferSizes;
            synchronized (map) {
                serviceBufferSize = serviceBufferSizes.get(service);
                if (serviceBufferSize == null) {
                    serviceBufferSize = new AtomicInteger(increment);
                    serviceBufferSizes.put(service, serviceBufferSize);
                    return increment;
                }
            }
        }
        return serviceBufferSize.addAndGet(increment);
    }

    public ReadThrottleFilter(ScheduledExecutorService executor) {
        this(executor, ReadThrottlePolicy.LOG);
    }

    public ReadThrottleFilter(ScheduledExecutorService executor, ReadThrottlePolicy policy) {
        this(executor, policy, null);
    }

    public ReadThrottleFilter(ScheduledExecutorService executor, ReadThrottlePolicy policy, MessageSizeEstimator messageSizeEstimator) {
        this(executor, policy, messageSizeEstimator, 65536, 0x4000000, 0x8000000);
    }

    public ReadThrottleFilter(ScheduledExecutorService executor, int maxSessionBufferSize, int maxServiceBufferSize, int maxGlobalBufferSize) {
        this(executor, ReadThrottlePolicy.LOG, maxSessionBufferSize, maxServiceBufferSize, maxGlobalBufferSize);
    }

    public ReadThrottleFilter(ScheduledExecutorService executor, ReadThrottlePolicy policy, int maxSessionBufferSize, int maxServiceBufferSize, int maxGlobalBufferSize) {
        this(executor, policy, null, maxSessionBufferSize, maxServiceBufferSize, maxGlobalBufferSize);
    }

    public ReadThrottleFilter(ScheduledExecutorService executor, ReadThrottlePolicy policy, MessageSizeEstimator messageSizeEstimator, int maxSessionBufferSize, int maxServiceBufferSize, int maxGlobalBufferSize) {
        if (messageSizeEstimator == null) {
            messageSizeEstimator = new DefaultMessageSizeEstimator();
        }
        this.executor = executor;
        this.messageSizeEstimator = messageSizeEstimator;
        this.setPolicy(policy);
        this.setMaxSessionBufferSize(maxSessionBufferSize);
        this.setMaxServiceBufferSize(maxServiceBufferSize);
        this.setMaxGlobalBufferSize(maxGlobalBufferSize);
    }

    public ReadThrottlePolicy getPolicy() {
        return this.policy;
    }

    public void setPolicy(ReadThrottlePolicy policy) {
        if (policy == null) {
            throw new NullPointerException("policy");
        }
        this.policy = policy;
    }

    public int getMaxSessionBufferSize() {
        return this.maxSessionBufferSize;
    }

    public int getMaxServiceBufferSize() {
        return this.maxServiceBufferSize;
    }

    public int getMaxGlobalBufferSize() {
        return this.maxGlobalBufferSize;
    }

    public void setMaxSessionBufferSize(int maxSessionBufferSize) {
        if (maxSessionBufferSize < 0) {
            maxSessionBufferSize = 0;
        }
        this.maxSessionBufferSize = maxSessionBufferSize;
    }

    public void setMaxServiceBufferSize(int maxServiceBufferSize) {
        if (maxServiceBufferSize < 0) {
            maxServiceBufferSize = 0;
        }
        this.maxServiceBufferSize = maxServiceBufferSize;
    }

    public void setMaxGlobalBufferSize(int maxGlobalBufferSize) {
        if (maxGlobalBufferSize < 0) {
            maxGlobalBufferSize = 0;
        }
        this.maxGlobalBufferSize = maxGlobalBufferSize;
    }

    public MessageSizeEstimator getMessageSizeEstimator() {
        return this.messageSizeEstimator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSessionBufferSize(IoSession session) {
        State state = (State)session.getAttribute(this.STATE);
        if (state == null) {
            return 0;
        }
        State state2 = state;
        synchronized (state2) {
            return state.sessionBufferSize;
        }
    }

    public void onPreAdd(IoFilterChain parent, String name, IoFilter.NextFilter nextFilter) throws Exception {
        if (!parent.contains(ExecutorFilter.class)) {
            throw new IllegalStateException("At least one " + ExecutorFilter.class.getName() + " must exist in the chain.");
        }
        if (parent.contains(this)) {
            throw new IllegalArgumentException("You can't add the same filter instance more than once.  Create another instance and add it.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPostAdd(IoFilterChain parent, String name, IoFilter.NextFilter nextFilter) throws Exception {
        IoFilter lastFilter = null;
        for (IoFilterChain.Entry e : parent.getAll()) {
            IoFilter currentFilter = e.getFilter();
            if (currentFilter == this) {
                if (lastFilter instanceof ExecutorFilter) break;
                throw new IllegalStateException(ReadThrottleFilter.class.getName() + " must be placed after " + "an " + ExecutorFilter.class.getName() + " in the chain");
            }
            lastFilter = currentFilter;
        }
        parent.getEntry(lastFilter).addBefore(name + ".preprocessor", this.enterFilter);
        int previousSessionCount = this.sessionCount.getAndIncrement();
        if (previousSessionCount == 0) {
            Runnable runnable = this.resumeOthersTask;
            synchronized (runnable) {
                this.resumeOthersFuture = this.executor.scheduleWithFixedDelay(this.resumeOthersTask, 3000L, 3000L, TimeUnit.MILLISECONDS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPostRemove(IoFilterChain parent, String name, IoFilter.NextFilter nextFilter) throws Exception {
        try {
            parent.remove(this.enterFilter);
        }
        catch (Exception e) {
            // empty catch block
        }
        int currentSessionCount = this.sessionCount.decrementAndGet();
        if (currentSessionCount == 0) {
            Runnable runnable = this.resumeOthersTask;
            synchronized (runnable) {
                this.resumeOthersFuture.cancel(false);
                this.resumeOthersFuture = null;
            }
        }
    }

    public void messageReceived(IoFilter.NextFilter nextFilter, IoSession session, Object message) throws Exception {
        this.exit(session, this.estimateSize(message));
        nextFilter.messageReceived(session, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filterSetTrafficMask(IoFilter.NextFilter nextFilter, IoSession session, TrafficMask trafficMask) throws Exception {
        if (trafficMask.isReadable()) {
            boolean suspendedRead;
            State state;
            State state2 = state = this.getState(session);
            synchronized (state2) {
                suspendedRead = state.suspendedRead;
            }
            if (suspendedRead) {
                trafficMask = trafficMask.and(TrafficMask.WRITE);
            }
        }
        nextFilter.filterSetTrafficMask(session, trafficMask);
    }

    private int estimateSize(Object message) {
        int size = this.messageSizeEstimator.estimateSize(message);
        if (size < 0) {
            throw new IllegalStateException(MessageSizeEstimator.class.getSimpleName() + " returned " + "a negative value (" + size + "): " + message);
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enter(IoSession session, int size) {
        State state = this.getState(session);
        int globalBufferSize = ReadThrottleFilter.globalBufferSize.addAndGet(size);
        int serviceBufferSize = ReadThrottleFilter.increaseServiceBufferSize(session.getService(), size);
        int maxGlobalBufferSize = this.maxGlobalBufferSize;
        int maxServiceBufferSize = this.maxServiceBufferSize;
        int maxSessionBufferSize = this.maxSessionBufferSize;
        ReadThrottlePolicy policy = this.getPolicy();
        boolean enforcePolicy = false;
        State state2 = state;
        synchronized (state2) {
            int sessionBufferSize = state.sessionBufferSize += size;
            if (maxSessionBufferSize != 0 && sessionBufferSize >= maxSessionBufferSize || maxServiceBufferSize != 0 && serviceBufferSize >= maxServiceBufferSize || maxGlobalBufferSize != 0 && globalBufferSize >= maxGlobalBufferSize) {
                enforcePolicy = true;
                switch (policy) {
                    case EXCEPTION: 
                    case BLOCK: {
                        state.suspendedRead = true;
                    }
                }
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(this.getMessage(session, "  Entered - "));
        }
        if (enforcePolicy) {
            switch (policy) {
                case CLOSE: {
                    this.log(session, state);
                    session.close();
                    this.raiseException(session);
                    break;
                }
                case EXCEPTION: {
                    this.suspend(session, state, this.logger);
                    this.raiseException(session);
                    break;
                }
                case BLOCK: {
                    this.suspend(session, state, this.logger);
                    break;
                }
                case LOG: {
                    this.log(session, state);
                }
            }
        }
    }

    private void suspend(IoSession session, State state, Logger logger) {
        this.log(session, state);
        session.suspendRead();
        if (logger.isDebugEnabled()) {
            logger.debug(this.getMessage(session, "Suspended - "));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exit(IoSession session, int size) {
        State state = this.getState(session);
        int globalBufferSize = ReadThrottleFilter.globalBufferSize.addAndGet(-size);
        if (globalBufferSize < 0) {
            throw new IllegalStateException("globalBufferSize: " + globalBufferSize);
        }
        int serviceBufferSize = ReadThrottleFilter.increaseServiceBufferSize(session.getService(), -size);
        if (serviceBufferSize < 0) {
            throw new IllegalStateException("serviceBufferSize: " + serviceBufferSize);
        }
        int maxGlobalBufferSize = this.maxGlobalBufferSize;
        int maxServiceBufferSize = this.maxServiceBufferSize;
        int maxSessionBufferSize = this.maxSessionBufferSize;
        boolean enforcePolicy = false;
        State state2 = state;
        synchronized (state2) {
            int sessionBufferSize = state.sessionBufferSize -= size;
            if (sessionBufferSize < 0) {
                throw new IllegalStateException("sessionBufferSize: " + sessionBufferSize);
            }
            if (!(maxGlobalBufferSize != 0 && globalBufferSize >= maxGlobalBufferSize || maxServiceBufferSize != 0 && serviceBufferSize >= maxServiceBufferSize || maxSessionBufferSize != 0 && sessionBufferSize >= maxSessionBufferSize)) {
                state.suspendedRead = false;
                enforcePolicy = true;
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(this.getMessage(session, "   Exited - "));
        }
        if (enforcePolicy) {
            session.resumeRead();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(this.getMessage(session, "  Resumed - "));
            }
        }
        this.resumeOthers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resumeOthers() {
        int maxGlobalBufferSize;
        boolean resumeOthers;
        long currentTime = System.currentTimeMillis();
        Object object = globalResumeLock;
        synchronized (object) {
            if (currentTime - lastGlobalResumeTime > 1000L) {
                lastGlobalResumeTime = currentTime;
                resumeOthers = true;
            } else {
                resumeOthers = false;
            }
        }
        if (resumeOthers && ((maxGlobalBufferSize = this.maxGlobalBufferSize) == 0 || globalBufferSize.get() < maxGlobalBufferSize)) {
            ArrayList<IoService> inactiveServices = null;
            for (IoService service : serviceBufferSizes.keySet()) {
                this.resumeService(service);
                if (!service.isActive()) {
                    if (inactiveServices == null) {
                        inactiveServices = new ArrayList<IoService>();
                    }
                    inactiveServices.add(service);
                }
                if (inactiveServices != null) {
                    for (IoService s : inactiveServices) {
                        serviceBufferSizes.remove(s);
                    }
                }
                Object object2 = globalResumeLock;
                synchronized (object2) {
                    lastGlobalResumeTime = System.currentTimeMillis();
                }
            }
        }
    }

    private void resumeService(IoService service) {
        int maxServiceBufferSize = this.maxServiceBufferSize;
        if (maxServiceBufferSize == 0 || ReadThrottleFilter.getServiceBufferSize(service) < maxServiceBufferSize) {
            for (IoSession session : service.getManagedSessions()) {
                this.resume(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resume(IoSession session) {
        State state = (State)session.getAttribute(this.STATE);
        if (state == null) {
            return;
        }
        int maxSessionBufferSize = this.maxSessionBufferSize;
        boolean resume = false;
        State state2 = state;
        synchronized (state2) {
            if (maxSessionBufferSize == 0 || state.sessionBufferSize < maxSessionBufferSize) {
                state.suspendedRead = false;
                resume = true;
            }
        }
        if (resume) {
            session.resumeRead();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(this.getMessage(session, "  Resumed - "));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void log(IoSession session, State state) {
        boolean log;
        long currentTime = System.currentTimeMillis();
        Object object = state.logLock;
        synchronized (object) {
            if (currentTime - state.lastLogTime > 3000L) {
                state.lastLogTime = currentTime;
                log = true;
            } else {
                log = false;
            }
        }
        if (log) {
            this.logger.warn(this.getMessage(session));
        }
    }

    private void raiseException(IoSession session) {
        throw new ReadFloodException(this.getMessage(session));
    }

    private String getMessage(IoSession session) {
        return this.getMessage(session, "Read buffer flooded - ");
    }

    private String getMessage(IoSession session, String prefix) {
        int sessionLimit = this.maxSessionBufferSize;
        int serviceLimit = this.maxServiceBufferSize;
        int globalLimit = this.maxGlobalBufferSize;
        StringBuilder buf = new StringBuilder(512);
        buf.append(prefix);
        buf.append("session: ");
        if (sessionLimit != 0) {
            buf.append(this.getSessionBufferSize(session));
            buf.append(" / ");
            buf.append(sessionLimit);
            buf.append(" bytes, ");
        } else {
            buf.append(this.getSessionBufferSize(session));
            buf.append(" / unlimited bytes, ");
        }
        buf.append("service: ");
        if (serviceLimit != 0) {
            buf.append(ReadThrottleFilter.getServiceBufferSize(session.getService()));
            buf.append(" / ");
            buf.append(serviceLimit);
            buf.append(" bytes, ");
        } else {
            buf.append(ReadThrottleFilter.getServiceBufferSize(session.getService()));
            buf.append(" / unlimited bytes, ");
        }
        buf.append("global: ");
        if (globalLimit != 0) {
            buf.append(ReadThrottleFilter.getGlobalBufferSize());
            buf.append(" / ");
            buf.append(globalLimit);
            buf.append(" bytes.");
        } else {
            buf.append(ReadThrottleFilter.getGlobalBufferSize());
            buf.append(" / unlimited bytes.");
        }
        return buf.toString();
    }

    private State getState(IoSession session) {
        State oldState;
        State state = (State)session.getAttribute(this.STATE);
        if (state == null && (oldState = (State)session.setAttributeIfAbsent(this.STATE, state = new State())) != null) {
            state = oldState;
        }
        return state;
    }

    public String toString() {
        return String.valueOf(ReadThrottleFilter.getGlobalBufferSize()) + '/' + this.getMaxGlobalBufferSize();
    }

    private static class State {
        private int sessionBufferSize;
        private boolean suspendedRead;
        private final Object logLock = new Object();
        private long lastLogTime = 0L;

        private State() {
        }
    }

    private class EnterFilter
    extends IoFilterAdapter {
        private EnterFilter() {
        }

        public void onPreRemove(IoFilterChain parent, String name, IoFilter.NextFilter nextFilter) throws Exception {
            try {
                parent.remove(ReadThrottleFilter.this);
            }
            catch (Exception e) {
                // empty catch block
            }
        }

        public void onPostRemove(IoFilterChain parent, String name, IoFilter.NextFilter nextFilter) throws Exception {
            parent.getSession().removeAttribute(ReadThrottleFilter.this.STATE);
        }

        public void messageReceived(IoFilter.NextFilter nextFilter, IoSession session, Object message) throws Exception {
            ReadThrottleFilter.this.enter(session, ReadThrottleFilter.this.estimateSize(message));
            nextFilter.messageReceived(session, message);
        }
    }
}

