/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.filter.ssl;

import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSession;
import org.apache.mina.common.AttributeKey;
import org.apache.mina.common.DefaultWriteFuture;
import org.apache.mina.common.IoBuffer;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoFilterAdapter;
import org.apache.mina.common.IoFilterChain;
import org.apache.mina.common.IoFuture;
import org.apache.mina.common.IoFutureListener;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.WriteFuture;
import org.apache.mina.common.WriteRequest;
import org.apache.mina.common.WriteRequestWrapper;
import org.apache.mina.common.WriteToClosedSessionException;
import org.apache.mina.filter.ssl.SslHandler;

public class SslFilter
extends IoFilterAdapter {
    public static final AttributeKey SSL_SESSION = new AttributeKey(SslFilter.class, "session");
    public static final AttributeKey DISABLE_ENCRYPTION_ONCE = new AttributeKey(SslFilter.class, "disableOnce");
    public static final AttributeKey USE_NOTIFICATION = new AttributeKey(SslFilter.class, "useNotification");
    public static final AttributeKey PEER_ADDRESS = new AttributeKey(SslFilter.class, "peerAddress");
    public static final SslFilterMessage SESSION_SECURED = new SslFilterMessage("SESSION_SECURED");
    public static final SslFilterMessage SESSION_UNSECURED = new SslFilterMessage("SESSION_UNSECURED");
    private static final AttributeKey NEXT_FILTER = new AttributeKey(SslFilter.class, "nextFilter");
    private static final AttributeKey SSL_HANDLER = new AttributeKey(SslFilter.class, "handler");
    private final SSLContext sslContext;
    private final boolean autoStart;
    private boolean client;
    private boolean needClientAuth;
    private boolean wantClientAuth;
    private String[] enabledCipherSuites;
    private String[] enabledProtocols;

    public SslFilter(SSLContext sslContext) {
        this(sslContext, true);
    }

    public SslFilter(SSLContext sslContext, boolean autoStart) {
        if (sslContext == null) {
            throw new NullPointerException("sslContext");
        }
        this.sslContext = sslContext;
        this.autoStart = autoStart;
    }

    public SSLSession getSslSession(IoSession session) {
        return (SSLSession)session.getAttribute(SSL_SESSION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startSsl(IoSession session) throws SSLException {
        boolean started;
        SslHandler handler;
        SslHandler sslHandler = handler = this.getSslSessionHandler(session);
        synchronized (sslHandler) {
            if (handler.isOutboundDone()) {
                IoFilter.NextFilter nextFilter = (IoFilter.NextFilter)session.getAttribute(NEXT_FILTER);
                handler.destroy();
                handler.init();
                handler.handshake(nextFilter);
                started = true;
            } else {
                started = false;
            }
        }
        handler.flushScheduledEvents();
        return started;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSslStarted(IoSession session) {
        SslHandler handler = this.getSslSessionHandler0(session);
        if (handler == null) {
            return false;
        }
        SslHandler sslHandler = handler;
        synchronized (sslHandler) {
            return !handler.isOutboundDone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WriteFuture stopSsl(IoSession session) throws SSLException {
        WriteFuture future;
        SslHandler handler = this.getSslSessionHandler(session);
        IoFilter.NextFilter nextFilter = (IoFilter.NextFilter)session.getAttribute(NEXT_FILTER);
        SslHandler sslHandler = handler;
        synchronized (sslHandler) {
            future = this.initiateClosure(nextFilter, session);
        }
        handler.flushScheduledEvents();
        return future;
    }

    public boolean isUseClientMode() {
        return this.client;
    }

    public void setUseClientMode(boolean clientMode) {
        this.client = clientMode;
    }

    public boolean isNeedClientAuth() {
        return this.needClientAuth;
    }

    public void setNeedClientAuth(boolean needClientAuth) {
        this.needClientAuth = needClientAuth;
    }

    public boolean isWantClientAuth() {
        return this.wantClientAuth;
    }

    public void setWantClientAuth(boolean wantClientAuth) {
        this.wantClientAuth = wantClientAuth;
    }

    public String[] getEnabledCipherSuites() {
        return this.enabledCipherSuites;
    }

    public void setEnabledCipherSuites(String[] cipherSuites) {
        this.enabledCipherSuites = cipherSuites;
    }

    public String[] getEnabledProtocols() {
        return this.enabledProtocols;
    }

    public void setEnabledProtocols(String[] protocols) {
        this.enabledProtocols = protocols;
    }

    public void onPreAdd(IoFilterChain parent, String name, IoFilter.NextFilter nextFilter) throws SSLException {
        if (parent.contains(SslFilter.class)) {
            throw new IllegalStateException("Only one " + SslFilter.class.getName() + " is permitted.");
        }
        IoSession session = parent.getSession();
        session.setAttribute(NEXT_FILTER, nextFilter);
        SslHandler handler = new SslHandler(this, this.sslContext, session);
        session.setAttribute(SSL_HANDLER, handler);
    }

    public void onPostAdd(IoFilterChain parent, String name, IoFilter.NextFilter nextFilter) throws SSLException {
        if (this.autoStart) {
            this.initiateHandshake(nextFilter, parent.getSession());
        }
    }

    public void onPreRemove(IoFilterChain parent, String name, IoFilter.NextFilter nextFilter) throws SSLException {
        IoSession session = parent.getSession();
        this.stopSsl(session);
        session.removeAttribute(NEXT_FILTER);
        session.removeAttribute(SSL_HANDLER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionClosed(IoFilter.NextFilter nextFilter, IoSession session) throws SSLException {
        SslHandler handler = this.getSslSessionHandler(session);
        try {
            SslHandler sslHandler = handler;
            synchronized (sslHandler) {
                handler.destroy();
            }
            handler.flushScheduledEvents();
        }
        finally {
            nextFilter.sessionClosed(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageReceived(IoFilter.NextFilter nextFilter, IoSession session, Object message) throws SSLException {
        SslHandler handler;
        SslHandler sslHandler = handler = this.getSslSessionHandler(session);
        synchronized (sslHandler) {
            if (!this.isSslStarted(session) && handler.isInboundDone()) {
                handler.scheduleMessageReceived(nextFilter, message);
            } else {
                IoBuffer buf = (IoBuffer)message;
                try {
                    handler.messageReceived(nextFilter, buf.buf());
                    this.handleSslData(nextFilter, handler);
                    if (handler.isInboundDone()) {
                        if (handler.isOutboundDone()) {
                            handler.destroy();
                        } else {
                            this.initiateClosure(nextFilter, session);
                        }
                        if (buf.hasRemaining()) {
                            handler.scheduleMessageReceived(nextFilter, buf);
                        }
                    }
                }
                catch (SSLException ssle2) {
                    SSLHandshakeException ssle2;
                    if (!handler.isHandshakeComplete()) {
                        SSLHandshakeException newSsle = new SSLHandshakeException("SSL handshake failed.");
                        newSsle.initCause(ssle2);
                        ssle2 = newSsle;
                    }
                    throw ssle2;
                }
            }
        }
        handler.flushScheduledEvents();
    }

    public void messageSent(IoFilter.NextFilter nextFilter, IoSession session, WriteRequest writeRequest) {
        if (writeRequest instanceof EncryptedWriteRequest) {
            EncryptedWriteRequest wrappedRequest = (EncryptedWriteRequest)writeRequest;
            nextFilter.messageSent(session, wrappedRequest.getParentRequest());
        }
    }

    public void exceptionCaught(IoFilter.NextFilter nextFilter, IoSession session, Throwable cause) throws Exception {
        if (cause instanceof WriteToClosedSessionException) {
            WriteToClosedSessionException e = (WriteToClosedSessionException)cause;
            List<WriteRequest> failedRequests = e.getRequests();
            boolean containsCloseNotify = false;
            for (WriteRequest r : failedRequests) {
                if (!this.isCloseNotify(r.getMessage())) continue;
                containsCloseNotify = true;
                break;
            }
            if (containsCloseNotify) {
                if (failedRequests.size() == 1) {
                    return;
                }
                ArrayList<WriteRequest> newFailedRequests = new ArrayList<WriteRequest>(failedRequests.size() - 1);
                for (WriteRequest r : failedRequests) {
                    if (this.isCloseNotify(r.getMessage())) continue;
                    newFailedRequests.add(r);
                }
                if (newFailedRequests.isEmpty()) {
                    return;
                }
                cause = new WriteToClosedSessionException(newFailedRequests, cause.getMessage(), cause.getCause());
            }
        }
        nextFilter.exceptionCaught(session, cause);
    }

    private boolean isCloseNotify(Object message) {
        if (!(message instanceof IoBuffer)) {
            return false;
        }
        IoBuffer buf = (IoBuffer)message;
        int offset = buf.position();
        return buf.remaining() == 23 && buf.get(offset + 0) == 21 && buf.get(offset + 1) == 3 && buf.get(offset + 2) == 1 && buf.get(offset + 3) == 0 && buf.get(offset + 4) == 18;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filterWrite(IoFilter.NextFilter nextFilter, IoSession session, WriteRequest writeRequest) throws SSLException {
        SslHandler handler;
        boolean needsFlush = true;
        SslHandler sslHandler = handler = this.getSslSessionHandler(session);
        synchronized (sslHandler) {
            if (!this.isSslStarted(session)) {
                handler.scheduleFilterWrite(nextFilter, writeRequest);
            } else if (session.containsAttribute(DISABLE_ENCRYPTION_ONCE)) {
                session.removeAttribute(DISABLE_ENCRYPTION_ONCE);
                handler.scheduleFilterWrite(nextFilter, writeRequest);
            } else {
                IoBuffer buf = (IoBuffer)writeRequest.getMessage();
                if (handler.isWritingEncryptedData()) {
                    handler.scheduleFilterWrite(nextFilter, writeRequest);
                } else if (handler.isHandshakeComplete()) {
                    int pos = buf.position();
                    handler.encrypt(buf.buf());
                    buf.position(pos);
                    IoBuffer encryptedBuffer = handler.fetchOutNetBuffer();
                    handler.scheduleFilterWrite(nextFilter, new EncryptedWriteRequest(writeRequest, encryptedBuffer));
                } else {
                    if (session.isConnected()) {
                        handler.schedulePreHandshakeWriteRequest(nextFilter, writeRequest);
                    }
                    needsFlush = false;
                }
            }
        }
        if (needsFlush) {
            handler.flushScheduledEvents();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filterClose(final IoFilter.NextFilter nextFilter, final IoSession session) throws SSLException {
        SslHandler handler = this.getSslSessionHandler0(session);
        if (handler == null) {
            nextFilter.filterClose(session);
            return;
        }
        WriteFuture future = null;
        try {
            SslHandler sslHandler = handler;
            synchronized (sslHandler) {
                if (this.isSslStarted(session)) {
                    future = this.initiateClosure(nextFilter, session);
                    future.addListener(new IoFutureListener<IoFuture>(){

                        @Override
                        public void operationComplete(IoFuture future) {
                            nextFilter.filterClose(session);
                        }
                    });
                }
            }
            handler.flushScheduledEvents();
        }
        finally {
            if (future == null) {
                nextFilter.filterClose(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initiateHandshake(IoFilter.NextFilter nextFilter, IoSession session) throws SSLException {
        SslHandler handler;
        SslHandler sslHandler = handler = this.getSslSessionHandler(session);
        synchronized (sslHandler) {
            handler.handshake(nextFilter);
        }
        handler.flushScheduledEvents();
    }

    private WriteFuture initiateClosure(IoFilter.NextFilter nextFilter, IoSession session) throws SSLException {
        SslHandler handler = this.getSslSessionHandler(session);
        if (!handler.closeOutbound()) {
            return DefaultWriteFuture.newNotWrittenFuture(session, new IllegalStateException("SSL session is shut down already."));
        }
        WriteFuture future = handler.writeNetBuffer(nextFilter);
        if (future == null) {
            future = DefaultWriteFuture.newWrittenFuture(session);
        }
        if (handler.isInboundDone()) {
            handler.destroy();
        }
        if (session.containsAttribute(USE_NOTIFICATION)) {
            handler.scheduleMessageReceived(nextFilter, SESSION_UNSECURED);
        }
        return future;
    }

    private void handleSslData(IoFilter.NextFilter nextFilter, SslHandler handler) throws SSLException {
        if (handler.isHandshakeComplete()) {
            handler.flushPreHandshakeEvents();
        }
        handler.writeNetBuffer(nextFilter);
        this.handleAppDataRead(nextFilter, handler);
    }

    private void handleAppDataRead(IoFilter.NextFilter nextFilter, SslHandler handler) {
        IoBuffer readBuffer = handler.fetchAppBuffer();
        if (readBuffer.hasRemaining()) {
            handler.scheduleMessageReceived(nextFilter, readBuffer);
        }
    }

    private SslHandler getSslSessionHandler(IoSession session) {
        SslHandler handler = this.getSslSessionHandler0(session);
        if (handler == null) {
            throw new IllegalStateException();
        }
        if (handler.getParent() != this) {
            throw new IllegalArgumentException("Not managed by this filter.");
        }
        return handler;
    }

    private SslHandler getSslSessionHandler0(IoSession session) {
        return (SslHandler)session.getAttribute(SSL_HANDLER);
    }

    private static class EncryptedWriteRequest
    extends WriteRequestWrapper {
        private final IoBuffer encryptedMessage;

        private EncryptedWriteRequest(WriteRequest writeRequest, IoBuffer encryptedMessage) {
            super(writeRequest);
            this.encryptedMessage = encryptedMessage;
        }

        public Object getMessage() {
            return this.encryptedMessage;
        }
    }

    public static class SslFilterMessage {
        private final String name;

        private SslFilterMessage(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

