/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.filter.reqres;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.mina.common.AttributeKey;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoFilterChain;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.WriteRequest;
import org.apache.mina.filter.reqres.Request;
import org.apache.mina.filter.reqres.RequestTimeoutException;
import org.apache.mina.filter.reqres.Response;
import org.apache.mina.filter.reqres.ResponseInspector;
import org.apache.mina.filter.reqres.ResponseInspectorFactory;
import org.apache.mina.filter.reqres.ResponseType;
import org.apache.mina.filter.util.WriteRequestFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestResponseFilter
extends WriteRequestFilter {
    private final AttributeKey RESPONSE_INSPECTOR = new AttributeKey(this.getClass(), "responseInspector");
    private final AttributeKey REQUEST_STORE = new AttributeKey(this.getClass(), "requestStore");
    private final AttributeKey UNRESPONDED_REQUEST_STORE = new AttributeKey(this.getClass(), "unrespondedRequestStore");
    private final ResponseInspectorFactory responseInspectorFactory;
    private final ScheduledExecutorService timeoutScheduler;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public RequestResponseFilter(final ResponseInspector responseInspector, ScheduledExecutorService timeoutScheduler) {
        if (responseInspector == null) {
            throw new NullPointerException("responseInspector");
        }
        if (timeoutScheduler == null) {
            throw new NullPointerException("timeoutScheduler");
        }
        this.responseInspectorFactory = new ResponseInspectorFactory(){

            public ResponseInspector getResponseInspector() {
                return responseInspector;
            }
        };
        this.timeoutScheduler = timeoutScheduler;
    }

    public RequestResponseFilter(ResponseInspectorFactory responseInspectorFactory, ScheduledExecutorService timeoutScheduler) {
        if (responseInspectorFactory == null) {
            throw new NullPointerException("responseInspectorFactory");
        }
        if (timeoutScheduler == null) {
            throw new NullPointerException("timeoutScheduler");
        }
        this.responseInspectorFactory = responseInspectorFactory;
        this.timeoutScheduler = timeoutScheduler;
    }

    @Override
    public void onPreAdd(IoFilterChain parent, String name, IoFilter.NextFilter nextFilter) throws Exception {
        if (parent.contains(this)) {
            throw new IllegalArgumentException("You can't add the same filter instance more than once.  Create another instance and add it.");
        }
        IoSession session = parent.getSession();
        session.setAttribute(this.RESPONSE_INSPECTOR, this.responseInspectorFactory.getResponseInspector());
        session.setAttribute(this.REQUEST_STORE, this.createRequestStore(session));
        session.setAttribute(this.UNRESPONDED_REQUEST_STORE, this.createUnrespondedRequestStore(session));
    }

    @Override
    public void onPostRemove(IoFilterChain parent, String name, IoFilter.NextFilter nextFilter) throws Exception {
        IoSession session = parent.getSession();
        this.destroyUnrespondedRequestStore(this.getUnrespondedRequestStore(session));
        this.destroyRequestStore(this.getRequestStore(session));
        session.removeAttribute(this.UNRESPONDED_REQUEST_STORE);
        session.removeAttribute(this.REQUEST_STORE);
        session.removeAttribute(this.RESPONSE_INSPECTOR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void messageReceived(IoFilter.NextFilter nextFilter, IoSession session, Object message) throws Exception {
        Request request;
        ResponseInspector responseInspector = (ResponseInspector)session.getAttribute(this.RESPONSE_INSPECTOR);
        Object requestId = responseInspector.getRequestId(message);
        if (requestId == null) {
            nextFilter.messageReceived(session, message);
            return;
        }
        ResponseType type = responseInspector.getResponseType(message);
        if (type == null) {
            nextFilter.exceptionCaught(session, new IllegalStateException(responseInspector.getClass().getName() + "#getResponseType() may not return null."));
        }
        Map<Object, Request> requestStore = this.getRequestStore(session);
        switch (type) {
            case WHOLE: 
            case PARTIAL_LAST: {
                Map<Object, Request> map = requestStore;
                synchronized (map) {
                    request = requestStore.remove(requestId);
                    break;
                }
            }
            case PARTIAL: {
                Map<Object, Request> map = requestStore;
                synchronized (map) {
                    request = requestStore.get(requestId);
                    break;
                }
            }
            default: {
                throw new InternalError();
            }
        }
        if (request == null) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Unknown request ID '" + requestId + "' for the response message. Timed out already?: " + message);
            }
        } else {
            ScheduledFuture<?> scheduledFuture;
            if (type != ResponseType.PARTIAL && (scheduledFuture = request.getTimeoutFuture()) != null) {
                Set<Request> unrespondedRequests;
                scheduledFuture.cancel(false);
                Set<Request> set = unrespondedRequests = this.getUnrespondedRequestStore(session);
                synchronized (set) {
                    unrespondedRequests.remove(request);
                }
            }
            Response response = new Response(request, message, type);
            request.signal(response);
            nextFilter.messageReceived(session, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object doFilterWrite(IoFilter.NextFilter nextFilter, IoSession session, WriteRequest writeRequest) throws Exception {
        Set<Request> unrespondedRequests;
        Object message = writeRequest.getMessage();
        if (!(message instanceof Request)) {
            return null;
        }
        Request request = (Request)message;
        if (request.getTimeoutFuture() != null) {
            throw new IllegalArgumentException("Request can not be reused.");
        }
        Map<Object, Request> requestStore = this.getRequestStore(session);
        Request oldValue = null;
        Object requestId = request.getId();
        Map<Object, Request> map = requestStore;
        synchronized (map) {
            oldValue = requestStore.get(requestId);
            if (oldValue == null) {
                requestStore.put(requestId, request);
            }
        }
        if (oldValue != null) {
            throw new IllegalStateException("Duplicate request ID: " + request.getId());
        }
        TimeoutTask timeoutTask = new TimeoutTask(nextFilter, request, session);
        ScheduledFuture<?> timeoutFuture = this.timeoutScheduler.schedule(timeoutTask, request.getTimeoutMillis(), TimeUnit.MILLISECONDS);
        request.setTimeoutTask(timeoutTask);
        request.setTimeoutFuture(timeoutFuture);
        Set<Request> set = unrespondedRequests = this.getUnrespondedRequestStore(session);
        synchronized (set) {
            unrespondedRequests.add(request);
        }
        return request.getMessage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sessionClosed(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
        Map<Object, Request> requestStore;
        ArrayList<Request> unrespondedRequestsCopy;
        Set<Request> unrespondedRequests;
        Set<Request> set = unrespondedRequests = this.getUnrespondedRequestStore(session);
        synchronized (set) {
            unrespondedRequestsCopy = new ArrayList<Request>(unrespondedRequests);
            unrespondedRequests.clear();
        }
        for (Request r : unrespondedRequestsCopy) {
            if (!r.getTimeoutFuture().cancel(false)) continue;
            r.getTimeoutTask().run();
        }
        Map<Object, Request> map = requestStore = this.getRequestStore(session);
        synchronized (map) {
            requestStore.clear();
        }
        nextFilter.sessionClosed(session);
    }

    private Map<Object, Request> getRequestStore(IoSession session) {
        return (Map)session.getAttribute(this.REQUEST_STORE);
    }

    private Set<Request> getUnrespondedRequestStore(IoSession session) {
        return (Set)session.getAttribute(this.UNRESPONDED_REQUEST_STORE);
    }

    protected Map<Object, Request> createRequestStore(IoSession session) {
        return new HashMap<Object, Request>();
    }

    protected Set<Request> createUnrespondedRequestStore(IoSession session) {
        return new LinkedHashSet<Request>();
    }

    protected void destroyRequestStore(Map<Object, Request> requestStore) {
    }

    protected void destroyUnrespondedRequestStore(Set<Request> unrespondedRequestStore) {
    }

    private class TimeoutTask
    implements Runnable {
        private final IoFilter.NextFilter filter;
        private final Request request;
        private final IoSession session;

        private TimeoutTask(IoFilter.NextFilter filter, Request request, IoSession session) {
            this.filter = filter;
            this.request = request;
            this.session = session;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            boolean timedOut;
            Set unrespondedRequests = RequestResponseFilter.this.getUnrespondedRequestStore(this.session);
            if (unrespondedRequests != null) {
                Set set = unrespondedRequests;
                synchronized (set) {
                    unrespondedRequests.remove(this.request);
                }
            }
            Map requestStore = RequestResponseFilter.this.getRequestStore(this.session);
            Object requestId = this.request.getId();
            Map map = requestStore;
            synchronized (map) {
                if (requestStore.get(requestId) == this.request) {
                    requestStore.remove(requestId);
                    timedOut = true;
                } else {
                    timedOut = false;
                }
            }
            if (timedOut) {
                RequestTimeoutException e = new RequestTimeoutException(this.request);
                this.request.signal(e);
                this.filter.exceptionCaught(this.session, e);
            }
        }
    }
}

