/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.filter.firewall;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoFilterAdapter;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.WriteRequest;
import org.apache.mina.filter.firewall.Subnet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlacklistFilter
extends IoFilterAdapter {
    private final List<Subnet> blacklist = new CopyOnWriteArrayList<Subnet>();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public void setBlacklist(InetAddress[] addresses) {
        if (addresses == null) {
            throw new NullPointerException("addresses");
        }
        this.blacklist.clear();
        for (int i = 0; i < addresses.length; ++i) {
            InetAddress addr = addresses[i];
            this.block(addr);
        }
    }

    public void setSubnetBlacklist(Subnet[] subnets) {
        if (subnets == null) {
            throw new NullPointerException("Subnets must not be null");
        }
        this.blacklist.clear();
        for (Subnet subnet : subnets) {
            this.block(subnet);
        }
    }

    public void setBlacklist(Iterable<InetAddress> addresses) {
        if (addresses == null) {
            throw new NullPointerException("addresses");
        }
        this.blacklist.clear();
        for (InetAddress address : addresses) {
            this.block(address);
        }
    }

    public void setSubnetBlacklist(Iterable<Subnet> subnets) {
        if (subnets == null) {
            throw new NullPointerException("Subnets must not be null");
        }
        this.blacklist.clear();
        for (Subnet subnet : subnets) {
            this.block(subnet);
        }
    }

    public void block(InetAddress address) {
        if (address == null) {
            throw new NullPointerException("Adress to block can not be null");
        }
        this.block(new Subnet(address, 32));
    }

    public void block(Subnet subnet) {
        if (subnet == null) {
            throw new NullPointerException("Subnet can not be null");
        }
        this.blacklist.add(subnet);
    }

    public void unblock(InetAddress address) {
        if (address == null) {
            throw new NullPointerException("Adress to unblock can not be null");
        }
        this.unblock(new Subnet(address, 32));
    }

    public void unblock(Subnet subnet) {
        if (subnet == null) {
            throw new NullPointerException("Subnet can not be null");
        }
        this.blacklist.remove(subnet);
    }

    @Override
    public void sessionCreated(IoFilter.NextFilter nextFilter, IoSession session) {
        if (!this.isBlocked(session)) {
            nextFilter.sessionCreated(session);
        } else {
            this.blockSession(session);
        }
    }

    @Override
    public void sessionOpened(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
        if (!this.isBlocked(session)) {
            nextFilter.sessionOpened(session);
        } else {
            this.blockSession(session);
        }
    }

    @Override
    public void sessionClosed(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
        if (!this.isBlocked(session)) {
            nextFilter.sessionClosed(session);
        } else {
            this.blockSession(session);
        }
    }

    @Override
    public void sessionIdle(IoFilter.NextFilter nextFilter, IoSession session, IdleStatus status) throws Exception {
        if (!this.isBlocked(session)) {
            nextFilter.sessionIdle(session, status);
        } else {
            this.blockSession(session);
        }
    }

    @Override
    public void messageReceived(IoFilter.NextFilter nextFilter, IoSession session, Object message) {
        if (!this.isBlocked(session)) {
            nextFilter.messageReceived(session, message);
        } else {
            this.blockSession(session);
        }
    }

    @Override
    public void messageSent(IoFilter.NextFilter nextFilter, IoSession session, WriteRequest writeRequest) throws Exception {
        if (!this.isBlocked(session)) {
            nextFilter.messageSent(session, writeRequest);
        } else {
            this.blockSession(session);
        }
    }

    private void blockSession(IoSession session) {
        this.logger.warn("Remote address in the blacklist; closing.");
        session.close();
    }

    private boolean isBlocked(IoSession session) {
        SocketAddress remoteAddress = session.getRemoteAddress();
        if (remoteAddress instanceof InetSocketAddress) {
            InetAddress address = ((InetSocketAddress)remoteAddress).getAddress();
            for (Subnet subnet : this.blacklist) {
                if (!subnet.inSubnet(address)) continue;
                return true;
            }
        }
        return false;
    }
}

