/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.common;

import java.io.IOException;
import java.net.SocketAddress;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import org.apache.mina.common.AbstractIoAcceptor;
import org.apache.mina.common.AbstractIoSession;
import org.apache.mina.common.AbstractIoSessionConfig;
import org.apache.mina.common.DefaultIoFilterChain;
import org.apache.mina.common.DefaultIoSessionDataStructureFactory;
import org.apache.mina.common.DefaultTransportMetadata;
import org.apache.mina.common.FileRegion;
import org.apache.mina.common.IoFilterChain;
import org.apache.mina.common.IoFuture;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoHandlerAdapter;
import org.apache.mina.common.IoProcessor;
import org.apache.mina.common.IoService;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.IoSessionConfig;
import org.apache.mina.common.TransportMetadata;
import org.apache.mina.common.WriteRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DummySession
extends AbstractIoSession {
    private static final TransportMetadata TRANSPORT_METADATA = new DefaultTransportMetadata("mina", "dummy", false, false, SocketAddress.class, IoSessionConfig.class, Object.class);
    private static final SocketAddress ANONYMOUS_ADDRESS = new SocketAddress(){
        private static final long serialVersionUID = -496112902353454179L;

        public String toString() {
            return "?";
        }
    };
    private volatile IoService service;
    private volatile IoSessionConfig config = new AbstractIoSessionConfig(){

        protected void doSetAll(IoSessionConfig config) {
        }
    };
    private final IoFilterChain filterChain = new DefaultIoFilterChain(this);
    private final IoProcessor<IoSession> processor;
    private volatile IoHandler handler = new IoHandlerAdapter();
    private volatile SocketAddress localAddress = ANONYMOUS_ADDRESS;
    private volatile SocketAddress remoteAddress = ANONYMOUS_ADDRESS;
    private volatile TransportMetadata transportMetadata = TRANSPORT_METADATA;

    public DummySession() {
        AbstractIoAcceptor acceptor = new AbstractIoAcceptor(new AbstractIoSessionConfig(){

            protected void doSetAll(IoSessionConfig config) {
            }
        }, new Executor(){

            public void execute(Runnable command) {
            }
        }){

            @Override
            protected Set<SocketAddress> bind0(List<? extends SocketAddress> localAddresses) throws Exception {
                throw new UnsupportedOperationException();
            }

            @Override
            protected void unbind0(List<? extends SocketAddress> localAddresses) throws Exception {
                throw new UnsupportedOperationException();
            }

            @Override
            public IoSession newSession(SocketAddress remoteAddress, SocketAddress localAddress) {
                throw new UnsupportedOperationException();
            }

            @Override
            public TransportMetadata getTransportMetadata() {
                return TRANSPORT_METADATA;
            }

            @Override
            protected IoFuture dispose0() throws Exception {
                return null;
            }
        };
        acceptor.setHandler(new IoHandlerAdapter());
        this.service = acceptor;
        this.processor = new IoProcessor<IoSession>(){

            @Override
            public void add(IoSession session) {
            }

            @Override
            public void flush(IoSession session) {
                DummySession s = (DummySession)session;
                WriteRequest req = s.getWriteRequestQueue().poll(session);
                Object m = req.getMessage();
                if (m instanceof FileRegion) {
                    FileRegion file = (FileRegion)m;
                    try {
                        file.getFileChannel().position(file.getPosition() + file.getRemainingBytes());
                        file.update(file.getRemainingBytes());
                    }
                    catch (IOException e) {
                        s.getFilterChain().fireExceptionCaught(e);
                    }
                }
                DummySession.this.getFilterChain().fireMessageSent(req);
            }

            @Override
            public void remove(IoSession session) {
            }

            @Override
            public void updateTrafficMask(IoSession session) {
            }

            @Override
            public void dispose() {
            }

            @Override
            public boolean isDisposed() {
                return false;
            }

            @Override
            public boolean isDisposing() {
                return false;
            }
        };
        try {
            DefaultIoSessionDataStructureFactory factory = new DefaultIoSessionDataStructureFactory();
            this.setAttributeMap(factory.getAttributeMap(this));
            this.setWriteRequestQueue(factory.getWriteRequestQueue(this));
        }
        catch (Exception e) {
            throw new InternalError();
        }
    }

    @Override
    public IoSessionConfig getConfig() {
        return this.config;
    }

    public void setConfig(IoSessionConfig config) {
        if (config == null) {
            throw new NullPointerException("config");
        }
        this.config = config;
    }

    @Override
    public IoFilterChain getFilterChain() {
        return this.filterChain;
    }

    @Override
    public IoHandler getHandler() {
        return this.handler;
    }

    public void setHandler(IoHandler handler) {
        if (handler == null) {
            throw new NullPointerException("handler");
        }
        this.handler = handler;
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.localAddress;
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public void setLocalAddress(SocketAddress localAddress) {
        if (localAddress == null) {
            throw new NullPointerException("localAddress");
        }
        this.localAddress = localAddress;
    }

    public void setRemoteAddress(SocketAddress remoteAddress) {
        if (remoteAddress == null) {
            throw new NullPointerException("remoteAddress");
        }
        this.remoteAddress = remoteAddress;
    }

    @Override
    public IoService getService() {
        return this.service;
    }

    public void setService(IoService service) {
        if (service == null) {
            throw new NullPointerException("service");
        }
        this.service = service;
    }

    @Override
    protected final IoProcessor<IoSession> getProcessor() {
        return this.processor;
    }

    @Override
    public TransportMetadata getTransportMetadata() {
        return this.transportMetadata;
    }

    public void setTransportMetadata(TransportMetadata transportMetadata) {
        if (transportMetadata == null) {
            throw new NullPointerException("transportMetadata");
        }
        this.transportMetadata = transportMetadata;
    }

    @Override
    public void setScheduledWriteBytes(int byteCount) {
        super.setScheduledWriteBytes(byteCount);
    }

    @Override
    public void setScheduledWriteMessages(int messages) {
        super.setScheduledWriteMessages(messages);
    }

    public void updateThroughput(boolean force) {
        super.updateThroughput(System.currentTimeMillis(), force);
    }
}

