/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.common;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.mina.common.AbstractIoSession;
import org.apache.mina.common.ConnectFuture;
import org.apache.mina.common.DefaultIoFilterChain;
import org.apache.mina.common.DefaultIoFilterChainBuilder;
import org.apache.mina.common.DefaultIoFuture;
import org.apache.mina.common.DefaultIoSessionDataStructureFactory;
import org.apache.mina.common.ExceptionMonitor;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.IdleStatusChecker;
import org.apache.mina.common.IoFilterChainBuilder;
import org.apache.mina.common.IoFuture;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoService;
import org.apache.mina.common.IoServiceListener;
import org.apache.mina.common.IoServiceListenerSupport;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.IoSessionConfig;
import org.apache.mina.common.IoSessionDataStructureFactory;
import org.apache.mina.common.IoSessionInitializationException;
import org.apache.mina.common.IoSessionInitializer;
import org.apache.mina.common.IoUtil;
import org.apache.mina.common.WriteFuture;
import org.apache.mina.util.NamePreservingRunnable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractIoService
implements IoService {
    private static final AtomicInteger id = new AtomicInteger();
    private final IoServiceListener serviceActivationListener = new IoServiceListener(){

        public void serviceActivated(IoService service) {
            AbstractIoService s = (AbstractIoService)service;
            s.setLastReadTime(s.getActivationTime());
            s.setLastWriteTime(s.getActivationTime());
            s.lastThroughputCalculationTime = s.getActivationTime();
            AbstractIoService.this.idleStatusChecker.addService(s);
        }

        public void serviceDeactivated(IoService service) {
            AbstractIoService.this.idleStatusChecker.removeService((AbstractIoService)service);
        }

        public void serviceIdle(IoService service, IdleStatus idleStatus) {
        }

        public void sessionCreated(IoSession session) {
        }

        public void sessionDestroyed(IoSession session) {
        }
    };
    private IoFilterChainBuilder filterChainBuilder = new DefaultIoFilterChainBuilder();
    private IoHandler handler;
    private IoSessionDataStructureFactory sessionDataStructureFactory = new DefaultIoSessionDataStructureFactory();
    private final IoServiceListenerSupport listeners;
    private final Executor executor;
    private final String threadName;
    private final boolean createdExecutor;
    protected final Object disposalLock = new Object();
    private volatile boolean disposing;
    private volatile boolean disposed;
    private IoFuture disposalFuture;
    private final AtomicLong readBytes = new AtomicLong();
    private final AtomicLong writtenBytes = new AtomicLong();
    private final AtomicLong readMessages = new AtomicLong();
    private final AtomicLong writtenMessages = new AtomicLong();
    private long lastReadTime;
    private long lastWriteTime;
    private final AtomicInteger scheduledWriteBytes = new AtomicInteger();
    private final AtomicInteger scheduledWriteMessages = new AtomicInteger();
    private final Object throughputCalculationLock = new Object();
    private int throughputCalculationInterval = 3;
    private long lastThroughputCalculationTime;
    private long lastReadBytes;
    private long lastWrittenBytes;
    private long lastReadMessages;
    private long lastWrittenMessages;
    private double readBytesThroughput;
    private double writtenBytesThroughput;
    private double readMessagesThroughput;
    private double writtenMessagesThroughput;
    private double largestReadBytesThroughput;
    private double largestWrittenBytesThroughput;
    private double largestReadMessagesThroughput;
    private double largestWrittenMessagesThroughput;
    private final IdleStatusChecker idleStatusChecker = new IdleStatusChecker();
    private final Object idlenessCheckLock = new Object();
    private int idleTimeForRead;
    private int idleTimeForWrite;
    private int idleTimeForBoth;
    private int idleCountForBoth;
    private int idleCountForRead;
    private int idleCountForWrite;
    private long lastIdleTimeForBoth;
    private long lastIdleTimeForRead;
    private long lastIdleTimeForWrite;
    private final IoSessionConfig sessionConfig;

    protected AbstractIoService(IoSessionConfig sessionConfig, Executor executor) {
        if (sessionConfig == null) {
            throw new NullPointerException("sessionConfig");
        }
        if (!this.getTransportMetadata().getSessionConfigType().isAssignableFrom(sessionConfig.getClass())) {
            throw new IllegalArgumentException("sessionConfig type: " + sessionConfig.getClass() + " (expected: " + this.getTransportMetadata().getSessionConfigType() + ")");
        }
        this.listeners = new IoServiceListenerSupport(this);
        this.listeners.add(this.serviceActivationListener);
        this.sessionConfig = sessionConfig;
        ExceptionMonitor.getInstance();
        if (executor == null) {
            this.executor = Executors.newCachedThreadPool();
            this.createdExecutor = true;
        } else {
            this.executor = executor;
            this.createdExecutor = false;
        }
        this.threadName = this.getClass().getSimpleName() + '-' + id.incrementAndGet();
        this.executeWorker(this.idleStatusChecker.getNotifyingTask(), "idleStatusChecker");
    }

    @Override
    public final IoFilterChainBuilder getFilterChainBuilder() {
        return this.filterChainBuilder;
    }

    @Override
    public final void setFilterChainBuilder(IoFilterChainBuilder builder) {
        if (builder == null) {
            builder = new DefaultIoFilterChainBuilder();
        }
        this.filterChainBuilder = builder;
    }

    @Override
    public final DefaultIoFilterChainBuilder getFilterChain() {
        if (this.filterChainBuilder instanceof DefaultIoFilterChainBuilder) {
            return (DefaultIoFilterChainBuilder)this.filterChainBuilder;
        }
        throw new IllegalStateException("Current filter chain builder is not a DefaultIoFilterChainBuilder.");
    }

    @Override
    public final void addListener(IoServiceListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public final void removeListener(IoServiceListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public final boolean isActive() {
        return this.listeners.isActive();
    }

    @Override
    public final boolean isDisposing() {
        return this.disposing;
    }

    @Override
    public final boolean isDisposed() {
        return this.disposed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void dispose() {
        IoFuture disposalFuture;
        if (this.disposed) {
            return;
        }
        Object object = this.disposalLock;
        synchronized (object) {
            disposalFuture = this.disposalFuture;
            if (!this.disposing) {
                this.disposing = true;
                try {
                    this.disposalFuture = disposalFuture = this.dispose0();
                }
                catch (Exception e) {
                    ExceptionMonitor.getInstance().exceptionCaught(e);
                }
                finally {
                    if (disposalFuture == null) {
                        this.disposed = true;
                    }
                }
            }
        }
        this.idleStatusChecker.getNotifyingTask().cancel();
        if (disposalFuture != null) {
            disposalFuture.awaitUninterruptibly();
        }
        if (this.createdExecutor) {
            ExecutorService e = (ExecutorService)this.executor;
            e.shutdown();
            while (!e.isTerminated()) {
                try {
                    e.awaitTermination(Integer.MAX_VALUE, TimeUnit.SECONDS);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        this.disposed = true;
    }

    protected abstract IoFuture dispose0() throws Exception;

    @Override
    public final Set<IoSession> getManagedSessions() {
        return this.listeners.getManagedSessions();
    }

    @Override
    public final long getCumulativeManagedSessionCount() {
        return this.listeners.getCumulativeManagedSessionCount();
    }

    @Override
    public final int getLargestManagedSessionCount() {
        return this.listeners.getLargestManagedSessionCount();
    }

    @Override
    public final int getManagedSessionCount() {
        return this.listeners.getManagedSessionCount();
    }

    @Override
    public final IoHandler getHandler() {
        return this.handler;
    }

    @Override
    public final void setHandler(IoHandler handler) {
        if (handler == null) {
            throw new NullPointerException("handler");
        }
        if (this.isActive()) {
            throw new IllegalStateException("handler cannot be set while the service is active.");
        }
        this.handler = handler;
    }

    @Override
    public IoSessionConfig getSessionConfig() {
        return this.sessionConfig;
    }

    @Override
    public final IoSessionDataStructureFactory getSessionDataStructureFactory() {
        return this.sessionDataStructureFactory;
    }

    @Override
    public final void setSessionDataStructureFactory(IoSessionDataStructureFactory sessionDataStructureFactory) {
        if (sessionDataStructureFactory == null) {
            throw new NullPointerException("sessionDataStructureFactory");
        }
        if (this.isActive()) {
            throw new IllegalStateException("sessionDataStructureFactory cannot be set while the service is active.");
        }
        this.sessionDataStructureFactory = sessionDataStructureFactory;
    }

    @Override
    public final long getReadBytes() {
        return this.readBytes.get();
    }

    protected final void increaseReadBytes(long increment, long currentTime) {
        this.readBytes.addAndGet(increment);
        this.lastReadTime = currentTime;
        this.idleCountForBoth = 0;
        this.idleCountForRead = 0;
    }

    @Override
    public final long getReadMessages() {
        return this.readMessages.get();
    }

    protected final void increaseReadMessages(long currentTime) {
        this.readMessages.incrementAndGet();
        this.lastReadTime = currentTime;
        this.idleCountForBoth = 0;
        this.idleCountForRead = 0;
    }

    @Override
    public final int getThroughputCalculationInterval() {
        return this.throughputCalculationInterval;
    }

    @Override
    public final void setThroughputCalculationInterval(int throughputCalculationInterval) {
        if (throughputCalculationInterval < 0) {
            throw new IllegalArgumentException("throughputCalculationInterval: " + throughputCalculationInterval);
        }
        this.throughputCalculationInterval = throughputCalculationInterval;
    }

    @Override
    public final long getThroughputCalculationIntervalInMillis() {
        return (long)this.throughputCalculationInterval * 1000L;
    }

    @Override
    public final double getReadBytesThroughput() {
        this.resetThroughput();
        return this.readBytesThroughput;
    }

    @Override
    public final double getWrittenBytesThroughput() {
        this.resetThroughput();
        return this.writtenBytesThroughput;
    }

    @Override
    public final double getReadMessagesThroughput() {
        this.resetThroughput();
        return this.readMessagesThroughput;
    }

    @Override
    public final double getWrittenMessagesThroughput() {
        this.resetThroughput();
        return this.writtenMessagesThroughput;
    }

    @Override
    public final double getLargestReadBytesThroughput() {
        return this.largestReadBytesThroughput;
    }

    @Override
    public final double getLargestWrittenBytesThroughput() {
        return this.largestWrittenBytesThroughput;
    }

    @Override
    public final double getLargestReadMessagesThroughput() {
        return this.largestReadMessagesThroughput;
    }

    @Override
    public final double getLargestWrittenMessagesThroughput() {
        return this.largestWrittenMessagesThroughput;
    }

    private void resetThroughput() {
        if (this.getManagedSessionCount() == 0) {
            this.readBytesThroughput = 0.0;
            this.writtenBytesThroughput = 0.0;
            this.readMessagesThroughput = 0.0;
            this.writtenMessagesThroughput = 0.0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateThroughput(long currentTime) {
        Object object = this.throughputCalculationLock;
        synchronized (object) {
            int interval = (int)(currentTime - this.lastThroughputCalculationTime);
            long minInterval = this.getThroughputCalculationIntervalInMillis();
            if (minInterval == 0L || (long)interval < minInterval) {
                return;
            }
            long readBytes = this.readBytes.get();
            long writtenBytes = this.writtenBytes.get();
            long readMessages = this.readMessages.get();
            long writtenMessages = this.writtenMessages.get();
            this.readBytesThroughput = (double)(readBytes - this.lastReadBytes) * 1000.0 / (double)interval;
            this.writtenBytesThroughput = (double)(writtenBytes - this.lastWrittenBytes) * 1000.0 / (double)interval;
            this.readMessagesThroughput = (double)(readMessages - this.lastReadMessages) * 1000.0 / (double)interval;
            this.writtenMessagesThroughput = (double)(writtenMessages - this.lastWrittenMessages) * 1000.0 / (double)interval;
            if (this.readBytesThroughput > this.largestReadBytesThroughput) {
                this.largestReadBytesThroughput = this.readBytesThroughput;
            }
            if (this.writtenBytesThroughput > this.largestWrittenBytesThroughput) {
                this.largestWrittenBytesThroughput = this.writtenBytesThroughput;
            }
            if (this.readMessagesThroughput > this.largestReadMessagesThroughput) {
                this.largestReadMessagesThroughput = this.readMessagesThroughput;
            }
            if (this.writtenMessagesThroughput > this.largestWrittenMessagesThroughput) {
                this.largestWrittenMessagesThroughput = this.writtenMessagesThroughput;
            }
            this.lastReadBytes = readBytes;
            this.lastWrittenBytes = writtenBytes;
            this.lastReadMessages = readMessages;
            this.lastWrittenMessages = writtenMessages;
            this.lastThroughputCalculationTime = currentTime;
        }
    }

    @Override
    public final int getScheduledWriteBytes() {
        return this.scheduledWriteBytes.get();
    }

    protected final void increaseScheduledWriteBytes(int increment) {
        this.scheduledWriteBytes.addAndGet(increment);
    }

    @Override
    public final int getScheduledWriteMessages() {
        return this.scheduledWriteMessages.get();
    }

    protected final void increaseScheduledWriteMessages() {
        this.scheduledWriteMessages.incrementAndGet();
    }

    protected final void decreaseScheduledWriteMessages() {
        this.scheduledWriteMessages.decrementAndGet();
    }

    @Override
    public final long getActivationTime() {
        return this.listeners.getActivationTime();
    }

    @Override
    public final long getLastIoTime() {
        return Math.max(this.lastReadTime, this.lastWriteTime);
    }

    @Override
    public final long getLastReadTime() {
        return this.lastReadTime;
    }

    protected final void setLastReadTime(long lastReadTime) {
        this.lastReadTime = lastReadTime;
    }

    @Override
    public final long getLastWriteTime() {
        return this.lastWriteTime;
    }

    protected final void setLastWriteTime(long lastWriteTime) {
        this.lastWriteTime = lastWriteTime;
    }

    @Override
    public final long getWrittenBytes() {
        return this.writtenBytes.get();
    }

    protected final void increaseWrittenBytes(long increment, long currentTime) {
        this.writtenBytes.addAndGet(increment);
        this.lastWriteTime = currentTime;
        this.idleCountForBoth = 0;
        this.idleCountForWrite = 0;
    }

    @Override
    public final long getWrittenMessages() {
        return this.writtenMessages.get();
    }

    protected final void increaseWrittenMessages(long currentTime) {
        this.writtenMessages.incrementAndGet();
        this.lastWriteTime = currentTime;
        this.idleCountForBoth = 0;
        this.idleCountForWrite = 0;
    }

    @Override
    public final int getIdleTime(IdleStatus status) {
        if (status == IdleStatus.BOTH_IDLE) {
            return this.idleTimeForBoth;
        }
        if (status == IdleStatus.READER_IDLE) {
            return this.idleTimeForRead;
        }
        if (status == IdleStatus.WRITER_IDLE) {
            return this.idleTimeForWrite;
        }
        throw new IllegalArgumentException("Unknown idle status: " + status);
    }

    @Override
    public final long getIdleTimeInMillis(IdleStatus status) {
        return (long)this.getIdleTime(status) * 1000L;
    }

    @Override
    public final void setIdleTime(IdleStatus status, int idleTime) {
        if (idleTime < 0) {
            throw new IllegalArgumentException("Illegal idle time: " + idleTime);
        }
        if (status == IdleStatus.BOTH_IDLE) {
            this.idleTimeForBoth = idleTime;
        } else if (status == IdleStatus.READER_IDLE) {
            this.idleTimeForRead = idleTime;
        } else if (status == IdleStatus.WRITER_IDLE) {
            this.idleTimeForWrite = idleTime;
        } else {
            throw new IllegalArgumentException("Unknown idle status: " + status);
        }
        if (idleTime == 0) {
            if (status == IdleStatus.BOTH_IDLE) {
                this.idleCountForBoth = 0;
            } else if (status == IdleStatus.READER_IDLE) {
                this.idleCountForRead = 0;
            } else if (status == IdleStatus.WRITER_IDLE) {
                this.idleCountForWrite = 0;
            }
        }
    }

    @Override
    public final boolean isIdle(IdleStatus status) {
        if (status == IdleStatus.BOTH_IDLE) {
            return this.idleCountForBoth > 0;
        }
        if (status == IdleStatus.READER_IDLE) {
            return this.idleCountForRead > 0;
        }
        if (status == IdleStatus.WRITER_IDLE) {
            return this.idleCountForWrite > 0;
        }
        throw new IllegalArgumentException("Unknown idle status: " + status);
    }

    @Override
    public final int getIdleCount(IdleStatus status) {
        if (status == IdleStatus.BOTH_IDLE) {
            return this.idleCountForBoth;
        }
        if (status == IdleStatus.READER_IDLE) {
            return this.idleCountForRead;
        }
        if (status == IdleStatus.WRITER_IDLE) {
            return this.idleCountForWrite;
        }
        throw new IllegalArgumentException("Unknown idle status: " + status);
    }

    @Override
    public final long getLastIdleTime(IdleStatus status) {
        if (status == IdleStatus.BOTH_IDLE) {
            return this.lastIdleTimeForBoth;
        }
        if (status == IdleStatus.READER_IDLE) {
            return this.lastIdleTimeForRead;
        }
        if (status == IdleStatus.WRITER_IDLE) {
            return this.lastIdleTimeForWrite;
        }
        throw new IllegalArgumentException("Unknown idle status: " + status);
    }

    private void increaseIdleCount(IdleStatus status, long currentTime) {
        if (status == IdleStatus.BOTH_IDLE) {
            ++this.idleCountForBoth;
            this.lastIdleTimeForBoth = currentTime;
        } else if (status == IdleStatus.READER_IDLE) {
            ++this.idleCountForRead;
            this.lastIdleTimeForRead = currentTime;
        } else if (status == IdleStatus.WRITER_IDLE) {
            ++this.idleCountForWrite;
            this.lastIdleTimeForWrite = currentTime;
        } else {
            throw new IllegalArgumentException("Unknown idle status: " + status);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void notifyIdleness(long currentTime) {
        this.updateThroughput(currentTime);
        Object object = this.idlenessCheckLock;
        synchronized (object) {
            this.notifyIdleness(currentTime, this.getIdleTimeInMillis(IdleStatus.BOTH_IDLE), IdleStatus.BOTH_IDLE, Math.max(this.getLastIoTime(), this.getLastIdleTime(IdleStatus.BOTH_IDLE)));
            this.notifyIdleness(currentTime, this.getIdleTimeInMillis(IdleStatus.READER_IDLE), IdleStatus.READER_IDLE, Math.max(this.getLastReadTime(), this.getLastIdleTime(IdleStatus.READER_IDLE)));
            this.notifyIdleness(currentTime, this.getIdleTimeInMillis(IdleStatus.WRITER_IDLE), IdleStatus.WRITER_IDLE, Math.max(this.getLastWriteTime(), this.getLastIdleTime(IdleStatus.WRITER_IDLE)));
        }
    }

    private void notifyIdleness(long currentTime, long idleTime, IdleStatus status, long lastIoTime) {
        if (idleTime > 0L && lastIoTime != 0L && currentTime - lastIoTime >= idleTime) {
            this.increaseIdleCount(status, currentTime);
            this.listeners.fireServiceIdle(status);
        }
    }

    @Override
    public final int getBothIdleCount() {
        return this.getIdleCount(IdleStatus.BOTH_IDLE);
    }

    @Override
    public final long getLastBothIdleTime() {
        return this.getLastIdleTime(IdleStatus.BOTH_IDLE);
    }

    @Override
    public final long getLastReaderIdleTime() {
        return this.getLastIdleTime(IdleStatus.READER_IDLE);
    }

    @Override
    public final long getLastWriterIdleTime() {
        return this.getLastIdleTime(IdleStatus.WRITER_IDLE);
    }

    @Override
    public final int getReaderIdleCount() {
        return this.getIdleCount(IdleStatus.READER_IDLE);
    }

    @Override
    public final int getWriterIdleCount() {
        return this.getIdleCount(IdleStatus.WRITER_IDLE);
    }

    @Override
    public final int getBothIdleTime() {
        return this.getIdleTime(IdleStatus.BOTH_IDLE);
    }

    @Override
    public final long getBothIdleTimeInMillis() {
        return this.getIdleTimeInMillis(IdleStatus.BOTH_IDLE);
    }

    @Override
    public final int getReaderIdleTime() {
        return this.getIdleTime(IdleStatus.READER_IDLE);
    }

    @Override
    public final long getReaderIdleTimeInMillis() {
        return this.getIdleTimeInMillis(IdleStatus.READER_IDLE);
    }

    @Override
    public final int getWriterIdleTime() {
        return this.getIdleTime(IdleStatus.WRITER_IDLE);
    }

    @Override
    public final long getWriterIdleTimeInMillis() {
        return this.getIdleTimeInMillis(IdleStatus.WRITER_IDLE);
    }

    @Override
    public final boolean isBothIdle() {
        return this.isIdle(IdleStatus.BOTH_IDLE);
    }

    @Override
    public final boolean isReaderIdle() {
        return this.isIdle(IdleStatus.READER_IDLE);
    }

    @Override
    public final boolean isWriterIdle() {
        return this.isIdle(IdleStatus.WRITER_IDLE);
    }

    @Override
    public final void setBothIdleTime(int idleTime) {
        this.setIdleTime(IdleStatus.BOTH_IDLE, idleTime);
    }

    @Override
    public final void setReaderIdleTime(int idleTime) {
        this.setIdleTime(IdleStatus.READER_IDLE, idleTime);
    }

    @Override
    public final void setWriterIdleTime(int idleTime) {
        this.setIdleTime(IdleStatus.WRITER_IDLE, idleTime);
    }

    @Override
    public final Set<WriteFuture> broadcast(Object message) {
        final List<WriteFuture> futures = IoUtil.broadcast(message, this.getManagedSessions());
        return new AbstractSet<WriteFuture>(){

            @Override
            public Iterator<WriteFuture> iterator() {
                return futures.iterator();
            }

            @Override
            public int size() {
                return futures.size();
            }
        };
    }

    protected final IoServiceListenerSupport getListeners() {
        return this.listeners;
    }

    protected final IdleStatusChecker getIdleStatusChecker() {
        return this.idleStatusChecker;
    }

    protected final void executeWorker(Runnable worker) {
        this.executeWorker(worker, null);
    }

    protected final void executeWorker(Runnable worker, String suffix) {
        String actualThreadName = this.threadName;
        if (suffix != null) {
            actualThreadName = actualThreadName + '-' + suffix;
        }
        this.executor.execute(new NamePreservingRunnable(worker, actualThreadName));
    }

    protected final void finishSessionInitialization(IoSession session, IoFuture future, IoSessionInitializer sessionInitializer) {
        if (this.getLastReadTime() == 0L) {
            this.setLastReadTime(this.getActivationTime());
        }
        if (this.getLastWriteTime() == 0L) {
            this.setLastWriteTime(this.getActivationTime());
        }
        try {
            ((AbstractIoSession)session).setAttributeMap(session.getService().getSessionDataStructureFactory().getAttributeMap(session));
        }
        catch (IoSessionInitializationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IoSessionInitializationException("Failed to initialize an attributeMap.", e);
        }
        try {
            ((AbstractIoSession)session).setWriteRequestQueue(session.getService().getSessionDataStructureFactory().getWriteRequestQueue(session));
        }
        catch (IoSessionInitializationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IoSessionInitializationException("Failed to initialize a writeRequestQueue.", e);
        }
        if (future != null && future instanceof ConnectFuture) {
            session.setAttribute(DefaultIoFilterChain.SESSION_CREATED_FUTURE, future);
        }
        if (sessionInitializer != null) {
            sessionInitializer.initializeSession(session, future);
        }
        this.finishSessionInitialization0(session, future);
    }

    protected void finishSessionInitialization0(IoSession session, IoFuture future) {
    }

    protected static class ServiceOperationFuture
    extends DefaultIoFuture {
        public ServiceOperationFuture() {
            super(null);
        }

        public final boolean isDone() {
            return this.getValue() == Boolean.TRUE;
        }

        public final void setDone() {
            this.setValue(Boolean.TRUE);
        }

        public final Exception getException() {
            if (this.getValue() instanceof Exception) {
                return (Exception)this.getValue();
            }
            return null;
        }

        public final void setException(Exception exception) {
            if (exception == null) {
                throw new NullPointerException("exception");
            }
            this.setValue(exception);
        }
    }
}

