Here we keep tools for automated testing of Themis
across the supported platforms.
(Though, the tools are accessible to humans as well.)

- [**keygen_tool**](keygen_tool.rs) —
  a tool for generating ECDSA keys 
- <b>scell_*_string_echo</b> —
  encrypt or decrypt a string using Secure Cell
  - [**scell_context_string_echo**](scell_context_string_echo.rs) —
    sealing mode
  - [**scell_token_string_echo**](scell_token_string_echo.rs) —
    token protect mode
  - [**scell_context_string_echo**](scell_context_string_echo.rs) —
    context imprint mode
- [**smessage_encryption**](smessage_encryption.rs) —
  encrypt, decrypt, sign and verify a string using Secure Message

You can run a particular tool with Cargo like this:

```
$ cargo run --example keygen_tool -- --help
keygen_tool 0.0.3
Generating ECDSA key pairs.

USAGE:
    keygen_tool [ARGS]

FLAGS:
    -h, --help       Prints help information
    -V, --version    Prints version information

ARGS:
    <private>    Private key file (default: key)
    <public>     Public key file (default: key.pub)
```


## keygen_tool

This tool can be used to generate key files usable by other tools.

Themis supports RSA keys for some use-cases,
but most of the features expect ECDSA keys.


## scell_*_string_echo

This is a family of command-line tools used for testing Secure Cell.

All of them accept plaintext input and produce base64-encoded encrypted output
(or vice versa for decryption).
The _user context_ can be provided as an optional last argument.

Token protect mode produces and accepts _two_ comma-separated strings:
the encrypted data followed by the authentication token:

```
$ cargo run --example scell_token_string_echo -- enc password input
KEYSbKY=,AAEBQAwAAAAQAAAABQAAAEPGcrB2ftqZT7fDEZYMS1ab3+iLGoOOAx/D3X4=

$ cargo run --example scell_token_string_echo -- dec password KEYSbKY=,AAEBQAwAAAAQAAAABQAAAEPGcrB2ftqZT7fDEZYMS1ab3+iLGoOOAx/D3X4=
input
```


## smessage_encryption

This is a universal tool used for testing Secure Message.

The first argument determines the action to perform:

- `enc`: encrypt message
- `dec`: encrypt message
- `sign`: sign message
- `verify`: verify signature

After that come paths to files with a pair of private and public keys.
Suitable keys can be generated by the [keygen_tool](#keygen_tool).

Finally, you specify a message to encrypt or sign as plaintext,
or base64-encoded ciphertext to decrypt or verify.
