package soter

import (
	"testing"

	"github.com/cossacklabs/themis/docs/reference-implementation/soter"
	"github.com/cossacklabs/themis/gothemis/keys"
)

// Asymmetric keys generated by GoThemis are packed into Soter containers.

func TestECKeyHeaders(t *testing.T) {
	keypair, err := keys.New(keys.TypeEC)
	if err != nil {
		t.Fatal(err)
	}
	public, remaining := soter.ParseSoterContainer(keypair.Public.Value)
	if len(remaining) != 0 {
		t.Error("public key has extra bytes")
	}
	if public.Tag() != "UEC2" {
		t.Error("unexpected public key tag:", public.Tag())
	}
	private, remaining := soter.ParseSoterContainer(keypair.Private.Value)
	if len(remaining) != 0 {
		t.Error("private key has extra bytes")
	}
	if private.Tag() != "REC2" {
		t.Error("unexpected private key tag:", private.Tag())
	}
}

func TestRSAKeyHeaders(t *testing.T) {
	keypair, err := keys.New(keys.TypeRSA)
	if err != nil {
		t.Fatal(err)
	}
	public, remaining := soter.ParseSoterContainer(keypair.Public.Value)
	if len(remaining) != 0 {
		t.Error("public key has extra bytes")
	}
	if public.Tag() != "URA2" {
		t.Error("unexpected public key tag:", public.Tag())
	}
	private, remaining := soter.ParseSoterContainer(keypair.Private.Value)
	if len(remaining) != 0 {
		t.Error("private key has extra bytes")
	}
	if private.Tag() != "RRA2" {
		t.Error("unexpected private key tag:", private.Tag())
	}
}
