// Copyright 2018 (c) rust-themis developers
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

//! Raw FFI bindings to libthemis.

#![allow(non_upper_case_globals)]
#![allow(non_camel_case_types)]
#![allow(non_snake_case)]
// For some weird reasons Clippy gets run on this crate as it's a path dependency of themis.
// This should not happen (see https://github.com/rust-lang-nursery/rust-clippy/issues/1066)
// but until that's fixed again, disable all lints which get triggered by the code generated
// by bindgen.
#![allow(clippy::all)]

// DO NOT EDIT.
//
// This file is automatically generated by "bindgen.sh".
// Instead of editing it by hand, rerun the script.

pub const THEMIS_SUCCESS: u32 = 0;
pub const THEMIS_SSESSION_SEND_OUTPUT_TO_PEER: u32 = 1;
pub const THEMIS_FAIL: u32 = 11;
pub const THEMIS_INVALID_PARAMETER: u32 = 12;
pub const THEMIS_NO_MEMORY: u32 = 13;
pub const THEMIS_BUFFER_TOO_SMALL: u32 = 14;
pub const THEMIS_DATA_CORRUPT: u32 = 15;
pub const THEMIS_INVALID_SIGNATURE: u32 = 16;
pub const THEMIS_NOT_SUPPORTED: u32 = 17;
pub const THEMIS_SSESSION_KA_NOT_FINISHED: u32 = 19;
pub const THEMIS_SSESSION_TRANSPORT_ERROR: u32 = 20;
pub const THEMIS_SSESSION_GET_PUB_FOR_ID_CALLBACK_ERROR: u32 = 21;
pub const THEMIS_SCOMPARE_SEND_OUTPUT_TO_PEER: u32 = 1;
pub const THEMIS_SCOMPARE_MATCH: u32 = 21;
pub const THEMIS_SCOMPARE_NO_MATCH: u32 = 22;
pub const THEMIS_SCOMPARE_NOT_READY: u32 = 0;
pub const STATE_IDLE: u32 = 0;
pub const STATE_NEGOTIATING: u32 = 1;
pub const STATE_ESTABLISHED: u32 = 2;
pub type themis_status_t = i32;
extern "C" {
    pub fn themis_secure_cell_encrypt_seal(
        master_key: *const u8,
        master_key_length: usize,
        user_context: *const u8,
        user_context_length: usize,
        message: *const u8,
        message_length: usize,
        encrypted_message: *mut u8,
        encrypted_message_length: *mut usize,
    ) -> themis_status_t;
}
extern "C" {
    pub fn themis_secure_cell_decrypt_seal(
        master_key: *const u8,
        master_key_length: usize,
        user_context: *const u8,
        user_context_length: usize,
        encrypted_message: *const u8,
        encrypted_message_length: usize,
        plain_message: *mut u8,
        plain_message_length: *mut usize,
    ) -> themis_status_t;
}
extern "C" {
    pub fn themis_secure_cell_encrypt_seal_with_passphrase(
        passphrase: *const u8,
        passphrase_length: usize,
        user_context: *const u8,
        user_context_length: usize,
        message: *const u8,
        message_length: usize,
        encrypted_message: *mut u8,
        encrypted_message_length: *mut usize,
    ) -> themis_status_t;
}
extern "C" {
    pub fn themis_secure_cell_decrypt_seal_with_passphrase(
        passphrase: *const u8,
        passphrase_length: usize,
        user_context: *const u8,
        user_context_length: usize,
        encrypted_message: *const u8,
        encrypted_message_length: usize,
        plain_message: *mut u8,
        plain_message_length: *mut usize,
    ) -> themis_status_t;
}
extern "C" {
    pub fn themis_secure_cell_encrypt_token_protect(
        master_key: *const u8,
        master_key_length: usize,
        user_context: *const u8,
        user_context_length: usize,
        message: *const u8,
        message_length: usize,
        context: *mut u8,
        context_length: *mut usize,
        encrypted_message: *mut u8,
        encrypted_message_length: *mut usize,
    ) -> themis_status_t;
}
extern "C" {
    pub fn themis_secure_cell_decrypt_token_protect(
        master_key: *const u8,
        master_key_length: usize,
        user_context: *const u8,
        user_context_length: usize,
        encrypted_message: *const u8,
        encrypted_message_length: usize,
        context: *const u8,
        context_length: usize,
        plain_message: *mut u8,
        plain_message_length: *mut usize,
    ) -> themis_status_t;
}
extern "C" {
    pub fn themis_secure_cell_encrypt_context_imprint(
        master_key: *const u8,
        master_key_length: usize,
        message: *const u8,
        message_length: usize,
        context: *const u8,
        context_length: usize,
        encrypted_message: *mut u8,
        encrypted_message_length: *mut usize,
    ) -> themis_status_t;
}
extern "C" {
    pub fn themis_secure_cell_decrypt_context_imprint(
        master_key: *const u8,
        master_key_length: usize,
        encrypted_message: *const u8,
        encrypted_message_length: usize,
        context: *const u8,
        context_length: usize,
        plain_message: *mut u8,
        plain_message_length: *mut usize,
    ) -> themis_status_t;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct secure_comparator_type {
    _unused: [u8; 0],
}
pub type secure_comparator_t = secure_comparator_type;
extern "C" {
    pub fn secure_comparator_create() -> *mut secure_comparator_t;
}
extern "C" {
    pub fn secure_comparator_destroy(comp_ctx: *mut secure_comparator_t) -> themis_status_t;
}
extern "C" {
    pub fn secure_comparator_append_secret(
        comp_ctx: *mut secure_comparator_t,
        secret_data: *const ::std::os::raw::c_void,
        secret_data_length: usize,
    ) -> themis_status_t;
}
extern "C" {
    pub fn secure_comparator_begin_compare(
        comp_ctx: *mut secure_comparator_t,
        compare_data: *mut ::std::os::raw::c_void,
        compare_data_length: *mut usize,
    ) -> themis_status_t;
}
extern "C" {
    pub fn secure_comparator_proceed_compare(
        comp_ctx: *mut secure_comparator_t,
        peer_compare_data: *const ::std::os::raw::c_void,
        peer_compare_data_length: usize,
        compare_data: *mut ::std::os::raw::c_void,
        compare_data_length: *mut usize,
    ) -> themis_status_t;
}
extern "C" {
    pub fn secure_comparator_get_result(comp_ctx: *const secure_comparator_t) -> themis_status_t;
}
extern "C" {
    pub fn themis_gen_sym_key(key: *mut u8, key_length: *mut usize) -> themis_status_t;
}
extern "C" {
    pub fn themis_gen_rsa_key_pair(
        private_key: *mut u8,
        private_key_length: *mut usize,
        public_key: *mut u8,
        public_key_length: *mut usize,
    ) -> themis_status_t;
}
extern "C" {
    pub fn themis_gen_ec_key_pair(
        private_key: *mut u8,
        private_key_length: *mut usize,
        public_key: *mut u8,
        public_key_length: *mut usize,
    ) -> themis_status_t;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum themis_key_kind {
    THEMIS_KEY_INVALID = 0,
    THEMIS_KEY_RSA_PRIVATE = 1,
    THEMIS_KEY_RSA_PUBLIC = 2,
    THEMIS_KEY_EC_PRIVATE = 3,
    THEMIS_KEY_EC_PUBLIC = 4,
}
pub use self::themis_key_kind as themis_key_kind_t;
extern "C" {
    pub fn themis_get_asym_key_kind(key: *const u8, length: usize) -> themis_key_kind_t;
}
extern "C" {
    pub fn themis_is_valid_asym_key(key: *const u8, length: usize) -> themis_status_t;
}
extern "C" {
    pub fn themis_secure_message_encrypt(
        private_key: *const u8,
        private_key_length: usize,
        public_key: *const u8,
        public_key_length: usize,
        message: *const u8,
        message_length: usize,
        encrypted_message: *mut u8,
        encrypted_message_length: *mut usize,
    ) -> themis_status_t;
}
extern "C" {
    pub fn themis_secure_message_decrypt(
        private_key: *const u8,
        private_key_length: usize,
        public_key: *const u8,
        public_key_length: usize,
        encrypted_message: *const u8,
        encrypted_message_length: usize,
        message: *mut u8,
        message_length: *mut usize,
    ) -> themis_status_t;
}
extern "C" {
    pub fn themis_secure_message_sign(
        private_key: *const u8,
        private_key_length: usize,
        message: *const u8,
        message_length: usize,
        signed_message: *mut u8,
        signed_message_length: *mut usize,
    ) -> themis_status_t;
}
extern "C" {
    pub fn themis_secure_message_verify(
        public_key: *const u8,
        public_key_length: usize,
        signed_message: *const u8,
        signed_message_length: usize,
        message: *mut u8,
        message_length: *mut usize,
    ) -> themis_status_t;
}
extern "C" {
    pub fn themis_secure_message_wrap(
        private_key: *const u8,
        private_key_length: usize,
        public_key: *const u8,
        public_key_length: usize,
        message: *const u8,
        message_length: usize,
        wrapped_message: *mut u8,
        wrapped_message_length: *mut usize,
    ) -> themis_status_t;
}
extern "C" {
    pub fn themis_secure_message_unwrap(
        private_key: *const u8,
        private_key_length: usize,
        public_key: *const u8,
        public_key_length: usize,
        wrapped_message: *const u8,
        wrapped_message_length: usize,
        message: *mut u8,
        message_length: *mut usize,
    ) -> themis_status_t;
}
pub type send_protocol_data_callback = ::std::option::Option<
    unsafe extern "C" fn(
        data: *const u8,
        data_length: usize,
        user_data: *mut ::std::os::raw::c_void,
    ) -> isize,
>;
pub type receive_protocol_data_callback = ::std::option::Option<
    unsafe extern "C" fn(
        data: *mut u8,
        data_length: usize,
        user_data: *mut ::std::os::raw::c_void,
    ) -> isize,
>;
pub type protocol_state_changed_callback = ::std::option::Option<
    unsafe extern "C" fn(event: ::std::os::raw::c_int, user_data: *mut ::std::os::raw::c_void),
>;
pub type get_public_key_for_id_callback = ::std::option::Option<
    unsafe extern "C" fn(
        id: *const ::std::os::raw::c_void,
        id_length: usize,
        key_buffer: *mut ::std::os::raw::c_void,
        key_buffer_length: usize,
        user_data: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct secure_session_user_callbacks_type {
    pub send_data: send_protocol_data_callback,
    pub receive_data: receive_protocol_data_callback,
    pub state_changed: protocol_state_changed_callback,
    pub get_public_key_for_id: get_public_key_for_id_callback,
    pub user_data: *mut ::std::os::raw::c_void,
}
pub type secure_session_user_callbacks_t = secure_session_user_callbacks_type;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct secure_session_type {
    _unused: [u8; 0],
}
pub type secure_session_t = secure_session_type;
extern "C" {
    pub fn secure_session_create(
        id: *const ::std::os::raw::c_void,
        id_length: usize,
        sign_key: *const ::std::os::raw::c_void,
        sign_key_length: usize,
        user_callbacks: *const secure_session_user_callbacks_t,
    ) -> *mut secure_session_t;
}
extern "C" {
    pub fn secure_session_destroy(session_ctx: *mut secure_session_t) -> themis_status_t;
}
extern "C" {
    pub fn secure_session_connect(session_ctx: *mut secure_session_t) -> themis_status_t;
}
extern "C" {
    pub fn secure_session_generate_connect_request(
        session_ctx: *mut secure_session_t,
        output: *mut ::std::os::raw::c_void,
        output_length: *mut usize,
    ) -> themis_status_t;
}
extern "C" {
    pub fn secure_session_wrap(
        session_ctx: *mut secure_session_t,
        message: *const ::std::os::raw::c_void,
        message_length: usize,
        wrapped_message: *mut ::std::os::raw::c_void,
        wrapped_message_length: *mut usize,
    ) -> themis_status_t;
}
extern "C" {
    pub fn secure_session_unwrap(
        session_ctx: *mut secure_session_t,
        wrapped_message: *const ::std::os::raw::c_void,
        wrapped_message_length: usize,
        message: *mut ::std::os::raw::c_void,
        message_length: *mut usize,
    ) -> themis_status_t;
}
extern "C" {
    pub fn secure_session_send(
        session_ctx: *mut secure_session_t,
        message: *const ::std::os::raw::c_void,
        message_length: usize,
    ) -> isize;
}
extern "C" {
    pub fn secure_session_receive(
        session_ctx: *mut secure_session_t,
        message: *mut ::std::os::raw::c_void,
        message_length: usize,
    ) -> isize;
}
extern "C" {
    pub fn secure_session_save(
        session_ctx: *const secure_session_t,
        out: *mut ::std::os::raw::c_void,
        out_length: *mut usize,
    ) -> themis_status_t;
}
extern "C" {
    pub fn secure_session_load(
        session_ctx: *mut secure_session_t,
        in_: *const ::std::os::raw::c_void,
        in_length: usize,
        user_callbacks: *const secure_session_user_callbacks_t,
    ) -> themis_status_t;
}
extern "C" {
    pub fn secure_session_is_established(session_ctx: *const secure_session_t) -> bool;
}
extern "C" {
    pub fn secure_session_get_remote_id(
        session_ctx: *const secure_session_t,
        id: *mut u8,
        id_length: *mut usize,
    ) -> themis_status_t;
}
