# RustThemis

[![crates.io][crates-io-badge]][crates-io]
[![RustThemis][github-ci-badge]][github-ci]
[![License][license-badge]][license]

_Rust_ wrapper for [Themis] crypto library.

Themis is an open-source high-level cryptographic services library that provides secure data exchange, authentication, and storage protection.
Themis provides ready-made building components, which simplifies the usage of core cryptographic security operations.

[Themis]: https://github.com/cossacklabs/themis
[crates-io]: https://crates.io/crates/themis
[crates-io-badge]: https://img.shields.io/crates/v/themis.svg
[github-ci]: https://github.com/cossacklabs/themis/actions?query=workflow%3ARustThemis
[github-ci-badge]: https://github.com/cossacklabs/themis/workflows/RustThemis/badge.svg
[license]: LICENSE
[license-badge]: https://img.shields.io/crates/l/themis.svg

## Getting started

RustThemis requires native Themis library to be installed.
Please refer to the [installation instructions][install].

See also:

 - [In-depth documentation on our Documentation Server][Documentation Server]
 - [RustThemis user guide][user guide]
 - [RustThemis API documentation on Docs.rs][Docs.rs]
 - [Changelog on GitHub][CHANGELOG]

You can start experimenting with [Examples]
or take a look at [Tests]
to get a feeling of how Themis can be used.

[install]: https://docs.cossacklabs.com/themis/languages/rust/installation/
[user guide]: https://docs.cossacklabs.com/themis/languages/rust/
[Docs.rs]: https://docs.rs/themis
[Documentation Server]: https://docs.cossacklabs.com/themis/
[CHANGELOG]: /CHANGELOG.md
[Examples]: /docs/examples/rust
[Tests]: /tests/rust

## Licensing

The code is distributed under [Apache 2.0 license](LICENSE).
